---
layout: post
comments: true
date: '2024-02-26 13:23 -0500'
title: 'Fair Use Week 2024: The Taper’s Greatest Fair Use Hits, and a Taper Swan Song'
published: true
---
This little blog [debuted](http://thetaper.library.virginia.edu/2016/11/02/welcome-to-the-taper.html) way back in early November 2016 (a more innocent time in so many ways), with a post about the big ideas behind copyright. That post is worth revisiting - I think it holds up! But it’s an unusual post for this blog in one sense: it doesn’t say a word about fair use! Over the ensuing 7-plus years, though, fair use was a common recurring topic, and this fair use week I’m going to indulge in a little nostalgia by surfacing some of the Taper’s Greatest Fair Use Hits over the years. The first installment is...

## [“For text- and data-mining, fair use is powerful, but possession is still 9/10 of the law.”](http://thetaper.library.virginia.edu/2018/02/28/for-text-and-data-mining-fair-use-is-powerful-but-possession-is-still-9-10-of-the-law-sparc.html)(Feb. 28, 2018).

This essay was [cross-posted on SPARC’s site](https://sparcopen.org/news/2018/possession-is-still-9-10-of-the-law/) and its core thesis is that the work of groups like SPARC to reform scholarly publishing and encourage open access and scholar-owned or scholar-led infrastructure is also crucial for fair use. Why? Because publishers can increasingly use their exclusive physical control over huge catalogs of works as a way to nullify fair use. Here’s why:

> [U]nfortunately, fair use rights do not include a legal right of access to a physical copy.(The case on point is Universal City Studios, Inc. v. Corley, 273 F.3d 429 (2d Cir. 2001), a case about the Digital Millennium Copyright Act (DMCA).... [T]he holding in that…recognize[s] the fundamental distinction between a right to use a work and a right to access a particular copy of that work. Again, copyright is concerned primarily with the former, intangible thing.) A work may enter the public domain and be free for all to copy and share, but if no one has a copy to work from when the term of protection runs out, it will remain lost to history.… In this way, fair use is similar to the First Amendment’s right to speak, which does not ensure a right to access to the means of mass communication.

I think about this piece a lot when I talk about text and data-mining, which is a form of research that relies on access to large datasets that may include in-copyright works. If these datasets don’t exist somewhere free of copyright holder control, then the copyright holders may exercise a veto over fair uses of this data.

Attentive readers may notice potential implications of this principle for the currently hot dispute over artificial intelligence. Watch this space tomorrow for a new essay (to be cross-posted, as always, at the Harvard Fair Use Week blog) on how the way someone acquires the copy they use may impact their fair use rights, and whether it should. 

Finally, I want to say that this week will be the last week that I’ll be adding new posts to The Taper. As this job has evolved, it has made less and less sense to spend time regularly writing and publishing in the way that’s needed to build and sustain an audience. Put simply, I don’t think it makes sense to continue to publish here on a sporadic basis rather than in venues with existing audiences where more people are likely to find and read what I want to say. For UVA audiences, that means publishing in the Library News blog or similar places. And for audiences beyond UVA, that means publishing as a guest with established outlets like SPARC where more readers are interested in these specific topics. We’ll be archiving the Taper and saving it to Libra (naturally) for posterity. We’ll share a link here and/or redirect there once we get that done.
 