---
layout: post
published: true
comments: true
date: '2023-10-03 15:31 -0400'
title: 'WIP: How the Library Supports Open Access Publishing'
---
This fall I'm working on a new Libguide to help UVA authors who are interested in open access publishing but struggling to make sense of the complex landscape of options. Below is a draft of one of the first elements of that guide: a summary of the ways the Library funds open access publishing, and the ways we don't, and why. 

# How the Library Supports Open Access Publishing

**In a nutshell:** The Library supports open access publishing in a variety of ways, including LibraOpen, which is free to any UVA-affiliated author. The Library does not have a fund to pay article processing charges, a fee sometimes charged by publishers for open access publication of a work. This is because paying individual APC payments is an inequitable, unsustainable financial model for libraries.

**Longer version:**

The Library supports open access publishing in several ways:

-	We host and support the Libra suite of open repositories, which offer free, discoverable, feature-rich, durable open access hosting for UVA-affiliated authors. Libra includes:

	1. LibraOpen: a repository for articles, book chapters, presentation slides, and other products of research, other than data.
	2.	LibraData: a place for UVA-affiliated researchers to share data publicly 
	3. LibraETD: a repository for electronic theses and dissertations authored by UVA graduate students as part of their degree requirements.

- We host Aperio, an open access press that publishes high-quality, peer-reviewed journals, books, and other works in collaboration with UVA affiliates, at no charge to authors or readers.

- We provide information and consultation about copyright and related legal issues for authors who would like to understand their rights, publishing contracts, funder mandates, and the ways they can make their work available open access at low- or no cost.

- We sponsor and support open publishing platforms that are free to authors and readers like arXiv and SCOAP3. These are frequently used by UVA researchers, and they avoid inequities caused by price barriers.

- We join VIVA-negotiated collective agreements that lower or eliminate APCs with select publishers for corresponding authors in VIVA institutions.

The Library does not pay or subsidize individual Article Processing Charges or other OA fees to publishers on behalf of authors. Here’s why:

- Depositing an appropriate version in Libra is always available to all UVA authors as a no-cost way of making their work open access.

- A pilot APC funding program offered by the Library from 2013-2017 found that 

	1. the cost of vetting and processing individual requests for APC support was unsustainable, 

	2. the program did not contribute to changing the journal landscape in favor of equitable open access, and 

	3. authors who sought funding were concentrated in a few departments, so the program wasn’t meeting campus-wide needs.

- The APC fees charged by most publishers are too high and are growing too fast.

- Most publishers who charge fees for open access in subscription journals (so-called “hybrid” open access) also “double dip” by continuing to charge high subscription fees for the same journals. This is unfair and unhealthy for the ecosystem.

- There is no mechanism for controlling the cost of APC fees or preventing double-dipping when the Library doesn’t negotiate collectively and directly with the publisher. 

- APCs are an inequitable form of support for open access publishing that creates barriers for authors who lack access to funding. 

- Paying or subsidizing high APC fees distorts the market for open access publishing and undermines innovative low- and no-cost open access publishers who would otherwise attract authors willing to consider price as a factor in their choice of where to publish.

Authors who wish to publish in journals that require APCs or other fees as a condition to publish may seek funding support from their department or include the cost of publishing in their grant proposals. 
