---
layout: post
published: true
comments: true
date: '2023-03-22 12:46 -0400'
title: Oral Arguments in *Hachette v. Internet Archive*
---

Judge John Koeltl of the Southern District of New York heard oral arguments in the *[Hachette v. Internet Archive](https://www.courtlistener.com/docket/17211300/hachette-book-group-inc-v-internet-archive/?page=1)* case this past Monday. I listened in via telephone, along with hundreds of others, as the parties pressed their core arguments with the judge, and the judge asked questions that might reveal what his key concerns are at this stage. The Authors Alliance has an excellent recap of the arguments [here](https://www.authorsalliance.org/2023/03/20/judge-hears-oral-arguments-in-hachette-book-group-v-internet-archive/). Below is my quick summary of the case and my own brief thoughts on the argument.

The case involves the Internet Archive’s “controlled digital lending” (CDL) program, which makes digital versions of physical books in a library’s collection available to read online subject to access limitations that imitate the lending of a physical book. Since this process necessarily involves copying and distributing the books, it raises copyright questions and has drawn the ire of the publishers. While the Archive has only partnered with a handful of public library systems for its [Open Library program](https://openlibrary.org), many libraries and library groups, including our own VIVA consortium here in Virginia, are exploring CDL as a possible solution to particular access challenges or for particular kinds of works. So, while the lawsuit was triggered by the Archive's implementation of CDL (and in particular, its arguably not-so-controlled National Emergency Library program, which temporarily made books available online without as many limits on access) The outcome of this case could reverberate throughout the library community.

The Archive has [argued](https://www.courtlistener.com/docket/17211300/106/hachette-book-group-inc-v-internet-archive/) that the use is fair (and so doesn’t require payment or permission from the publishers) because it simply permits the digital equivalent of library lending – for each physical book in the library’s collection, only one patron can read the ebook version at any given time, the patron can’t retain the book beyond the lending period, [the physical book is not available while the electronic version is checked out, etc. They also argue that, as a public policy matter, libraries should be enabled to continue their core activity – owning and lending books in their collections – in the digital era, and this is enabled by CDL. These arguments were laid out in detail in a [white paper](https://controlleddigitallending.org/whitepaper/) published before the lawsuit by Kyle Courtney and Dave Hansen.

The publishers [argue](https://www.courtlistener.com/docket/17211300/99/hachette-book-group-inc-v-internet-archive/) that this is an intrusion onto their library ebook licensing market (through services like Overdrive), which generates millions of dollars each year, and if libraries want to acquire and distribute ebooks, they have to negotiate with publishers and pay a fee. The use is not “transformative” because it serves the same purpose as the physical copies – to provide access to the work for reading. 

Both parties have moved for summary judgment, meaning they’ve asked the court to go ahead and decide the case based only on the briefs and filings so far, without a full trial on factual issues. In other words, both parties say that if the court applies the law to the *undisputed* facts, they win. So, in addition to the legal question "is CDL fair use," another key question at this stage is whether there are any factual disagreements that matter to the outcome of the case. If the judge thinks that there are, the case will go on to trial so that these facts can be more fully disputed. 

So what happened at oral argument? To my eye, the judge's questions pointed in two directions. On one hand, he seemed at least a little skeptical of the publishers' arguments about the effect of CDL on their revenues. Market effect is one of the fair use factors that courts must consider, and the publishers said that of course CDL hurts their revenue because every CDL loan competes with (or replaces) an ebook license the library should have purchased. The judge pointed to evidence submitted by the Internet Archive showing that publisher ebook revenues grew during the time that CDL services were available. If the court is sympathetic to the Archives' argument that there is essentially no harm here, so no foul from a copyright point of view, he may decide to go to trial so that this factual evidence can be further developed.

On the other hand, the court seemed unmoved by the Internet Archive's legal arguments for fair use. Judge Koeltl repeatedly and pointedly asked IA's counsel, Joe Gratz, for caselaw supporting the key points in their fair use argument, and then interrogated Gratz's interpretation of those cases with more than a little skepticism. Analogies between CDL and the *Sony* case (about the lawfulness of VCR use for "time shifting" televised programs), as well as the *HathiTrust* book digitization case and the *TVEyes* television search engine case were all met with a somewhat chilly reception by the judge. If Judge Koeltl decides to grant summary judgment to one of the parties, the tenor of his questions for the Archive leads me to suspect he would side with the publishers.

An interesting side note: the Supreme Court is currently deliberating on a case involving the scope of fair use - *Warhol v. Goldsmith.* That case is arguably pretty different from this one - it's about art-making, and this case is about access to information. But Judge Koeltl did have a lengthy aside at one point about his keen interest in the Supreme Court's opinions about fair use. That may be in part because [Koeltl was the district judge who found Warhol's use to be fair](https://www.nytimes.com/2019/07/02/arts/design/andy-warhol-prince-fair-use.html)! His decision was reversed by the Second Circuit Court of Appeals, and of course the issue is now being reviewed by the Supremes. It leads me to wonder if he might wait for a decision in *Warhol* before making his own decision in this case. Time will tell.