---
layout: post
published: true
comments: true
date: '2021-03-19 09:31 -0400'
title: Four Concerns About the new UC-Elsevier Deal
categories: ''
excerpt: ''
excerpt_separator: ''
---
The new deal between the University of California System (the UC) and Elsevier was announced earlier this week with much fanfare, the UC [declaring](https://www.universityofcalifornia.edu/press-room/uc-news-uc-secures-landmark-open-access-deal-world-s-largest-scientific-publisher) it a "breakthrough," Elsevier [touting](https://www.elsevier.com/connect/uc-and-elsevier-sign-transformative-agreement?dgcid=_TW_O_Connect&sf243983401=1) it as a "win for researchers," and the LA Times columnist Michael Hiltzik [calling it](https://www.latimes.com/business/story/2021-03-16/uc-wins-battle-with-elsevier) "a leap forward for the open-access movement." *Update: Gary Price has a great [round-up](https://www.infodocket.com/2021/03/16/university-of-california-and-elsevier-announce-breakthrough-open-access-agreement/) of coverage (as always) at InfoDocket, and Lisa Hinchliffe has a helpful backgrounder [here](https://scholarlykitchen.sspnet.org/2021/03/16/the-biggest-big-deal/).*

The UC has been a trailblazer in supporting open access in a variety of ways, and they deserve a huge amount of credit for that. Their [system-wide open access policy](https://osc.universityofcalifornia.edu/scholarly-publishing/uc-open-access-policies-background/presidential/) and their work [supporting self-archiving](https://osc.universityofcalifornia.edu/for-authors/open-access-policy/deposit/) in the UC repository is awe-inspiring, as is their investment in surfacing and supporting many [pathways to OA](https://osc.universityofcalifornia.edu/uc-publisher-relationships/resources-for-negotiating-with-publishers/pathways-to-oa/). Their [negotiating toolkit](https://osc.universityofcalifornia.edu/uc-publisher-relationships/resources-for-negotiating-with-publishers/negotiating-with-scholarly-journal-publishers-a-toolkit/) was a major help as we organized our own efforts with Elsevier.

While libraries in the US [expressed solidarity](https://news.library.virginia.edu/2019/03/07/six-things-uva-researchers-need-to-know-about-the-uc-system-walking-away-from-elsevier/) with the UC's fight with Elsevier over pricing and open access when they walked away from negotiations in 2019, some US [libraries](https://libraries.mit.edu/news/libraries-faculty/31888/), librarians, and even some OA [publishers](https://blog.frontiersin.org/2020/03/10/current-transformative-agreements-are-not-transformative/amp/) seem to be skeptical of the UC's approach to 'transforming' scholarly publishing through its new deal with Elsevier. Why? I can only speak for myself, but here, in a nutshell, are some key things that make me hesitate to cheer this new deal:

**Elsevier does what's best for Elsevier.** The [serials crisis](https://en.wikipedia.org/wiki/Serials_crisis)—the slow-motion catastrophe that has seen a few journal [oligopolies](http://dx.plos.org/10.1371/journal.pone.0127502) commandeer library budgets, crowding out other investments—is not an accident or a natural disaster. It is the result of a [deliberate business strategy](https://www.theguardian.com/science/2017/jun/27/profitable-business-scientific-publishing-bad-for-science), implemented by commercial firms whose sole duty is not to science but to their shareholders. By far the largest and most-[boycotted](https://en.wikipedia.org/wiki/The_Cost_of_Knowledge) (to [little effect](https://www.the-scientist.com/news-opinion/opinion--boycotting-elsevier-is-not-enough-66617)) of these firms is Elsevier. That Elsevier [loves this deal](https://www.elsevier.com/connect/uc-and-elsevier-sign-transformative-agreement?dgcid=_TW_O_Connect&sf243983401=1) is enough to make me worry. That concern only deepens when we see sharp independent observers like Roger Schonfeld [argue persuasively](https://scholarlykitchen.sspnet.org/2018/09/04/read-publish-good-academy/) that these deals will ensure Elsevier's continuing dominance of scholarly publishing in the open access future.

**It transforms access, but caters to IF mania.** Open access activism has long been focused on how commercial academic publishers use copyright to lock up and monetize research. Open access aims to remove copyright as a barrier to access to knowledge, and on those terms, the UC-Elsevier deal is a success. But copyright is only half (maybe less) of the dysfunction in academic publishing. The deeper, more insidious problem is the [journal prestige economy](http://www.pubmedcentral.nih.gov/articlerender.fcgi?artid=3690355&tool=pmcentrez&rendertype=abstract%5Cnhttp://arxiv.org/abs/1301.3748) (aka [impact factor mania](https://mbio.asm.org/content/5/2/e00064-14))—the academy's reliance on journal reputation and metrics like journal impact factor in evaluating the quality of scholarship and of scholars. A publisher who controls a high-prestige title has a [captive workforce](https://www.aeaweb.org/articles?id=10.1257/jep.15.4.183) of authors who must struggle to publish in their outlet in order to advance professionally. Transforming the copyright aspect of this system without also upsetting the prestige economy (e.g., by [reforming promotion and tenure](https://sfdora.org)) only shifts the [unsustainable cost](https://www.liberquarterly.eu/article/10.18352/lq.10280/) of IF mania from readers to authors (and author-supporting institutions, like the UC). 

Far from unsettling the prestige economy, the UC deal seems to cater to it, offering authors reassurance that publishing fees will not be a barrier to their participation in this system. When libraries urge faculty to embrace open access, a common rejoinder is "Then the library should pay my APCs." When I hear that suggestion, the ensuing conversation is typically about why that's an [unsustainable model](https://www.liberquarterly.eu/article/10.18352/lq.10280/), and why more radical change is needed to address the [many harms](http://www.pubmedcentral.nih.gov/articlerender.fcgi?artid=3690355&tool=pmcentrez&rendertype=abstract%5Cnhttp://arxiv.org/abs/1301.3748) of the old system. The UC's response, at least in this deal, is, "Sure, here you go!" That may put the rest of us in a difficult position.

**It undermines the only potential upside of charging authors to publish.** Shifting costs to authors is generally a disaster for them, especially [authors in less-wealthy countries](https://blogs.lse.ac.uk/impactofsocialsciences/2020/02/21/read-and-publish-open-access-deals-are-heightening-global-inequalities-in-access-to-publication/) and those without access to grant funds to offset publication costs. But advocates for this cost-shift have long argued that this pain is *good* because it will give authors a reason to publish in more efficient (read: cheaper) journals. Once they have "skin in the game," the invisible hand will lead authors to choose cheaper journals, forcing publishing charges down as journals compete on price to attract authors. But [that hasn't happened](https://www.liberquarterly.eu/article/10.18352/lq.10280/) so far, and there's [little reason to believe it will](https://www.arl.org/wp-content/uploads/2018/09/substituting-apcs-for-subscriptions-20july2016.pdf). In any event, deals like the UC-Elsevier deal undermine this potential upside of charging authors by subsidizing and, if necessary, completely covering the cost on their behalf. Insulating academics from the exploding costs of their choices is exactly the [moral hazard](https://en.wikipedia.org/wiki/Moral_hazard) that helped fuel the explosion in journal subscription prices. Why would APCs be different?

**It runs against a more salutary trend in journal deals: the divest-and-rebalance movement of Big Deal Breakups.** I'm proud of [what we have done](https://news.library.virginia.edu/2021/01/19/vrl-reaches-agreement-for-new-one-year-agreement-with-elsevier/) in Virginia, which I believe is part of an alternative approach to the biggest journal vendors, grounded in the recognition that much of the alleged value of the Big Deal bundles has [crumbled](https://scholarlykitchen.sspnet.org/2019/03/07/value-big-deal-leakage/) as the explosive growth in price outran the growth in valuable subscription content in the packages. (One upside of UC's deal is that it will feed this process by making more content available outside the paywall, not that we expect to see a discount on our next invoice.) UVA and our friends at five other Virginia research libraries are subscribing only to the titles we know our campus needs and relying on legal alternatives like interlibrary loan, article delivery, and the [growing body of open access versions](http://biorxiv.org/lookup/doi/10.1101/795310) to cover those titles where demand is too low to justify subscription. 

In the short-term, we were compelled to take these steps in order to balance our budgets under the pressure of the COVID crisis. But in the long term, we can use this shift away from spending on the Big Deal to restore balance to our collections, investing in diverse and sustainable resources that respond to the full range of interests on our campuses. We can support new directions and approaches in research, rather than being in thrall to take-it-or-leave-it Big Deal prices. Budgets are zero-sum, after all, and every dollar we give to Elsevier is one we can't invest anywhere else.

The UC will realize a modest one-time savings on this deal (characterized as a COVID Relief discount in their [MOU](https://ucsf.app.box.com/s/gb2zj4dmk3h11p4munjvt9gsvtxr84qw)—similar discounts have been secured in other, [non-transformative deals](https://source.colostate.edu/the-libraries-good-deal-new-three-year-contract-with-publishing-giant-elsevier/)), but it's hardly the kind of reset that could allow them to change the overall mix of resources the Library supports. A few years of locked-in price increases will erase it. This particular deal, if it were widely emulated, would leave most libraries with no new resources to invest in changing the landscape. And it leaves Elsevier on the receiving end of millions of public dollars.

For all my gripes, this deal will certainly make a ton of scholarship freely available to all, and that's a very good thing. No one works harder on these issues than my colleagues in the UC system, and there is no doubt that the UC is a leader in transforming scholarly publishing. They have done much more than most of us to move the needle toward open access to research. But this particular deal feels more like an anchor to the past than a path into the future, to me.

