---
layout: post
published: true
comments: true
date: '2020-10-21 15:55 -0400'
title: >-
  Publishing, P&T, and Equity, an Open Access Week Miniseries, Part 2: Start
  Rewarding Access, Alignment, and Engagement
---
This is part 2 of our 3-part mini-series of blog posts on Publishing, P&T, and Equity. The overarching issue: how to reform our research evaluation processes to eliminate bias and promote equity. On Monday [I argued](http://thetaper.library.virginia.edu/2020/10/19/publishing-p-t-and-equity-an-open-access-week-miniseries-part-1-stop-rewarding-journal-prestige.html) for ending P&T standards that reward journal ‘prestige.’ But I don’t believe institutions should be completely blind to how a scholar chooses to publish the products of her research. Instead, we should *reward* scholarly activities that prioritize *access, alignment, and engagement.*

# Access

Institutions should favor platforms and venues that facilitate broad access to knowledge. What does that mean? One way to think of this is in terms of the audiences who might want or need access—research products should be **accessible to:**

1. Readers – research products should be easy to find and free to read, for people and for computers.	
2. Authors – platforms and venues for sharing research should be available to authors regardless of their ability to pay fees, like APCs.
3. Follow-on researchers and other users – research products should be free to reuse (openly licensed, [FAIR](https://www.force11.org/group/fairgroup/fairprinciples)-compliant) so that others can confirm and build on your work.
4. Educators – research products should be openly licensed and OER-friendly, enabling the ["Five Rs"](https://lumenlearning.com/about/whats-oer/) that give open educational resources their transformative power. 
5. Interested readers and researchers around the globe – research products should be available to researchers, readers, students, etc. without regard to their or their institution’s resources. Permissive licensing should encourage translation and adaptation to facilitate access across language and other communication barriers.

# Alignment

Institutions should favor publication in venues that are **aligned** with the scholarly mission, including equity and justice. Here are some indicators of alignment that institutions could factor into their evaluation processes:

1. *A business model that prioritizes academic values over profits.* The [profit margins](https://www.cbc.ca/news/technology/academic-publishers-reap-huge-profits-as-libraries-go-broke-1.3111535) of the leading commercial publishers, and the [long history of extractive practices](https://www.theguardian.com/science/2017/jun/27/profitable-business-scientific-publishing-bad-for-science) that make those margins possible, are a flashing red light indicating those publishers' misalignment with the academic mission. Aligned publishers find ways to support themselves without diverting scarce resources from research.
2. *Ownership or control of the platform is in the hands of scholars, libraries, or academic institutions.* From established academy-owned projects like ArXiv.org to the broad array of [library publishing initiatives](https://librarypublishing.org), including UVA's own open press [Aperio](https://aperio.press), there are platforms, tools, and imprints for sharing scholarship that do not cede ownership or control to corporations that don't share the academic mission.  
3. *Leadership and editorial boards that are diverse and representative of the full range of views and experiences in the academy and in the world.* Institutions with a mission to serve the public should work to ensure that all of the public is represented in the leadership of its leading publication outlets.  
4. *Policies and practices that promote academic values.* Aligned platforms and venues will go beyond merely eschewing the extractive models of the past, incorporating academics in governance, and striving to be representative of the academy. They'll take affirmative steps to support academic values. One way to do that is to foster the forms of access described above, e.g., by adopting FAIR open data requirements, use of open licenses, and affirmative steps to remove bias and enact justice in the publication process.


# Engagement

Institutions genuinely interested in dismantling structures favoring inequity, and replacing them with structures that create and grow equity, should reward behaviors that **increase the institution's level of engagement** with stakeholders outside of the academy. [Community engagement](https://engageduva.virginia.edu) is something that my colleagues here [at the Library](https://equityatlas.lib.virginia.edu) and many wonderful folks [throughout UVA](https://engageduva.virginia.edu/about) are already thinking deeply about. This work helps us make good on our aspiration to be a public university dedicated to the public good. A couple of steps in P&T reform that could help support and grow these efforts:

1. Reward publication in venues that focus on issues relevant to wider communities, and that make published products available to these communities. In a recent high-profile tenure case here at UVA, Paul Harris was [initially denied tenure based](https://sites.google.com/view/tenureforpaulharris/home) in part on the committee's apparent confusion about the value of the journals where his work had been published. Observers noted that he had actually published in open access journals that were [created for the express purpose](http://journalofafricanamericanmales.com/about-us/) of providing a venue for community-engaged scholarship that would be accessible to the folks who needed it most. Giving due weight to that kind of engagement is important for institutions who want to fulfill their public interest mission.
2. Reward scholarly work that may not fit into the traditional contours of a published article or book. Developing open tools, open educational resources, and open datasets–this work has long been undervalued and overlooked in the academy. Likewise for engaging policymakers and writing for non-academic audiences. This work may do more than any academic book or article to actually advance the public good, including the causes of justice and equity, but it is often invisible to the systems of evaluation, promotion, and recognition at our institutions. Recognizing and encouraging this work would also help counteract the effects of ["cultural taxation"](https://www.tandfonline.com/doi/full/10.1080/01419870.2010.496489) in which Black faculty are expected to shoulder more of the burden of mentoring and committee work associated with fostering diversity at an institution.


# Conclusion

If we want a better, more equitable system to flourish, we have to reward the scholars who choose to build, grow, and use that alternative system. That means we can’t just be “blind” to the choices scholars make about where and how to share their work. Instead, we should actively encourage and reward those who build and support a system fosters equity.
