---
layout: post
published: true
comments: true
date: '2020-10-19 15:56 -0400'
title: >-
  Publishing, P&T, and Equity, an Open Access Week Miniseries, Part 1: Stop
  Rewarding Journal “Prestige”
---
Happy [Open Access Week](https://www.openaccessweek.org)! The theme for this year is "Open with purpose: taking action to build structural equity and inclusion." Of all the policy structures that affect equity and inclusion at a university like ours, perhaps none is more important than policies governing promotion and tenure. Not coincidentally, these policies can also have a dramatic effect on the incentives for scholars to publish their work in open access venues, or to share data, code, preprints, and other research products freely (and with open licenses, formats, etc.)—research practices that promote public access to knowledge, increasing equity and opportunity for all. Given the centrality of promotion and tenure to equity, inclusion, and open access, I'd like to share a few thoughts and resources on these three ideas over the course of the week. My overall proposal is that one of the most important actions any decision-maker can take to build structural equity and inclusion is to reform promotion and tenure.

This blog series will have three parts:

-Part 1 (this post!) will discuss why updating P&T standards to eschew journal level metrics and journal prestige is an important strategy for advancing equity and inclusion, as well as open access.
    
-Part 2 (Wednesday-ish) will suggest that rewarding open practice and open publishing in P&T standards is an important step toward affirmatively promoting equity and inclusion in the academy (and in the communities we serve).
    
-Part 3 (Friday-ish) is a kind of postscript that explains a bit about why libraries are especially interested in these issues and how we see the intersection of Open Access, Equity/Inclusion, and Promotion and Tenure with perhaps a unique clarity relative to other parts of the scholarly ecosystem. 

This is a good time to be talking about reforming promotion and tenure and realigning incentives in science and scholarship more broadly. Reform is in the air nationally, globally, and locally. Nationally, we could point to two initiatives at the National Academies of Science, Engineering, and Medicine. One is a convening of key stakeholders in a [Roundtable on Aligning Incentives for Open Science](https://www.nationalacademies.org/our-work/roundtable-on-aligning-incentives-for-open-science) which has hosted several meetings and working sessions and is developing a toolkit to help  institutions reform promotion and tenure policies. The other news from the NAS is that Representative Eddie Bernice Johnson, chairman of the House Committee on Science, Space, and Technology, has [written a letter to the President of the National Academies](https://science.house.gov/imo/media/doc/LTR%20-%20EBJ%20to%20McNutt%20re%20STEM%20racism.pdf) asking the NAS to "assemble a distinguished group of individuals to assess the influence of systemic racism in academia on the careers of individuals belonging to racial and ethnic groups historically underrepresented in the [STM] workforce." The letter mentions some important factors, like [cumulative advantage](https://www.annualreviews.org/doi/10.1146/annurev.soc.32.061604.123127), that have been highlighted as drivers of inequality in the academy along racial, gender, and other axes.

Globally, a number of movements in favor of P&T reform have been gaining momentum in recent years. The [San Francisco Declaration on Research Assessment (SFDORA)](http://sfdora.org) may be the most well-known [public statement](https://sfdora.org/read/) on the need for reform in research evaluation, and in particular on the need to eschew consideration of journal placement as an indicator of research quality. DORA's first recommendation is clear and direct:

> Do not use journal-based metrics, such as Journal Impact Factors, as a surrogate measure of the quality of individual research articles, to assess an individual scientist’s contributions, or in hiring, promotion, or funding decisions.

DORA as an organization has gone beyond the declaration that gave the group its name, and is working to produce resources that help groups make the case for reforming research evaluation. For example, last month DORA published a [handsome infographic](https://sfdora.org/wp-content/uploads/2020/09/DORA_UnintendendedCognitiveSystemBiases.pdf) (and kicked off a [series of blog posts](https://theplosblog.plos.org/2020/09/rethinking-research-assessment-addressing-institutional-biases-in-review-promotion-and-tenure-decision-making/) on the PLOS Blog) showing the unintended cognitive and system biases that can infect research assessment.

Another leading statement on this issue is the [Leiden Manifesto](http://www.leidenmanifesto.org), developed by scholars at Georgia Tech and Leiden University. They have a snappy video introduction:

<iframe title="vimeo-player" src="https://player.vimeo.com/video/133683418" width="640" height="360" frameborder="0" allowfullscreen></iframe>

Another global development on this issue is the publication of a [new statement on research evaluation](https://www.nature.com/articles/d41586-020-02294-5) from the group Science Europe, which is comprised of prominent European research funders. In its statement, Science Europe urges increasing transparency in evaluation and eliminating systemic biases.

Locally, the [UVA Racial Equity Task Force](https://racialequity.virginia.edu) has recently called for a close examination of P&T standards and processes in its [Final Report](https://racialequity.virginia.edu/sites/g/files/jsddwu356/files/2020-08/RETFFinalSigned.pdf). Specifically, the Task Force recommends that, "UVA should immediately commence a comprehensive review of its tenure and promotion policies…" including an assessment of "Policies or practices that do or may operate to perpetuate inequality on the basis of one or other protected characteristic." The use of journal-based metrics is such a policy. Hiring and promoting people based on their record of elite journal placement shores up, rather than breaking down, cumulative advantage. 

The gender and racial bias in prestige publishing outlets (and grant funding) are long-running and well-documented. For example, a [2018 study](https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0205929) of racial disparity in NIH awards (19% of applications from white investigators were funded between 2010-2013, compared to only 11.8% of applications from black investigators) found that the funder's attentiveness to publication metrics, including journal impact factor, was a key source of the disparity:

> We found that black applicants reported fewer papers on their Biosketches, had fewer citations, and those that were reported appeared in journals with lower impact factors. Incorporating these measures in our models explained a substantial portion of the black/white funding gap. 

The paper argues that the racial disparity in these metrics is further explained by cumulative advantage:

> Our data suggested that cumulative advantage plays a role. Although black investigators published the same number of papers during their PhD and postdoctoral training, these papers received fewer citations. This implies that black investigators may not receive the same advice from mentors related to research topics and publication strategies as whites during training and at the beginning of their careers. These disadvantages appear to accumulate as the black/white publication and citation gaps widen when black researchers become principal investigators (especially for investigators who were not funded). Furthermore, black researchers had fewer coauthors and fewer coauthors publishing in the top quartile of their research fields, a result identified elsewhere in the literature. This indicates that black investigators had smaller professional networks that may constrain their publication counts, citations, and research impact as well as their prospects for promotion. Finally, black publication records may be affected by institutional pressure to provide more service and mentor more students in order to promote the diversity initiatives of their institutions overburdening black researchers with a form of “cultural taxation”."

Elite journals in the humanities and social sciences are equally subject to pernicious racial and gender effects. For example, a [pioneering study](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=1992111) of legal scholarship in the area of civil rights found the field dominated by a handful of white men, happy to cite one another in top journals but excluding almost entirely the scholarship of folks outside this elite group. A more recent [survey of the literature](https://abovethelaw.com/2018/08/why-are-most-of-the-amazing-scholars-white-men/) on the Above the Law blog finds this pattern repeats itself across many, many fields. Focusing again on law, the survey explains how advantage leads to advantage, and how racial imbalance at each stage is replicated and amplified at the next:

> Your best chances of getting published in a top 10 law journal are if you graduated from a top 10 school.  Your best chances of getting strong citation counts are if you publish in a top 10 journal.  Your best chances of getting into academia are if you come from one of the top 10 schools.  Your best chances of being published in a top 10 law journal are if you teach at a top 10 law school.  Your best chances….

Folks outside of this prestige loop find themselves in much the same quandary as Bill & Ted trying to form a triumphant band:

<iframe width="560" height="315" src="https://www.youtube.com/embed/tx02tY8ABfA?start=64" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

If we want to make triumphant academic careers accessible to all without regard to race, gender, or other aspects of identity, then we can't have systems of hiring and promotion that privilege cumulative advantages that accrue disproportionately to white men. We must dismantle what one [massive study](https://www.pnas.org/content/117/17/9284) of the diverging academic careers of majority and minority scholars called "a stratified system where underrepresented groups have to innovate at higher levels to have similar levels of career likelihoods." As that study showed, the scholars we are losing under the current system actually play a "crucial role in generating novel conceptual discoveries and innovation." A system that cuts these folks' careers short and overlooks their contribution is not just unjust, it's self-defeating.

It is worth noting that in addition to their complicity in reproducing racial and gender bias, we know that prestige publications have other biases that tend to be not only [poorly correlated](https://f1000research.com/articles/9-1188) with article impact, but actually [positively correlated with bad science](https://www.frontiersin.org/articles/10.3389/fnhum.2013.00291/full) and likely to [distort the progress of science](https://journals.plos.org/plosmedicine/article?id=10.1371/journal.pmed.0050201) in predictable ways. Indeed, there is a laundry list of harms associated with "[impact factor mania](https://mbio.asm.org/content/5/2/e00064-14)," not least of which is the [absurdly high cost](https://en.wikipedia.org/wiki/Serials_crisis) of journal subscriptions, and the [absurdly high price](https://www.liberquarterly.eu/article/10.18352/lq.10280/) of "article processing charges" in elite open access journals (yet another [barrier to access](https://www.timeshighereducation.com/blog/linking-impact-factor-open-access-charges-creates-more-inequality-academic-publishing) for those who cannot afford them).

So, in light of these destructive aspects of the prestige journal economy, I propose that any institution serious about dismantling structures of inequity should remove any consideration of placement in prestigious journals from its promotion and tenure standards. But that's not enough. Later this week I'll explain why promoting equity means promoting open access to all products of research. It's not enough to stop doing harm; we have to start doing good.
