---
layout: post
published: true
comments: true
date: '2020-07-20 15:50 -0400'
title: A Fair Use Opinion That Will Make You Jump
---
A recent [decision](https://law.justia.com/cases/federal/district-courts/new-york/nysdce/1:2019cv08606/522915/17/) out of the Southern District of New York is a nice illustration of just how friendly fair use can be to scholarly uses of images. Fair use is the right that allows use of in-copyright works without permission in some contexts, and as this case shows, a scholarly context is often a very friendly one for fair use. 

The Metropolitan Museum of Art was sued last year over its use of a photo of Eddie Van Halen playing his famous homemade guitar "[Frankenstein](https://en.wikipedia.org/wiki/Frankenstrat)," which the Met displayed alongside photos of the guitar itself, which was one of the objects in the museum's ["Play It Loud" exhibition](https://www.metmuseum.org/exhibitions/listings/2019/play-it-loud) of famous objects (largely instruments) from the history of rock 'n' roll. The photo was included in the [exhibition catalog online](https://www.metmuseum.org/art/collection/search/752454?&exhibitionId=%7bd4024ef6-623f-4770-a626-a38b90c25b64%7d&oid=752454&pkgids=569&pg=0&rpp=100&pos=22&ft=*&offset=100), which is freely accessible on the Met's website. 

The photographer, Lawrence Marano, sued the Met, arguing that his copyright in the image was infringed by these uses. In an unusual move, the judge in the case ordered Marano to explain why the use was *not* a fair use, an issue the Met hadn't yet raised. The judge's skepticism may be due in part to her past encounters with Marano's lawyer, Richard Liebowitz, who is a fairly well-known plaintiffs' lawyer who brings a *lot* of copyright lawsuits, and has been criticized by courts ([including Judge Caproni,](https://news.bloomberglaw.com/ip-law/court-orders-copyright-troll-into-firm-management-course) who heard this case) for his aggressive methods, which some call [troll-ish](https://news.bloomberglaw.com/ip-law/second-us-judge-derides-photo-copyright-lawyer-as-troll).

We get questions about images all the time here at the Library, and reusing images is arguably the most common source of concern among folks working on scholarly books, dissertations, or websites. Interestingly, the question I receive most commonly is, "How do I request permission to use this image?" I typically have to raise the possibility of fair use myself, and I find that, more often than not, the contemplated use is fair, and permission isn't needed. Judge Caproni's opinion in this case (and her willingness to toss the case very early) is a good example of why scholars should be fairly bullish on their own fair use rights.

For one thing, it shows that fair use is not an afterthought or a "mere defense" in the law. It is unfortunately a common misconception about fair use that it is of little practical use because an angry plaintiff can always file a lawsuit and force you into a lengthy proceeding where fair use will not arise until late in the trial, when "affirmative defenses" are considered. By then your legal bills will have piled up, and you'll be wishing you'd just paid a license fee. In reality, fair use is a right, and is a key determinant of the scope of copyrights. The author's rights in [Section 106](https://www.law.cornell.edu/uscode/text/17/106) (reproduction, distribution, public display, etc.) are "subject to" the right of fair use, and conversely, [Section 107](https://www.law.cornell.edu/uscode/text/17/107) tells us that fair use "is not an infringement" of copyright. Fair use is not an afterthought; it's at the heart of the law.

For this reason, courts have been quite willing to consider fair use at early stages of litigation, especially in cases that are close to the heart of fair use. Courts expect plaintiffs to consider fair use before they file lawsuits, and can punish plaintiffs who brazenly harass users they should have known were lawful fair users. In *Marano,* Judge Caproni raised fair use at the earliest stage of the case, granting a motion to dismiss, which is an order based only on the plaintiff's complaint, before any evidence has been presented. The purpose of such a motion is to end cases with no chance of success before the parties are forced to incur the time and expense of litigation. In her opinion, Judge Caproni says that simply by looking at the most basic facts in the photographer's own complaint, it's clear that the Met's use was fair.

The fair use analysis itself is also instructive. The key facts that lead the court to conclude that the use is fair are:

1. The use is for a different expressive purpose than the photographer's original purpose. Specifically, using the photo as a *"historic artifact" that "contextualizes"* the exhibition was transformative relative to the photographer's original purpose of portraying Van Halen as a groundbreaking musician.
2. The Met's use is "in a scholarly context," and museum exhibitions "often incorporate other source material for 'optimum treatment of their subjects.'" Documenting and representing the objects discussed, critiqued, and curated in this context is favored by fair use.
3. Finally, "the Photo constitutes an 'inconsequential portion' of the Met's online catalogue." The image is not the heart of the exhibition—it's not even the heart of the section about the Van Halen guitar. The exhibition features a rich variety of content and the photo is merely an adjunct to one portion of the overall presentation.

These facts will of course be present in many, many scholarly uses of images, strongly favoring them in the fair use calculus. So, scholarly authors and creators, take heart: fair use is your friend.