---
layout: post
published: false
comments: true
date: '2020-03-19 13:36 -0400'
title: Language for COVID-era Scanning Workflows
---
The language below is draft language prepared for incorporation in the UVA Library’s instructional scanning workflow for the duration of the COVID-19 dislocation. Like everything that’s happening right now, this language was prepared and deployed on an accelerated basis and is likely to change over time. However, I know that many institutions are wrestling with how best to [use their fair use rights](https://tinyurl.com/tvnty3a) to foster continued instruction in this difficult time, and a little help with implementation might save folks some scarce time and spare them some unneeded stress. Consult with your institution’s University Counsel or General Counsel before incorporating this language in your own workflow. I’m not your lawyer, obviously, and this is not legal advice. A Word document version of this blog post will be available [here](https://myuva-my.sharepoint.com/:w:/g/personal/bcb4y_virginia_edu/ET93VE5DagBOpwsYv9JqytkBrghphs96aATdSF-AGYB2Qg?e=tyffkk) until March 26, 2020. 

The Cover Sheet Language is meant to be included in a cover sheet to accompany each scan. Its purpose is to make clear to students why they are receiving a scan that might be larger than would ordinarily be provided, and to ask their cooperation in limiting the reuse of the scan. The Scan Request Form Addendum can be displayed wherever instructors make their scan requests, alongside or in lieu of the ordinary fair use guidelines that might be presented in this context. Its purpose is to ensure that faculty understand (1) why we are taking a modified approach to scanning during the COVID crises, (2) what kinds of requests are appropriate, and (3) alternatives to library scanning that will ensure our scanning does not exceed what is appropriate under these circumstances, and will help reduce the very heavy workload of our staff. In particular, we want to be sure that we don’t scan more than is appropriate, and that we don’t scan material that is freely and legally available elsewhere.

Each of these templates is meant to ensure that scanning requests and downstream uses of scans are consistent with the unique fair use reasoning that we have identified as applying during this crisis. Of course, this is not magic language: institutions will need to follow [additional best practices](https://tinyurl.com/tvnty3a) for ensuring that creation and use of scans will be fair use—most importantly, ensuring that access to scans is limited to students enrolled in the relevant course.

# Cover sheet language

This scan is being provided as part of UNIVERSITY's effort to prevent the spread of the COVID 19 virus. It is for your personal use only and is intended only for use during the time when University public health measures prevent access to your personal copy or a copy on physical reserve or otherwise available at the Library. Please discard this copy once you have access to your personal copy or to the physical copy at the Library, and do not share it.

# Scan Request Form Addendum

_Scanning Policy Changes During University Response to COVID-19:_

As part of the UNIVERSITY‘s effort to prevent the spread of COVID-19, the Library is fulfilling scanning requests that are more extensive than what might be reasonable under normal circumstances. As explained in the [Public Statement of Library Copyright Specialists: Fair Use & Emergency Remote Teaching & Research](https://tinyurl.com/tvnty3a), fair use can permit more extensive scanning as part of a legitimate response to a public health emergency such as this one. If your request is for materials that will be used by persons needing accommodation for print disabilities, please submit that request here and we will work with SDAC to deliver an appropriately formatted version.  If you have no students needing accommodation and you are able to scan this material yourself and share it with your class through Collab, we’d welcome that.  If you need us to scan it, please use this form and we’ll get it to you and your students as quickly as we can.

Note, however, that we must still ensure that our scanning is reasonable in relation to these extraordinary circumstances. Please only request materials where an electronic copy is not available from the Library (and note that the Library may be able to purchase electronic access if it does not currently provide it). Please also limit your request to the portions of a given work that are needed for full participation in the course for the duration of the students’ dislocation. Scans made during this time may include a special cover page with important information for students about how to use and dispose of the scan; please include the cover page when you share the scan with students. Please only distribute these scans to students using your course site on Collab to ensure that access is limited to those enrolled in the course. 

Finally, note that some textbook publishers and other academic vendors are making resources freely available to institutions affected by COVID-19 closures. Information about which vendors are making these offers is being collected [here](https://tinyurl.com/vendorsupportedaccess) and may also be found on the vendors’ websites or social media. Please do not request scans of material that is being made freely available by a vendor unless there is a compelling reason (e.g., the free version lacks important content, or requires students to acquiesce to problematic terms of use).

