---
layout: post
published: true
comments: true
date: '2020-02-28 16:43 -0500'
title: 'Fair Use Week Day 5: Fair Use and Biography, A First Draft Interview'
---
Later this year, my friend Peter Jaszi and I are speaking on a panel at the 2020 Biographers Conference, to help that community understand how fair use can help them do their very important work. In advance of that conference, Peter and I were sent a series of questions that will become an interview published in [The Biographer's Craft](https://biographersinternational.org/tag/the-biographers-craft/), the group's monthly newsletter. They were generous enough to let me publish my own rough answers to their questions here, for Fair Use Week. Peter will add his thoughts, and the final version will go up on the BIO website. For now, enjoy my own rough cut version!


**Q: Why is the fair use doctrine of such importance to nonfiction writers, particularly biographers?** 

B: Fair use is the right that a nonfiction author can use to incorporate others’ in-copyright works—via quotations, images, extracts, and the like—into her own, without obtaining permission. There are several reasons fair use is crucial for nonfiction writers, especially biographers. First, any true story, especially a story about a person’s life, will involve encounters with culture. Human lives take place in a cultural milieu that includes music, movies, books, television, newspapers, and many other forms of human creativity. To fully tell a life story, it may well be important to conjure some of the cultural elements that touched that life—to quote text, to reproduce images, and (in multimedia contexts) to include video and audio clips. Second, unless you are the first person to write about a person or topic, you are likely to find material in previous work on the subject that you’d like to mention, invoke, criticize, or otherwise incorporate into your own. 

Without fair use, authors would need to obtain permission for all these uses, and that’s not always possible. Sometimes the copyright holder is hostile to your project and would withhold permission as a way to block or undermine you. This can happen for any number of reasons; maybe they disagree with what they believe to be your approach to the subject, or perhaps they don’t want anyone to write about the person or issue, period. Maybe they have a competing biography or other project and they would benefit from exclusive use of the content at issue. In some cases (often called “orphan works”) the copyright holder simply can’t be identified or located. Seeking permission in those cases is literally impossible. Fair use saves the day in these cases, ensuring that copyright holders can’t be censors, and that the technicalities of copyright don’t block new creativity.

**Is it a good or a bad thing that the limits of fair use are only broadly defined?**

It is a very good thing! The Copyright Act is chock full of narrow, specific exceptions that are tightly crafted to cover only very specific users or use cases. There is an exception for jukeboxes, another one for agricultural fairs, and yet another one for library patrons who use photocopiers. If Congress was thinking of you in 1976, then you might have gotten one of these tidy little exceptions. But if your work has changed in any way in the last half-century, the law was probably not written with you specifically in mind. But fair use is broad and flexible precisely because it is valuable to have an open-ended commitment to fairness in the law, to accommodate all the unforeseeable circumstances where copyright shouldn’t get in the way of progress. 

**What and/or who creates the main obstacles to writers’ making the fullest use of fair use? Living subjects and/or subjects’ and others' estates? Managers of archives? Publishers?** 

Like fair use itself, I think this is really context dependent. In terms of working on a specific project, I’m not sure I can generalize. Some estates are notoriously bad, while others are quite chill and easy-going. Some artists are cranky and controlling, others generous and happy to support other creators. One thing that has been really, really frustrating for me when I’m working on policy issues, rather than on a specific use case, is that the lobbyists and other advocates for rights-holder groups (authors groups, publishers groups, movie and music industry groups, umbrella organizations that sweep in multiple industries) are committed in principle to maximum copyright power and control. They show up to oppose any legal change that might strengthen fair use or increase access to in-copyright works, even when the effect on their collective bottom line is likely to be zero. I wish the content industries would realize that their own authors and other creators need fair use, and stop fighting so hard to kill it in the courts and in congress.

**What are some of the most important recent (post Ian Hamilton) cases touching on fair use? What has changed? What needs to change?**

This is a big question, but I would say that the [Google Books case](https://en.wikipedia.org/wiki/Authors_Guild%2C_Inc._v._Google%2C_Inc.) is a huge one. That case was the culmination of a long string of cases about when and how search engines and other computer technologies can be used to analyze in-copyright works under fair use. The opinion in that case is a master class in fair use thinking, and it ties together all the insights that had come before it, ultimately finding that digital analysis of texts, even millions of texts, is exactly the kind of thing fair use is supposed to protect. 

Another really important one for nonfiction authors in particular is the [Bill Graham Archives case](https://en.wikipedia.org/wiki/Bill_Graham_Archives_v._Dorling_Kindersley,_Ltd.), another 2nd Circuit case, this one from 2006. In it, the 2nd Circuit blessed the reproduction of classic Grateful Dead posters in the context of what the court called a “biographical book” about the band. The court explained that the “biographical value” of a use like this should be weighed in favor of fair use. It also found that including the posters in a timeline in the book served a new, transformative purpose (helping the reader understand the history of the Grateful Dead) that was different from the posters’ original expressive purpose (attracting viewers to attend the advertised concerts).  

When it comes to fair use, I honestly don't think there is anything that needs to change, at the moment. The law is in very, very good shape. Plenty of other things in the law could change - the duration of copyright could be a little shorter, and maybe we could bring back requirements to register and renew your rights in order to obtain or keep them. But fair use is just fine as it is!

**What should writers be doing/not doing to make the best use of their rights? For example, should writers ask/refrain from asking permission to quote?**

Asking permission is a great example of the interaction of law and pragmatic concerns. One thing that many people don’t realize is that it actually does *not* hurt your fair use argument to ask permission. It is sometimes argued that doing so is proof of a “guilty conscience” or constitutes an admission that permission is required. Happily, we have the Supreme Court’s opinion on exactly this issue, from their last big fair use case, [Campbell v. Acuff-Rose](https://en.wikipedia.org/wiki/Campbell_v._Acuff-Rose_Music,_Inc.). In that case, the rap group 2 Live Crew had sought permission from Acuff-Rose publishing to use the Roy Orbison song “Oh Pretty Woman” in their rap song “Pretty Woman.” Permission was denied, but the group recorded and released the song anyway. When Acuff-Rose sued, 2 Live Crew argued their use was fair. The Supreme Court explained that this wasn’t an admission of guilt because there are any number of reasons a user might seek permission, even if they believe their use is fair. 

And this is where pragmatic questions come into play. Even if you are confident your use is fair, obtaining permission may be useful (especially if it’s cheap and easy to get), as a way of preempting any complaint (even a flimsy or bad faith one) from the copyright holder. Obtaining permission may also be a useful way to create or cultivate an ongoing relationship with a copyright holder. You may not actually need a license, but your permission fee might buy (or maintain) good will, which can be very important if your project revolves around just one person or community. 

On the other hand, in situations where permission is certain to be denied and where asking may do harm—perhaps by tipping off a hostile party to the existence or nature of your project—it might make sense to avoid asking permission. In some cases, it may be important to avoid setting a precedent of seeking permission in cases where you’d rather have a categorical policy of relying on fair use. Markets can grow up around habits of seeking permission, and that can lead to needless negotiation and payment of fees. Sometimes it is important to flex your fair use muscles to be sure they do not atrophy!



