---
layout: post
published: true
comments: true
date: '2020-02-26 11:38 -0500'
title: 'Fair Use Week Day 3: Is Sampling Finally Being Recognized as Fair Use? Kinda.'
---

For Day 3 of [Fair Use Week](http://fairuseweek.org), I wanted to share a few thoughts on the current state of fair use and sampling in music, especially (but not uniquely!) in hip hop. 

### A Mixtape Class

These thoughts were prompted by the opportunity I had recently to visit with A.D. Carson’s class, [Composing Mixtapes](https://news.virginia.edu/content/students-debut-mixtape-straight-uvas-rap-lab-unusual-final-exam), to give the students a bit of a crash course in these issues as they think about whether, and how, to incorporate existing works into their new “mixtape” compositions. 

I was joined by my colleague Rob Tyler who handles IP issues in the UVA University Counsel’s office. Rob was able to share the institutional perspective on managing risk in an educational context. I really appreciate Rob’s enlightened views on this stuff, and I think the students enjoyed the complex picture they got by hearing from both of us. 

These class visits may be the highlight of my work here at UVA, because they give me a chance to interact with amazing UVA students, and to sit in on great lectures about some of my favorite topics—art and creativity, media history, scholarship, free expression, and on and on.

### Why sampling is such an attractive use case for copyright policy, and a mind-melter for some judges

Sampling is often the first thing that folks think of when they think about whether (and how) copyright law appropriately balances the interests of new creators and incumbent copyright holders. Because it involves literal copying from a sound recording, sampling raises the issue more starkly than cases where two songwriters use the [same melody](https://www.youtube.com/watch?v=sJtm0MoOgiU&feature=emb_title), [same chords](https://www.youtube.com/watch?v=oOlDewpCfZQ), the same [“groove” or “feeling”](https://www.hollywoodreporter.com/thr-esq/blurred-lines-appeal-brief-says-artists-cant-copyright-a-groove-997767), or even a [single lyrical phrase](https://www.nytimes.com/2019/03/31/business/media/plagiarism-music-songwriters.html). 

Indeed, the copying involved in sampling is typically so obvious and literal that some early courts lost their minds over it, with one particularly [problematic judge citing the Ten Commandments’](https://blogs.law.gwu.edu/mcir/case/grand-upright-v-warner/) admonition “Thou shalt not steal” as if that ought to settle the issue. Arguably, those early cases had a [chilling effect](https://www.theatlantic.com/entertainment/archive/2011/04/how-copyright-law-hurts-music-from-chuck-d-to-girl-talk/236975/) on the use of samples in commercial music, perhaps especially the [expressly political uses](https://www.theatlantic.com/entertainment/archive/2013/09/did-the-decline-of-sampling-cause-the-decline-of-political-hip-hop/279791/) that had been a major element of “golden era” hip hop. 

More recent cases seem to suggest a possible turning of the tide on sampling. I’d been tracking these cases casually, and my impression was that things were, indeed, improving. But as I prepared for my chat with Prof. Carson’s Mixtape class, I saw how limited this trend has been.

### Courts are vindicating sampling as fair use, but in a pretty narrow (but important) context

What I saw as I looked at the two most recent sampling opinions in the [Copyright Office’s Fair Use Index](https://www.copyright.gov/fair-use/fair-index.html) was a pretty remarkable similarity: both involved use of what might be described as spoken word recordings, not music. 

In [Oyewole v. Ora](https://www.copyright.gov/fair-use/summaries/oyewole-ora-sdny2018.pdf), the court found fair use where the pop singer Rita Ora used a sample of the plaintiffs’ 1968 spoken word work “When the Revolution Comes.” The clip at issue, the repeated phrase “…and party and bullshit,” has been appropriated several times in a hip-hop context - most famously [by the Notorious B.I.G.](https://www.youtube.com/watch?v=rEaPDNgUPLE), and the plaintiffs sued Biggie, as well. However, the court found both Rita Ora and Biggie had sampled fairly, comparing the messages of the original song to the two sampling works:

> In "When the Revolution Comes"…the phrase "party and bullshit" is part of an admonishment, an expression of disgust and disappointment in those who are not readying themselves for the revolution.

> By contrast, "Party and Bullshit" embraces the "party and bullshit" culture, thereby transforming "party and bullshit" from something shunned to something glorified.

> Likewise, "Party" exalts "party and bullshit" rather than condemning it. Ora sings with joy about "party and bullshit." … Ora cheerfully proclaims that she wants to "party and bullshit." Unlike "When the Revolution Comes," "Party" does not denounce "party and bullshit" but instead suggests that it is fun, lighthearted, and enjoyable.

These uses are fair uses, then, because the sampling artists’ messages are both clearly, dramatically different from the original poets’ message. Indeed, they are exactly the opposite message—the original says “party and bullshit” is bad, the samplers say it is good. 

In [Smith v. Cash Money](https://www.copyright.gov/fair-use/summaries/estate-of-james-oscar-smith-cash-money-records-no.1-14-cv-02703-2017.pdf), Drake and his record label were sued for their use of another spoken word track, “Jimmy Smith Rap” in Drake’s work, “Pound Cake/Paris Morton Music 2.”  Here, again, the court seems to have been moved by the stark difference between the message of the original and of the sampling track:

> There can be no reasonable dispute that the key phrase of [Jimmy Smith Rap]—“Jazz is the only real music that's gonna last. All that other bullshit is here today and gone tomorrow. But jazz was, is and always will be.”—is an unequivocal statement on the primacy of jazz over all other forms of popular music. Defendants’ use of [Jimmy Smith Rap], by contrast, transforms Jimmy Smith’s brazen dismissal of all non-jazz music into a statement that “real music,” with no qualifiers, is “the only thing that’s gonna last.” Thus, Defendants’ “purposes in using [the original work] are sharply different from [the original artist’s] goals in creating it.”

In both *Oyewole* and *Smith*, the courts are engaged in an exercise that is very familiar for them: interpreting and comparing texts as arguments. Once they see the original and the sample as two opposing viewpoints, it is easy to explain why the latter is adding a new perspective and serving the purpose of copyright.

### The upshot

I see just a couple of takeaways from these cases for those who would like to engage in sampling. On the upside, if you are sampling a work with a clear textual meaning and point of view—spoken word, or perhaps a recorded speech or similar artifact—these cases are a good sign that a judge will be able to apply established fair use principles to your use and (assuming your message is new and different, and especially if it is diametrically opposed) find your sampling to be fair. This is good news for [expressly political sampling](https://www.theatlantic.com/entertainment/archive/2013/09/did-the-decline-of-sampling-cause-the-decline-of-political-hip-hop/279791/). 

On the downside, samples that are more musical in nature, without any lyrical or spoken content, have yet to benefit from the emphasis on new purpose in fair use law. There is still a real risk that courts will see the purpose of a musical sample — to provide a hook or a beat, etc., that will please the listener — as identical to the purpose of the original recording. *[VMG Salsoul v. Ciccone](https://fairuse.stanford.edu/case/vmg-salsoul-llc-v-ciccone/)*, the recent case involving a musical sample where the sampling artist was vindicated, was not a fair use case. Instead, the court said that the sample was so short that it didn’t actually copy protected material—there is no copyright in a single note or tone. [Another case](https://www.npr.org/templates/story/story.php?storyId=4701570) involving the Beastie Boys was decided on similar grounds — the sampled sound was too small to be protected by copyright. 

So, while we now have increasingly clear guidance on sampling of spoken text, we may still have a ways to go before we have a robust understanding of how modern fair use law applies to musical samples. What will happen in the [latest sampling case](https://pitchfork.com/news/yeasayer-suing-kendrick-lamar-and-the-weeknd-over-black-panther-song/) to cross the newswires, in which indie electicists Yeasayer are seeking damages from Kendrick Lamar and the Weeknd? I hate to say it, but fair use may not do Lamar much good. The case seems to involve a single note, however, which may put it into the same "de minimis" category as Madonna and the Beastie Boys. Stay tuned!
