---
layout: post
published: true
comments: true
date: '2019-10-25 12:09 -0400'
title: 'Open Access Week Finale: Open Access Policies, Big Deals, and Equity'
categories:
  - open access
  - oaweek
---
For this final post for Open Access Week 2019, I’d like to focus on one of the oldest and (IMO) coolest tricks in the open access playbook: the “open access policy.” It’s a bland name for a powerful legal maneuver, and to answer this year’s theme, “open for whom,” an OA policy can make the status quo scholarly publishing system *open for authors* in a way that preserves their freedom of choice about publishing venue by making an open option available regardless of venue. We can supercharge OA policies by combining them with tools like the [MIT Framework for Publisher Contracts](http://news.mit.edu/2019/mit-announces-framework-guide-negotiations-publishers-1023), turning the abstractions in the policy into concrete gains for public access to knowledge.

But what is an open access policy? In copyright terms, an open access policy is a non-exclusive license, granted to the university on behalf of all faculty, permitting the university to collect, preserve, and make freely available the scholarly articles created by members of the faculty. Because the policy is a license (not a transfer), and it is not an exclusive license, the author retains her copyright and is free to publish the article anywhere else she chooses. 

These policies have been adopted by [767 institutions](http://roarmap.eprints.org/view/policymaker_type/research=5Forg.html), and the most popular model for such policies is the [Harvard Open Access Policy](https://osc.hul.harvard.edu/assets/files/model-policy-annotated_12_2015.pdf). With an open access policy in place, faculty can publish wherever they like, including in subscription journals, and still make their research available in an [open repository](https://libra.virginia.edu) where any interested reader can find it. Creating this comprehensive, open record of knowledge, on infrastructure we control, is a key part of realizing the full potential of open access.

Many scholars support open access ideologically, and [research shows a correllation](https://peerj.com/articles/4375) between open access and higher citations. An equitable open access ecosystem should provide all scholars with a meaningful opportunity to choose open access, but several pressures in the system threaten to undermine that vision. Open access policies counteract those pressures, making OA more equitable for scholars in several ways. 

Perhaps the most obvious threat to equity for scholars who wish to publish in the open is the imposition of publishing fees on authors. Models of open access where the author pays a fee to the publisher (an “article processing charge,” or APC) can place open access out of reach for authors who don’t have grant funding or institutional funds to defray the high (and [fast-growing](https://www.liberquarterly.eu/article/10.18352/lq.10280/)) costs of some APCs. Many researchers, institutions, and even entire fields of study (the humanities and most social sciences) simply don’t have access to the funds required to support an APC-dependent model of open access. With an open access policy in place, scholars can publish anywhere they like, including traditional subscription journals that do not charge author fees, and still make their work open in their institutional repository. 

Another source of inequity in open access is the difficulty that some scholars (especially pre-tenure ones) may face in choosing to publish in open venues when publishing in closed ones may be important for their career prospects. Until the academy [realigns its incentive structures](http://sites.nationalacademies.org/pga/brdi/open-science-roundtable/index.htm), scholars will sometimes face tough choices between publishing open access and publishing in journals that act as a de facto credential in their field. Open access policies can solve the dilemma—publish in your chosen journal, and place the appropriate version in the repository.

A third source of inequity in open access is the lack of bargaining power that many scholars feel as they enter into negotiations with journal publishers. If that publisher is not open by default, then the author has to act as her own lawyer, modifying the contract or [adding an addendum](https://sparcopen.org/our-work/author-rights/), and hoping her editor doesn’t get upset. I am often quick to remind folks that, in fact, they have more power than they think, and it never hurts to ask. Still, one of the chief legal benefits of an open access policy is that it sets the default expectation in favor of open access. Rather than the author having to ask to make her work open, putting a policy in place shifts the burden to the publisher, who must ask for a waiver of the policy (or an embargo of the deposit), or else the university’s license will stand. 

Make no mistake: open access policies are not a panacea. Perhaps most importantly, they are not self-executing. Depositing a version of your article in Libra is an extra step in the publishing workflow, and for many scholars it’s one that doesn’t yet come naturally. Savvy publishers have also learned that they can soften the impact of these policies by demanding waivers or embargoes as a matter of routine. That’s why an open access policy has to be part of a larger campus strategy that includes, for example, a commitment to the principles in the MIT Framework. Most importantly, the Framework shifts the burden of deposit to the publisher, as part of the services we pay (handsomely) for in our subscriptions. Equally key, though, is the Framework’s insistence that the institution’s authors retain their copyright and cannot be forced to waive the open access policy as a condition of publication. Taken together, an OA policy and the MIT Framework describe a world where authors are free to publish wherever they like, and the products of their research are free to all who wish to access it.

UVA is halfway there. We have [endorsed the MIT Framework](https://news.library.virginia.edu/2019/10/23/statement-of-virginia-research-library-deans-and-directors-on-endorsing-the-mit-framework-for-publisher-contracts/), but we do not, yet, have a true open access policy. About a decade ago, the faculty senate passed a [resolution](https://libraopen.lib.virginia.edu/public_view/m900nt527) encouraging faculty to publish open access and to use Libra, but that resolution lacks the legal teeth required to grant the licenses that power a systemic, automated approach to populating the repository. Adopting an open access policy would be a powerful step in favor of equitable open access at UVA.  

