---
layout: post
published: true
comments: true
date: '2019-10-22 13:08 -0400'
title: >-
  OA Week Guest Post: OA Deposit Can Help Turn the Tide Against Extractive
  Research
categories:
  - open access
  - OAWeek2019
---
*Our first guest post for OA Week 2019 is by [Rebecca Cooper Coleman](https://www.library.virginia.edu/staff/rac8f/), Research Librarian for Architecture. Rebecca's work on a regional equity atlas started from a recognition of the long-running problem of universities engaging with their communities in a way that doesn't always reflect the equitable and public-spirited aspirations of the academy. Reforming a university's approach to its neighbors can be difficult; here Rebecca explains how open access to research can be a relatively simple step in the right direction.*

In October 2018, the Library was awarded a planning grant from the Institution for Museum and Library Studies to explore the co-creation of a [Charlottesville regional “equity atlas”](https://equityatlas.lib.virginia.edu/).  Work on the grant has brought our team into conversation with numerous folx in our community who are doing incredible equity work in our region.  One of the goals of the atlas is to bring together data and stories about our region that can directly impact policy, advocacy, and accountability.  In these conversations, we’ve heard a lot about how local experts share their own information, but also how research conducted at UVA is (or is not) shared. 

A number of stories I’ve heard haunt me as a librarian. 

- Each semester, a number of courses knock on the doors of our neighbors living in public housing. They are brought there by course assignments and research projects. They ask their survey questions, and disappear.  Another student comes, and asks similar questions, but for a different assignment.  They, too, disappear.  No one in our community ever sees the survey results or resulting research.  

- A community expert meets with a faculty member who offers to have students work on a local issue.  The community expert spends a number of hours passing along information and knowledge.  After the semester begins, there is no further communication from the faculty member until someone sends the community expert a link to the faculty member’s website which contains the results of the coursework, but with no mention of the community expert.  A few weeks later, the website is down and the information is inaccessible.

- An architecture student is working on local foodways.  They’re told that another student has worked on a similar topic, and also that there was a faculty member doing related research.  Despite searching, no one can find that research.  She starts from scratch.


There are numerous lessons to be learned in these stories about our shortcomings as an institution to ethically engage our community in research, but I’m going to single out one—the repeated failure to ensure that our community has access to work done with, by, for, or about our region.  Not sharing research that concerns our community *with* our community is an extractive habit that positions our neighbors as subjects in a laboratory experiment.  If we truly want our scholarship to be both “great and good” as President Ryan’s [strategic plan](https://strategicplan.virginia.edu/) rightly proposes, we need to do much better—and we can.  We have the ability to fix this, now.  

**Work produced at UVA that concerns our local community should be deposited into [Libra, our Open Access repository](https://www.library.virginia.edu/libra/).  That’s it.  It’s easy.**  Student work, data sets, research artifacts—all can be deposited into the repository where they become discoverable at a stable location.  Faculty can deposit data sets, white papers, and pre-publication versions of articles and book chapters. (Check your [publisher’s policies](http://sherpa.ac.uk/romeo/index.php) for those last two.)  In the repository, these items are available to practitioners and researchers in our community—to civic leaders, activists, and the curious. The work can be discussed, challenged, and built upon.  Instead of an extractive model, we open the door for collaborative scholarship and co-creation of knowledge about our region.

Yes, we all might hesitate to do this.  What if no one reads it? What if they DO read it, and find fault? What if student work from my course isn’t what I wish it was? What if the data is too raw, the draft too rough, or the project was a failure? We might counter with: What if that work helps a local nonprofit get a grant? What if it prevents the next project from failing? What if your citations help a local initiative move faster or save money they would have spent for research? What if having your work discoverable allows others to connect with you and your work in ways that make a difference?

Let’s begin, today. Upload data, photographs, design plans. Build access to student works into your next syllabus. Re-read your publishing contract, and upload a pre-publication copy of your work if it allows. Reach out to a student whose work might benefit our community, and ask them to share it. Ponder the long-term stability of a course website, and consider putting some of that content into the repository to ensure continued access. The library can help with all of these things, and we’re happy to.  Reach out to your Subject Librarian, or write to [library@virginia.edu](mailto:library@virginia.edu). Let’s do better.
