---
layout: post
published: true
comments: true
date: '2019-10-23 09:00 -0400'
title: 'OA Week Guest Post: Making It Easy to Do the Right Thing with Open Data'
categories:
  - open access
  - OAWeek2019
---


*Today’s OA Week Guest Post is by [Sherry Lake](https://www.library.virginia.edu/staff/sah), our scholarly repository librarian. For the last several years, Sherry has been focused on data sharing, supporting UVA researchers in managing their data and sharing it with our data repository, [LibraData](https://www.library.virginia.edu/libra/datasets/). For today’s post, Sherry explains how her work helps make it easy for researchers to do the right thing.*

Studies have shown that while most researchers appreciate the benefits of shared products of research, on an individual basis they may be reluctant to share their own work. ([Van den Eynden & Bishop, 2014)](http://repository.jisc.ac.uk/5662/1/KE_report-incentives-for-sharing-researchdata.pdf) Sharing the data from research, for example, is often difficult to do based on the complexity of data, current research practices, a lack of meaningful and direct incentives, costs, intellectual property, and public policy. ([Borgman, 2012](http://doi.org/10.1002/asi.22634)) As a result, making data open and freely available is not yet a routine part of researchers’ workflow or process. 

Christine Borgman in her paper “The Conundrum of Sharing Research Data”, describes four reasons for sharing data: 1) To reproduce and to verify the results of past research; 2) To make products and the results of publicly funded research available to the public; 3) To enable others to ask new questions of the existing data; and 4) To advance the state of research and innovation. ([Borgman, 2012](http://doi.org/10.1002/asi.22634)) 

Perhaps the strongest public policy argument for sharing research data is the ability to verify and reproduce research results. Reproducibility validates analysis and confirms the science, increasing the value of funders’ investments in research. Sharing data encourages others to use it and investigate new uses, helps to identify errors, discourages fraud, and increases the value of funding dollars by avoiding duplication of data collection. Reusing shared data thus has the potential to increase both research efficiency and quality for the benefit of all. 

But what about the benefit to an individual researcher? How does the research ecosystem encourage data sharing? Most of the external incentives are mandates and threats — “sticks.” These are beginning to have an effect, but have failed to create widespread change. At the Library, we try to add a few “carrots” to the mix by making it as easy as possible for researchers who want to share to do the right thing. This year’s OA Week theme asks, “Open for whom?” The “sticks” approach says “Open for the public good, for the funder, for science generally.” In the Library, we make sure open data is also as easy as possible—for the researcher herself.

## Sticks

Funders, journal publishers and scholarly societies are increasingly requiring that products of research be shared openly and promptly. Many threaten negative consequences for not making products of research available, including bars on future grants or future publishing in that journal, though these consequences don’t often always come to pass.

On February 22, 2013, the [White House’s Office of Science and Technology Policy (OSTP)](https://obamawhitehouse.archives.gov/sites/default/files/microsites/ostp/ostp_public_access_memo_2013.pdf) released a memo: To ensure that “…direct results of federally funded scientific research are made available…  Federal agencies investing in research and development (more than $100M in annual expenditures) must develop plans to support increased public access to the results of research….”  

In short, this directive aims to make the results of taxpayer-funded research – both articles and data – freely available to the general public. Most federal funders require a Data Management Plan during the proposal cycle, which describes how data will be managed through the grant and what data will be shared (and specifying *how* sharing will be enabled) once the funding is over. The memo also specified that results of research, published in peer-reviewed publications, be publicly accessible no more than 12-months after publication.

Funding agencies are not the only groups interested in making data open and available. Journals have begun to recognize a responsibility to ensure that other researchers can replicate and build on the studies that they have published. Nature Publishing Group and the Public Library of Science (PLoS) are examples of academic publishers that have adopted data sharing polices. By encouraging access to the data that underly the papers’ results, these publishers support reuse and validation or reanalysis of the findings they publish. Both Nature and PLoS provide lists of repositories that authors can deposit and make their data available.

Scholarly societies also have an important role in leading and facilitating discussions about open access to data. Many scholarly societies are publishers in their own right and have introduced mandatory data archiving policies in connection with publications in their journals. Other societies stress the importance of sharing data through their ethics guidelines, hoping to encourage behavioral changes by proclaiming that sharing data is the right thing to do. To increase the legitimacy, credibility, and openness of intellectually diverse research communities, the American Political Science Association, in 2014, integrated “Data-Access & Research Transparency” (“DA-RT”) principles into their Ethics Guidelines. ([APSA, 2016](https://www.dartstatement.org/)) And likewise the American Geophysical Union, in its “Scientific Integrity & Professional Ethics” guidelines, states that members have a responsibility to share data & findings openly and promptly. ([AGU, 2017](https://publications.agu.org/author-resource-center/publication-policies/data-policy/)) 

  


## Carrots

Researchers have not moved en masse toward sharing data just because it is good for science. Even sharing “requirements” have not led to widespread cultural change, yet. Researchers need the recognition that comes with a prime article placement for promotion and tenure. There are far fewer positive incentives to share data. 

In the absence of strong requirements or compelling career rewards for data sharing, the main “carrots” on offer for researchers inclined to share their data are the support, training and infrastructure that make it as easy as possible to do the right thing. 

The UVA Library offers all of these supports. The Research Data Services group offers workshops and help with funder data management plans. The Scholarly Communications group supports open repositories ([LibraData](https://www.library.virginia.edu/libra/datasets/) and [LibraOpen](https://www.library.virginia.edu/libra/open/))—places to make your research open. 

So come talk with us and let us help you share your data. It’s good for science, for the world, and even for the impact of your own research.
