---
layout: post
published: true
comments: true
date: '2019-10-07 13:14 -0400'
title: >-
  Weekly Big Deal Longread: “Article Processing Charge Hyperinflation and Price
  Insensitivity: An Open Access Sequel to the Serials Crisis”
categories:
  - big deal
  - APCs
  - Serials Crisis
---
*Khoo, S. Y.-S. (2019). Article Processing Charge Hyperinflation and Price Insensitivity: An Open Access Sequel to the Serials Crisis. LIBER Quarterly, 29(1), 1–18. DOI: http://doi.org/10.18352/lq.10280*

It will not be news to readers of this blog, or of the news feed at the UVA Library, that I think the commercial Big Deal subscription model is broken. It is hardly an original or under-represented opinion—it is the emerging consensus at research libraries worldwide. But if paywalls are the problem, what’s the solution? 

One approach that is seemingly ready at hand is to transform subscription payments into APCs (article processing charges), with the resulting articles free for all to read. That certainly solves one paywall problem—cost would no longer be a barrier *for readers.* It is not at all clear, however, that imposing a cost barrier *on authors* (or authors’ funders, or their institutions) will lower the cost of publishing overall. 

One way to predict what might happen to APC prices over time is to look at what already has happened in the many journals that have started using APCs (and raising APC prices) in recent years. The answer, in a nutshell, is, “Nothing good.” That’s what Shaun Yon-Seng Khoo tells us in this week’s longread, “[Article Processing Charge Hyperinflation and Price Insensitivity: An Open Access Sequel to the Serials Crisis](https://www.liberquarterly.eu/article/10.18352/lq.10280/#),” which looks at whether adopting APCs and raising APC prices leads to any drop-off in demand. 

It doesn’t. Indeed, it appears from the data that APC prices are as inelastic as subscription prices, perhaps moreso. This may be due to the way authors perceive the value of journal prestige—either as a necessity that must be had at any price (tenure, status, and future grants depend on publishing “well,” after all), or else as a “luxury” item that is more valuable precisely because it is more expensive. Either way, forces at work in the “market” for APCs seem destined to play just as much havoc on our budgets as the serials crisis did, if not more. 

This graph shows the growth in APCs compared to standard measures of inflation in the US and EU:

![X-Y Line graph showing prices of APCs starting in 2005 and growing much faster than CPI until 2018.]({{site.baseurl}}/images/10280-22891-1-PB.jpg)

Here’s Khoo’s conclusion:

> Open access publishing has been suggested as a potential solution to the serials crisis because journal costs are theoretically more exposed to price competition. However, examination of journal article volumes when article processing charges are introduced or increased over time shows no evidence that authors avoid journals that introduce or increase APCs. Instead, it appears that once authors are willing or able to pay an APC, that they are willing to pay them with little regard to the size of an APC. This data suggests that publishers are adept at pricing journals according to the prestige value of the title and the funding available to authors in each market. Unless funders and institutions leverage their negotiating and policy-setting power to constrain costs, author price insensitivity will ensure that APC-funded open access will merely be a sequel to the serials crisis.


h/t [Bjorn Brembs](http://bjoern.brembs.net/2019/10/is-open-access-headed-for-a-cost-explosion/)!
