---
layout: post
published: true
comments: true
date: '2019-05-03 11:53 -0400'
title: >-
  Weekend Big Deal Longread #2: The Changing Academic Publishing Industry –
  Implications for Academic Institutions, by Claudio Aspesi
categories:
  - big deal
---


> The move by publishers into the core research and teaching missions of colleges and universities, with tools aimed at evaluating productivity and performance, means that the academic community could lose control over vast areas of its core activities. In addition, the collection of massive amounts of data about faculty and students poses a significant legal and reputational risk for institutions, along with potential privacy and security threats for individuals.

*from Claudio Aspesi, [The Changing Academic Publishing Industry – Implications for Academic Institutions](https://sparcopen.org/our-work/landscape-analysis/)*

This week's weekend Big Deal Longread is an [in-depth analysis of the academic publishing industry](https://sparcopen.org/our-work/landscape-analysis/), including both research and textbooks/teaching materials. (While not directly relevant to the Big Deal, there is a new urgency in understanding the textbook industry, now that [two of the three dominant players are trying to merge](https://www.chronicle.com/article/Planned-Merger-of-Cengage-and/246224).) 

In this Landscape Analysis, commissioned by SPARC, Claudio Aspesi, a market analyst who has been following the industry for more than a decade, takes a look at the financials, the business models, and the strategic plays of the biggest companies in these sectors, and concludes with some recommendations and words of warning for institutions of higher education. While Aspesi predicts the big publishers will cling to the Big Deal and to paywalled content models for as long as possible, he also urges higher education institutions to be wary of the big publishers' moves toward becoming dominant in data analytics, monetizing the entire scholarly workflow in ways that could cut to the core of universities' missions.

Regarding Big Deal price increases, Aspesi observes:

> Historically, Elsevier has pursued price increases in the region of 5% annually, and justified this request with the parallel 5% growth in articles it publishes. This argument is flawed for two reasons: it assumes that there are neither productivity gains nor scale economies anywhere in the business. The first part of the argument is surprising – if productivity at Elsevier does not rise, then management is not doing its job properly – and the second part of the argument is wrong – administration or IT staff does not rise just because more articles are published. 

> In light of the financial pressure on academic library budgets, refusing to pass along some of the savings is strictly a commercial and business decision, but it does invite retaliation from customers when possible. We have seen that Elsevier is effectively reinvesting some of these gains in new products and services which offer no benefit to libraries, as they are targeted to other users within universities (and even to completely different customers). In other words, librarians are asked to bear the financial burden of investments which will benefit some other category of customers, as well as the shareholders and management of Elsevier.

> Another issue with the request for an annual increase based on a larger number of articles published is the quality of those additional articles. Just because it is additional research does not make it equal in quality. In general, a large amount of published research may end up of limited or no use to subscribers. Data released by ten UK universities on readership in chemistry and life sciences journals show that 50% of journals account for 5 to 10% of all article readership[...] In the absence of obligations for leading journals to add articles at a pace that is at least in line with the overall growth rate of articles published, there is a significant risk that the average “quality” of the articles will decline. This, in turn, is a contentious issue for librarians asked to fund a growing number of journals and articles with no guarantee that their quality will be adequate.

The whole thing is worth your time. Enjoy, and have a great weekend!
