---
layout: post
published: true
comments: true
date: '2019-04-26 12:06 -0400'
title: >-
  Weekend Big Deal Long Read: “Is the staggeringly profitable business of
  scientific publishing bad for science?”
categories:
  - big deal
---


> “Scientists are not as price-conscious as other professionals, mainly because they are not spending their own money,” [Robert Maxwell] told his publication Global Business in a 1988 interview. And since there was no way to swap one journal for another, cheaper one, the result was, Maxwell continued, “a perpetual financing machine”. Librarians were locked into a series of thousands of tiny monopolies. There were now more than a million scientific articles being published a year, and they had to buy all of them at whatever price the publishers wanted.

- from Stephen Buranyi, *“[Is the Staggeringly Profitable Business of Scientific Publishing Bad for Science?](https://www.theguardian.com/science/2017/jun/27/profitable-business-scientific-publishing-bad-for-science)”*

The Big Deal has been the subject of quite a few interesting long reads — deep historical dives, scholarly critiques, and longer-form insights from librarians and others working with and observing the Big Deal phenomenon. Periodically I’d like to recommend one such piece for your weekend reading pleasure.

The perfect place to start, I think, is with a lively history of scholarly publishing by Stephen Buranyi for the Guardian, entitled “[Is the Staggeringly Profitable Business of Scientific Publishing Bad for Science?](https://www.theguardian.com/science/2017/jun/27/profitable-business-scientific-publishing-bad-for-science)” 

You can probably guess the answer, but the most interesting thing about the piece isn’t its version of the oft-repeated litany of dysfunctions in scholarly publishing. That part is good, and it is laid out in a clever narrative way in the piece’s introductory section, but the real highlight of the piece is its central story, which revolves around publishing tycoon Robert Maxwell, whose ambition and military connections put him in the right place at the right time to build the system of academic journals we are struggling to reform today. 

The story shows Maxwell pioneering all of the system’s excesses. The profit-driven proliferation of journal titles: 

> While his competitors groused about him diluting the market, Maxwell knew that there was, in fact, no limit to the market. Creating The Journal of Nuclear Energy didn’t take business away from rival publisher North Holland’s journal Nuclear Physics. Scientific articles are about unique discoveries: one article cannot substitute for another. If a serious new journal appeared, scientists would simply request that their university library subscribe to that one as well. If Maxwell was creating three times as many journals as his competition, he would make three times more money.

The spectacle of lavish vendor-funded receptions at academic conferences: 

> Scientific conferences tended to be drab, low-ceilinged affairs, but when Maxwell returned to the Geneva conference that year, he rented a house in nearby Collonge-Bellerive, a picturesque town on the lakeshore, where he entertained guests at parties with booze, cigars and sailboat trips. Scientists had never seen anything like him. “He always said we don’t compete on sales, we compete on authors,” Albert Henderson, a former deputy director at Pergamon, told me.

And the coopting of society journals:

> Scientific societies, such as the British Society of Rheology, seeing the writing on the wall, even began letting Pergamon take over their journals for a small regular fee. Leslie Iversen, former editor at the Journal of Neurochemistry, recalls being wooed with lavish dinners at Maxwell’s estate. “He was very impressive, this big entrepreneur,” said Iversen. “We would get dinner and fine wine, and at the end he would present us a cheque – a few thousand pounds for the society. It was more money than us poor scientists had ever seen.”

All seem to have their origins at least partly with Maxwell.

It’s a good story, and a reminder that none of the current system is divinely ordained or inevitable. A fair amount of it, in fact, could perhaps be traced to the ambitions and proclivities of a few individuals.

And here’s an unsurprising coda to the Maxwell story: “In 1991, to finance his impending purchase of the New York Daily News, Maxwell sold Pergamon to its quiet Dutch competitor Elsevier for £440m (£919m today).”
