---
layout: post
published: true
comments: true
date: '2019-04-18 14:01 -0400'
title: >-
  Welcome to "No Big Deal?": News and Links About the Cost, Value, and
  Sustainability of Big Journal Bundles
---
Today we are launching [No Big Deal?](https://www.library.virginia.edu/news/big-deal), a new feature of UVA Library News that will track the latest events and scholarship about the biggest vendors serving research libraries like ours. Tracking, shaping, and responding to this landscape has always been part of what the Library does, and we would like to share some of what we are seeing, doing, and thinking with you, the faculty, students, and researchers who use our collections. 

Big changes are shaking up the way research libraries around the world think about the biggest line items in our budgets, the journal bundles we call "Big Deals." In particular, we’re following stories about libraries [pushing back](https://news.library.virginia.edu/2018/04/26/no-big-deal-fsu-cancels-elsevier-bundle-citing-outdated-model-and-out-of-control-cost/) and even [walking away completely](https://www.universityofcalifornia.edu/press-room/uc-terminates-subscriptions-worlds-largest-scientific-publisher-push-open-access-publicly) from unsustainable deals. Increasingly bold initiatives abroad, from [research funders](https://www.coalition-s.org) and national-level university groups like those in [Germany](https://www.projekt-deal.de/elsevier-news/), [Sweden](https://www.the-scientist.com/the-nutshell/sweden-cancels-agreement-with-elsevier-over-open-access-64405), [Norway](https://www.insidehighered.com/quicktakes/2019/03/13/norwegian-universities-ditch-elsevier), and [France](https://www.the-scientist.com/daily-news/french-universities-cancel-subscriptions-to-springer-journals-29882), also merit attention. Global efforts to expand open access and contain subscription costs are sure to affect the ecosystem in the US. 

We're also seeing stories about new research on the [value](https://crl.acrl.org/index.php/crl/article/view/16829) of these library investments, the [values](http://www.openaccessweek.org/profiles/blogs/theme-of-2018-international-open-access-week-to-be-designing-equi) (like equity and inclusion) that inform new paradigms, and stories about new tools that empower [libraries](https://blog.openaccessbutton.org/new-powerfully-simple-library-tool-to-deliver-articles-no-subscription-needed-1c8b7def604f), [readers](http://news.library.virginia.edu/2018/03/08/unpaywall-and-oabutton-add-ons-put-open-access-research-at-your-fingertips/) and [authors](https://blog.openaccessbutton.org/announcing-direct2aam-helping-authors-find-author-accepted-manuscripts-f71462a68d1a) to legally access and share research beyond paywalls. 

From time to time we may also highlight some [foundational texts](http://www.budapestopenaccessinitiative.org/read) or [deep historical dives](https://www.theguardian.com/science/2017/jun/27/profitable-business-scientific-publishing-bad-for-science) that help situate this moment in a longer arc—they tell the story of the whole ecosystem, how it got this way, and visions for a better future. 

## Sharing Information Is Key

A key source of dysfunction in the market for scholarly resources is the separation of the user of these resources (you, if you’re part of the research community here at UVA) from the purchaser (the University, via the Library’s collections budget). As the Library considers whether and how to change the way it invests in resources like Big Deals, we will share what we are learning from our own analyses. We have already published an initial set of [budget disclosures](https://www.library.virginia.edu/collections/disclosures) that show what we are spending on our biggest journal packages, and how often (or how rarely...) some titles in these packages are actually used by our faculty. We have an even richer set of bibliometric data from the last 10 years or so that tells us not only which articles were read at UVA, but also which were cited, and where our faculty publish. All of this can help us get a clearer picture of the value of our biggest deals.

We will also be looking to you, our user community, to learn what you value and how you use the collections we build for you. In the meantime, these regular news updates and issue briefs are one way that we will share what we know and the stories we are following in this changing landscape. 

Next week, we'll say a little more about the history of the Big Deal and why the Library is more interested than ever in these developments.


## Postscript: Think Globally, Act Locally

While much of the news we highlight on this new page page will be institutional, national, or even international in scope, it is important to realize that individuals can make choices that help change the dynamic, too. We’ve highlighted some of them in the sidebar of the No Big Deal [landing page](https://www.library.virginia.edu/news/big-deal), and we will grow that list as we identify new opportunities and tools that might interest you. The unifying theme in these action steps is reclaiming control of scholarship and making choices about publication and related issues that are informed by their long-term consequences. These choices are not always easy, and some important incentives [aren’t yet aligned](https://www8.nationalacademies.org/pa/projectview.aspx?key=51293) with the deeper values of the research enterprise, but if more people consider taking these kinds of steps where possible, each step moves us closer to a better, more sustainable system.
