---
layout: post
published: true
comments: true
date: '2019-02-25 21:31 -0500'
title: Some Software-informed Thoughts on Fair Use and Licensing for Fair Use Week
publish: true
---
([Cross-posted](https://blogs.harvard.edu/copyrightosc/2019/02/26/fair-use-week-2019-day-two-with-guest-expert-brandon-butler/) at Kyle Courtney's *Copyright at Harvard Library* blog. Thanks, Kyle, for the invitation!)

I thought I knew a fair bit about fair use—then I started [doing more work with software](https://www.softwarepreservationnetwork.org). That's when I realized I hadn't thought quite enough about fair use and licenses. This fair use week, I want to share a little bit of what I've been thinking. For too long my quick-and-dirty rule of thumb for licensed content was that fair use would be of little or no value for works covered by a license. That's not an accurate picture, however, and it does a disservice to fair use!

## Non-overlapping magisteria 

I want to start with what I now see as the right way to think about these two issues. To borrow a fancy-sounding term from biologist Stephen Jay Gould, I conceptualize licenses and fair use as '[non-overlapping magisteria](https://en.wikipedia.org/wiki/Non-overlapping_magisteria)' — separate and compatible sources of authority for anyone in need of guidance about when they can use in-copyright material. Each source of authority tells us something important, and the two can co-exist (and give us meaningful, useful guidance) even when they are in apparent conflict. 

Licenses tell us *the boundaries of the permission granted by the copyright holder*. When I read a license, I learn what *the license* permits and what it does not permit. The copyright holder's power to license her works is a very valuable asset. Licenses often permit uses that far exceed anything that could be done under ordinary copyright law—installation of the same software on multiple machines, simultaneous access to the same digital book by multiple users, or access by one user across multiple devices, and so on. But licenses typically include limits—"for personal use only," "non-transferrable," and the like. These tell you where the permission granted in the license ends. 

Fair use is a doctrine in copyright law that allows certain uses of in-copyright works *regardless of permission.* To put it another way, *fair use is permission granted by law.* Users can promise not to exercise their fair use rights, but no copyright holder can unilaterally take away the permission given by law. 

It follows that user rights like fair use apply, by definition, precisely where permission has not been granted. A license that says "for personal use only" tells you the limits of the license. It doesn't tell you the limits of fair use.

Which is not to say that fair use always picks up where licenses leave off. To the contrary, we would expect that in most ordinary cases fair use will not permit licensees to exceed the scope of a license. Limitations in licenses are usually put in place as a way of protecting (or [segmenting](https://en.wikipedia.org/wiki/Market_segmentation)) a market. Courts would be loathe to find fair use if your activity directly undermines ordinary market exploitation. However, when a license no longer supports an active market, and adherence to a license would frustrate core purposes of copyright (like scholarship or teaching), fair use can apply.

## Unless They *Do* Overlap

There is one circumstance where license terms and fair use can come into direct conflict: where a user promises explicitly not to engage in activity protected by fair use (to create a parody from a licensed work, for example). Only licenses that not only limit the scope of permission, but also secure from the user a promise not to do certain things, can cause this conflict. 

In these cases, though, what is the consequence for the licensee who breaks her promise? I'd suggest that if such uses are still fair, then failure to comply with the license can't make you a copyright infringer. You may be in breach of the agreement, and the licensor could sue for damages due to the breach, but the extraordinary statutory damages (infamously up to $150k per work for willful infringement) associated with copyrights are off the table. This should lower the stakes considerably for folks considering fair use.

One last thing you can consider if you're concerned about anti-fair use language in a license agreement: a contract only binds the parties to the agreement, not third parties. Someone who comes to possess a digital work without ever affirmatively agreeing to license terms (e.g., a second-hand purchaser who never sees a shrink-wrap license or clicks on a pop-up "I agree" button) is not likely to be bound by those terms. They would also not be able to benefit from the license, but that's where fair use would have a role to play.
