---
layout: post
published: true
comments: true
date: '2018-11-09 15:11 -0500'
title: 'The Latest in GSU, or, We Must Imagine Judge Evans Happy'
---
> “The struggle itself ... is enough to fill a man's heart. One must imagine Sisyphus happy.”

_Albert Camus, The Myth of Sysiphus_

Poor Judge Orinda Evans. She took senior status in 2008 — a kind of pre-retirement for federal judges where they don’t quite step down, but their caseloads get lighter, they take fewer clerks, and life generally becomes a little more civilized, I imagine. Sadly, that was also the year that the Copyright Clearance Center and the Association of American Publishers decided to send its straw plaintiffs (SAGE, Oxford U Press, and Cambridge U Press) down to Georgia, [looking for a soul to steal](https://www.youtube.com/watch?v=K6RUg-NkjY4), er, a school to sue. They were angry about the widespread practice of university libraries and faculty scanning excerpts of books and making them freely available to students as part of course websites. *Ten years later*, the 11th Circuit Court of Appeals just told Judge Evans to take a *third* run at resolving this awkward case.

I have [already written](https://osf.io/mga87/) about this. Like, a lot. But hey, the 11th Circuit wants us to keep going, so here goes: What I have written in the past, in a nutshell, and what I still believe, is that this case is like a fair use clash between an unstoppable force (favored educational use) and an immovable object (a facially valid claim of lost revenue). Indeed, fair use is *essentially always* a clash of this kind: a user argues her use is legit, but a copyright holder says she wants to be paid. How to resolve this recurring conflict? There are a couple of tried-and-true ways, but so far no one in this case has successfully pulled it off. And because no one can tell a story that actually balances the fair use factors in a satisfying, overarching way, we are stuck.

Judge Evans has tried to do it by sheer force of mathematical will, literally devising equations and plugging in values for variables to evaluate dozens of individual acts of copying in a formally consistent way. She’s analyzed the profit & loss statements of the plaintiffs to try to discern the likely market value of using 12 pages from one of their books (not much). She [spent 350 pages](https://scholar.google.com/scholar_case?case=18306741473986959577&q=Cambridge+University+Press+v.+Becker&hl=en&as_sdt=6,47) doing this kind of stuff the first time. Not much less the second time. 

Each time (TWICE!), the 11th Circuit has responded **not** by telling her what fair use **is**—what meta-principle or overarching priority she should use to rebalance her equation and break the tie— but instead by telling her what fair use **is not**. The [latest opinion](http://media.ca11.uscourts.gov/opinions/pub/files/201615726.pdf) is astonshingly short (considering it took more than a year to write) and comprised mostly of background on the case, followed by a brief round of negative feedback for Judge Evans. Fair use is not a mathematical formula. It cannot be decided mechanically. There are some affirmative statements in the mix, I guess - fair use is “holistic,” it is “case-by-case.” But those words also describe reading tea leaves and tarot cards. It’s no way to run a railroad, or an exhausted district court. What is a judge supposed to do when faced with a compelling fair use purpose (education!) AND a compelling claim of market harm (people used to license this on paper, but suddenly they don’t when it’s in the cloud!)?

Of the four fair use factors, courts have always been transfixed by either the first (purpose, namely, whether it’s the kind of purpose we typically want to encourage by permitting it without permission) or the fourth (market harm, especially from substitution of the user’s copies for ones licensed or purchased from the copyright holder). They consider the other two (nature of the work, and amount/substantially of use), but typically the second factor (nature) doesn’t matter and the third (amount) is heavily influenced by how the court sees purpose and/or market harm. To decide who wins in the battle of factors, courts have made recourse to two theories of fair use. Each theory centers one factor as the key or heart of the inquiry, and uses it as a lens for evaluating the others.

The first theory is the market failure theory of fair use, [articulated by Wendy Gordon](https://open.bu.edu/bitstream/handle/2144/22971/82ColumLRev1600_web.pdf?sequence=1&isAllowed=y) in the early 1980s, and adopted by the Supreme Court in *[Sony v. Universal](https://en.wikipedia.org/wiki/Sony_Corp._of_America_v._Universal_City_Studios,_Inc)*. This theory makes the 4th factor central, and was dominant in the early days of post-1976 Act fair use, especially after *Sony* (the VCR case) and *[Harper & Row](https://en.wikipedia.org/wiki/Harper_%26_Row_v._Nation_Enterprises)* (about a leaked chapter from President Ford’s memoirs—seriously) expressly declared market harm the most important factor. 

But purpose ascended and eventually eclipsed market harm starting in 1994 with the Supreme Court’s opinion in *[Campbell](https://en.m.wikipedia.org/wiki/Campbell_v._Acuff-Rose_Music,_Inc)* (a case about 2 Live Crew and Roy Orbison). That case enshrined “transformative uses” in particular as the kinds of purposes that were so deeply favored by fair use that the first factor would drive favorable outcomes in all the other factors, including market harm, even when the new use was highly commercial. Scholars have shown that transformative use is overwhelmingly decisive in contemporary fair use cases—transformative uses win, non-transformative ones lose, almost every time. Courts are quick to say that a use doesn’t *have* to be transformative to be fair, and they have blessed a few allegedly non-transformative uses as fair, but these are by far and away the exceptions to the rule.

Unfortunately for all involved, the meta-principles that drove decisions in both eras—market failure in the 80s, transformative use increasingly since the mid-90s—just aren’t catching on in the present case. The market for licensing excerpts of books exists, but it’s kind of mushy and fake-looking. CCC holds its hand out, sometimes, but they don’t DO anything, and many publishers don’t participate in their scheme. Judge Evans spent hundreds of pages poking at this lame quasi-market, and found it mostly wanting. But it’s not totally, hopelessly failed, the way a “market for permission to use a VCR to tape football” was obviously a doomed proposition in the early 1980s. The publishers have tried to center market harm, but the court hasn’t bought in.

Transformative use also isn’t much help, at least as this case has been litigated. (My [paper](https://osf.io/mga87/) suggests several ways to argue teaching is transformative, but like most schools, GSU had not centered transformative use in its fair use thinking at that point.) GSU has not argued (as transformative use requires) that its purpose is somehow distinct from the publishers’ original commercial one. It has just said its purpose is favored by fair use, because it’s educational. That’s certainly true—teaching is listed (including “multiple copies for classroom use”!) explicitly in the statute as an example of a favored purpose. But favored purpose is just one factor. How do you get outside the factors? How do you break a tie between this important factor and the market effect under the fourth factor? In the transformative use paradigm, courts say that a transformative use by definition doesn’t harm the market for the original because it serves a new purpose. That argument isn’t available here, so the market harm evidence stands. And the 11th Circuit has now told Judge Evans to give it substantial weight.

With two crucial factors in near-equipoise, and without recourse to the two frameworks that have driven cases for more than 40 years, I honestly don’t know what Judge Evans is supposed to do. But I’m afraid we may have gotten one ominous sign in the 11th Circuit’s recent opinion: Judge Evans is instructed to give market harm substantial weight, and to consider the risk of market substitution to be very high. The educational purpose, on the other hand, is given only moderate weight. 

But, on the third hand, every individual act of copying by GSU is to be considered holistically, in its own uniqueness, case-by-case, no math allowed.

This is not a situation conducive to principled argument, nor will it give the rest of us anything to guide us in making our own policies post-GSU, if there ever is a post-GSU. It’s putting a multiplier on one side of an equation and a discount on the other, and then telling the court not to do the math. The situation is becoming absurd.

If I were Judge Evans, who clearly prefers GSU and its obviously beneficent uses to the publishers and their fake-looking “markets,” I’d very strongly consider writing a third opinion that considers each use individually, holistically, giving substantial weight to market harm, but conclude in each case that overall, in light of the purposes of copyright, of which education is among the primary if not the primary intended beneficiaries, I have no choice but to find every single use by GSU was fair. Fair use cannot be reduced to an equation, after all. On what grounds could the 11th Circuit reverse—that her opinion is insufficiently mathematical? And yet, I suspect they would find a way. And like Sysiphus, Judge Evans and these litigants will be sent chasing the course reserves boulder back to the bottom of the hill.