---
layout: post
published: true
comments: true
date: '2018-10-31 15:06 -0400'
title: Text of my remarks in today's Hyde Park Debate on Freeing Scholarship
---
This afternoon I had the pleasure of engaging in an Oxford-style debate sponsored by the [Charleston Library Conference](https://www.charlestonlibraryconference.com/). The topic? "Resolved: all scholarship must be made freely available for access and reuse." I argued in favor, and I'm proud to say I "won" (which, in the rules of this kind of debate, means that more people changed their mind in favor of my side over the course of the debate). It was fun, and I wanted to reproduce my opening statement and rebuttal here, in case you're interested in reading them. My opponent, Angela Cochran, was a great sport and raised important issues that I think we should address—after we make all scholarship free to read and reuse. :)

So, without further ado, here's my side of the debate. I don't have links to Angela's remarks, but if I get them, I'll update this post to include the link.

# Charleston Conference Hyde Park Debate - Brandon Butler Opening Statement

Hello! I’m here to convince you that “all scholarship must be made freely available for access and reuse,” something I strongly believe to be true. Thanks to Rick Anderson and to the Charleston folks for inviting me to share my reasons with you, and hopefully win a few of you over to my cause. 

I’m going to proceed by defining two key terms: “freely available for access and reuse” and “scholarship.” If you agree with me about the proper meaning of these terms, I think you’ll also agree that the resolution should be affirmed.

First, I take “freely available for access and reuse” to be roughly equivalent to “free of copyright restrictions.” That is, the resolution doesn’t require publishers to donate their services to the public; the infrastructure that supports access must be paid for, and there are a number of ways to do that. Some of them may even involve imposing limits on access to scholarship, and I believe some such limits clearly do not violate the meaning of this resolution. 

For example, turning off access to a server because no one paid the cost of running the server wouldn’t violate this resolution. Neither would refusing to publish an article because no one is willing to pay for the scarce time and effort which is required to do so. The resolution does not require that we all drop what we’re doing and donate our time and resources freely to the infinite proliferation of scholarship. 

What the resolution requires is only that we refrain from charging the kind of fees that copyright enables rights holders to charge, which are grounded not in the value of the scarce services or facilities that make access possible, but in the value of the content itself.

So, while there are surely dozens of other ways to think about this issue and reasons to support this resolution, for me today’s resolution is really about copyright, and my support for today’s resolution follows directly from my understanding of the purpose and justification of copyright in the Constitution, the caselaw, and the Anglo-American legal tradition. If you’ll bear with me while I describe some of these core precepts in the law, I will then return to the nature of scholarship to show why taking these precepts seriously means scholarship must be free.

The two copyright principles that undergird my argument are 1) Copyright’s reliance incentives as justification, and 2) its policy of protecting only expression while excluding facts, ideas, systems, and other forms of knowledge. 

First, let’s talk incentives. The constitution tells us that copyright is a means to an end. Article I, Section 8, clause 8, provides that “Congress shall have the power...to promote the progress of science and the useful arts, by securing to authors for limited times the exclusive right in their writings and discoveries.” That “to...by” structure tells us that *progress* is the goal; granting exclusive rights for limited times is a mere *means* to that goal. So in our constitutional framework, copyright needs a utilitarian justification. When limiting access and reuse no longer promotes progress, it loses its constitutional rationale.

The heart of this justification is the assumption that a limited term of protection provides authors with a necessary *incentive* to use their scarce time producing original works of expression. Without copyright, an author might not take the risk of writing a book only to have others copy and sell the book without sharing the proceeds. Would-be creators will divert their time to more remunerative pursuits. Recent Supreme Court cases tell us that incentives for distribution are also a goal of copyright, as publishers are presumed to require some exclusive control over their catalog in order to earn a profit. 

So, copyright is all about incentives. No need for incentives, no need for copyright.

Now, let’s talk about copyright and knowledge. Here’s where I get to bring in a local celebrity from right here in Charlottesville. The founder of UVA, Thomas Jefferson, famously wrote, “He who receives an idea from me, receives instruction himself without lessening mine; as he who lights his taper at mine, receives light without darkening me.” This is the 18th Century version of “information wants to be free.” Or, as an economist would say, information is non-rivalrous: it can be shared infinitely without running out. And copyright in the US has been carefully crafted and applied in the courts so as to avoid interfering with the free flow of knowledge, while giving authors limited rights to control the use of their original expression. 

So, copyright in a given work applies only to its original expressive content, not to any facts, ideas, discoveries, and other forms of knowledge that are expressed in it. Anyone is free to talk about, write about, and build upon theories and discoveries, though they are not (yet) free to share the particular embodiment of that discovery in say a journal article. This is how Malcolm Gladwell can make a career by hunting for interesting findings in scholarly literature and then re-expressing them in formats more enjoyable to lay readers.

Finding and distributing facts and ideas can be expensive, hard work, and some have argued that the law should reward this “sweat of the brow” by granting exclusive control to those who do it over not just expression but facts, too. The Supreme Court has clearly and expressly rejected these arguments. In *Feist v. Rural Telephone Co.*, a case about dueling telephone books, Justice O’Connor wrote passionately that facts must remain free. 

> It may seem unfair that much of the fruit of the [fact] compiler's labor may be used by others without compensation. [H]owever, this is not "some unforeseen byproduct of a statutory scheme." It is, rather, "the essence of copyright," and a constitutional requirement. The primary objective of copyright is not to reward the labor of authors, but "[t]o promote the Progress of Science and useful Arts." To this end, copyright assures authors the right to their original expression, but encourages others to build freely upon the ideas and information conveyed by a work

In later cases the Court identified the idea/expression dichotomy as one of the “First Amendment safety valves” in copyright, without which the law would be in conflict with the right of free expression. 

One last copyright doctrine bears mentioning: merger. Under the merger doctrine, if a fact or an idea is susceptible to only a few modes of expression, those expressions are said to “merge” with the underlying fact, and to be exempt from copyright protection. Merger prevents a copyright holder from obtaining a monopoly on a fact or idea by securing a copyright in an essential mode of expressing it.

So, copyright does not protect facts, ideas, discoveries and other forms of pure knowledge. Even when these things are expensive to discover or to share, copyright withholds protection and forces discoverers of facts to find alternative ways to recover their costs. Jefferson’s taper must be free to spread its light.

So, now we can turn back to “scholarship,” by which I mean the written record of new ideas, discoveries, theories, arguments, and counterarguments created by scholars and published with the primary goal of conveying new knowledge. Scholarship has two key characteristics that make it a poor fit for copyright protection.

First, scholars do not need (and do not receive) copyright’s incentives for creation. Scholars write to expand the frontiers of knowledge, to accrue prestige in their field, and as part of their professional duties and identities. They do *not* write in hopes of participating in the profits generated by selling access to their work; indeed they are almost never compensated monetarily by publishers or readers. University salaries, grant funding, and other systems provide scholars all the monetary security they need to pursue research.  

What about publisher incentives? There I have two responses. One is that there are plenty of ways to get publishers paid for their work that don’t involve charging for access and reuse of scholarship. You all probably know the various models better than I do. And of course, there are reasonable arguments that “publishing” as we know it isn’t necessarily a great fit for scholarship, and that something more like federated open repositories run by universities would be better. In any event, there is no reason to believe that in a world without copyright, scholarship would cease to be published.

Indeed, there is good reason to treat publishers of scholarship the way the Supreme Court treated the phone book publishers in Feist, i.e., to hold that the principle of free flow of knowledge trumps any concern about their incentives. We should take that approach because the *primary value* of scholarship is in its novel contributions to knowledge, not its expressive virtues—the clarity or entertainment value of its prose, for example.

The logic of merger also applies neatly to scholarship. When someone is looking to fully access the facts in scholarship, they insist on reading it in the “version of record.” A digest or summary that purports to produce the key results of research but not in the original words of the researcher simply won’t do. This extremely close connection between scholarship and the uncopyrightable knowledge it describes should trigger the merger doctrine. Unless we free the authoritative scholarly expression of knowledge, we are unduly constraining the the spread of knowledge itself.

So, since copyright’s incentives are not needed, and its application fetters the free flow of uncopyrightable facts and ideas, scholarship should be free of copyright restrictions. All scholarship must be made freely available for access and reuse. Thank you. 


# Rebuttal to Angela Cochrane’s Opening Statement


Angela makes a variety of interesting arguments in her opening statement, but they all miss the point. The resolution is a mandate, not a prediction. We resolve that “All scholarship **must** be free” not “All scholarship **will soon** be free.” Endorsing the resolution is mandating the result, not predicting it.

And that’s important, because all of the challenges Angela raises threaten to keep us stuck in this dysfunctional, wasteful model for years to come. We need a mandate to cut through the inertia and unleash the creativity that’s needed to develop new models and tools to support free scholarship. Once we mandate that scholarship be set free, her objections evaporate.

Angela suggests that setting scholarship free would be frustrated by diversity of opinion, across disciplines, countries and funders, and that the humanities in particular would suffer. In fact, once we set scholarship free, diversity would let the disciplines learn from each other, the way many have started preprint servers based on physical scientists’ use of ArXiv. Diversity would be a source of strength. 

Humanists in particular would benefit. While some models of free access may be an awkward fit for them, the current model is already toxic. The explosive growth in cost for STEM content has driven library purchasing of monographs and other humanities content steadily down for decades. Humanists will certainly be better off in a world where libraries aren’t paying millions for access to prestige STEM journals.

Angela asks which “scholarship” should be freely available. Simple: All of it. All of it is written by authors with no expectation of royalties from licenses. If we set it all free, the vendors and service providers who support it will have to compete on quality and price, not entrenched copyright monopolies. Creativity and competition will be unleashed right alongside knowledge.

Finally, Angela mentions that academic authors sometimes misunderstand or mistrust open licenses, or they prefer restrictive ones. Here we have some education to do, for sure. For example, passing off another’s work as your own is clearly barred by the CC-BY license (among other things). Mandating that all scholarship be free would help allay these fears, because *no one* would be able to profit commercially merely from selling access to scholarship. And *anyone* could easily use the scholarly literature and detect plagiarists and identify the true progenitors of ideas. 

The status quo is much worse for authors, whether they realize it or not. Big commercial actors profit massively by free-riding on academic work, at the expense of academic institutions; they deny access to millions who can’t afford it; they bar authors themselves from sharing their work on their own websites, repositories, or academic social networks. Scholars may be wary of a world where their work is free, but they are much worse off in a world where it is locked away.

