---
layout: post
published: true
comments: true
date: '2018-10-25 22:05 -0400'
title: >-
  Libraries, Archives, and Museums: Stop Worrying About the Digital Locks on
  Software! (But you still need fair use.)
---
So the new round of [DMCA rules](https://www.gpo.gov/fdsys/pkg/FR-2018-10-26/pdf/2018-23241.pdf) came out this Thursday morning! They were actually prereleased on Thursday, will be printed in the Federal Register on Friday, and will go into effect on Sunday, 10/28. The amazing [Harvard Cyberlaw Clinic](https://cyber.harvard.edu/teaching/cyberlawclinic), who took the lead in securing the rules protecting software and video game preservation, is working on an explainer that I’m sure will be more thorough and probing, but I know folks are itching for a quick digest. So, in 400 words or so, what do the new rules mean for software preservation? 

First, what are these rules about? Surprise: they aren’t about copyright! These rules only apply to the “paracopyright” law added in 1998 as Section 1201 of the Copyright Act, which makes it a *separate offense* to circumvent a technological protection measure that effectively controls access to a work, i.e., to break a digital lock (encryption, an authentication server, a dongle) that blocks access to software. The DMCA makes breaking locks a violation *even if what you subsequently do is lawful.* Indeed, that’s what the exemption process is for: allowing lawful activities that would be frustrated by the ban on breaking digital locks.

The new rule says, in essence, that if you’re a library, archives, or museum, and what you want to do with software afterward is lawful preservation activity (migrating to a new format, running it to access otherwise inaccessible files, making it available on premises for research, etc.), **go ahead and break the locks; don’t sweat the DMCA!** 

Which is a *huge* deal, because (as my colleagues and I documented in a [report](https://www.arl.org/publications-resources/4468-the-copyright-permissions-culture-in-software-preservation-and-its-implications-for-the-cultural-record#.Wn3MT0UrK1t) earlier this year) software has always had this *extra* cloud over it, over and above copyright, due to the proliferation of access control technologies in software. “Maybe what I’m doing is ultimately legitimate,” we were often told by preservation folks we interviewed, “but I had to crack the encryption to make it run, and that’s a whole separate legal hassle, right?” And they were right.

But not anymore!

Fair use still matters, though. Why? Because these new rules don’t give you protection against a copyright infringement claim. They permit breaking the locks, but only if what you want to do afterward is lawful.

How do you know your preservation activity is lawful? For starters, the fact that the government issued this rule actually should give folks substantial comfort, because *the Copyright Office, the NTIA, and the Librarian of Congress all agreed with us that copying for preservation is typically lawful.* Otherwise,they wouldn’t have issued the rule.  What convinced them? 

To some extent, software preservation is protected by the narrow statutory provisions that protect libraries and archives (but not museums!) in Section 108. But those protections are quite narrow, indeed. In its rules, the government acknowledges that software preservation relies on fair use for the majority of its legitimacy under copyright. That’s why you will want to consult the *[Code of Best Practices in Fair Use for Software Preservation](https://www.arl.org/storage/documents/publications/2018.09.24_softwarepreservationcode.pdf)* as well as the new DMCA rules. They work together to provide software collections with a zone of legal confidence that simply did not exist just a few months ago.
