---
layout: post
published: true
comments: true
date: '2018-09-24 10:04 -0400'
title: Introducing the Code of Best Practices in Fair Use for Software Preservation
---
I'm really excited about this. Today the Association of Research Libraries is publishing something I've been working on for a while now with a really wonderful team of facilitators and an amazing community of practitioners: the [Code of Best Practices in Fair Use for Software Preservation](http://www.arl.org/component/content/article/6/4630). ARL has a detailed press release [here](http://www.arl.org/news/arl-news/4629-software-preservation-best-practices-in-fair-use-to-help-safeguard-cultural-record-advance-research#.W6jtmBNKhTY), but I wanted to add a few of my own thoughts on the import of the document.

The *Code* was coordinated by [ARL](http://arl.org/), is the result of a project funded by the [Alfred P. Sloan Foundation](https://sloan.org/), and benefited immensely from being an Affiliated Project of the [Software Preservation Network](http://www.softwarepreservationnetwork.org/). I think the *Code* could be a game changer for a field where folks are already doing incredible work despite perceived legal uncertainty. I can't wait to see what the software preservation community does with a better sense of its fair use rights.

**TL;DR:** The Code describes five situations where fair use can apply to software preservation activities, ranging from initial ingest and format migration all the way to facilitating research via networked access to software held across diverse groups of institutions and collections. Fair use is a flexible exception to copyright's exclusive rights, and when fair use applies, you can use in-copyright material without seeking permission. These five situations were derived from a series of small group discussions with software preservation professionals, who deliberated together facilitated by fair use experts (yr humble narrator, plus [Krista Cox](http://www.arl.org/about/staff/3091-krista-cox) of ARL, [Peter Jaszi](https://www.wcl.american.edu/community/faculty/profile/jaszi/bio) of American University Washington College of Law, and [Patricia Aufderheide](https://www.american.edu/soc/faculty/paufder.cfm) of American University). That consensus was then reviewed by a team of independent legal experts to ensure it was within a reasonable interpretation of fair use. The resulting Code can provide valuable guidance to fair use reasoning. Go [get it](http://www.arl.org/component/content/article/6/4630), read it, share it, and let it open doors for your preservation practice! 

Now, to back up a bit:

### Why preserve software?

We embarked on this project because software preservation is going to be a crucial part of cultural preservation for the foreseeable future. It seems like a bold statement, but I think it’s fair for two reasons. First, our culture is increasingly digital: images, texts, music, design, art, business archives, and personal "papers," all are likely to be stored in digital 1s and 0s that can't be understood directly by a human reader. We need a computer to translate digital files into a form we can understand, and that computer in turn needs the right software. And while some tools exist to extract text and other information from old files, to [render a digital file faithfully](http://openpreservation.org/blog/2012/02/02/rendering-matters-report/) will often require *original* software. 

Second, software is itself worthy of study. Historians of science, anthropologists, computer scientists, literary scholars, and an ever-growing list of disciplines have found studying software a valuable part of their research. Libraries and archives support this research by building and preserving collections of software.

So far so good, but..

### A specter has haunted software preservation

And that specter is copyright. It rears its head over and over, in [articles](https://mellon.org/media/filer_public/0c/3e/0c3eee7d-4166-4ba6-a767-6b42e6a1c2a7/rosenthal-emulation-2015.pdf) and [reports](http://www.digitalpreservation.gov/partners/pvw.html) on software and digital preservation. Experts and roundtables and working groups have developed wonderful resources and made compelling theoretical, social, and technical interventions, but again and again they include a caveat that the copyright implications of any given course of preservation action remain unclear. Our [first phase report](http://thetaper.library.virginia.edu/fair%20use/software/best%20practices/preservation/2018/02/09/what-s-eating-software.html), based on interviews with 40 practitioners, confirmed that the concerns discussed in the literature are widely shared in the profession.

### Gathering Momentum

This is a really exciting time to be  involved in software preservation. First, the technology has never been more powerful. [Emulation](https://en.wikipedia.org/wiki/Emulator), which makes it possible to run legacy software on contemporary hardware, is increasingly sophisticated, and [Emulation-as-a-Service](http://www.softwarepreservationnetwork.org/eaasi/) can make emulation widely distributed and much easier to use. This technology dramatically lowers barriers to research, teaching, and learning with and about old files and old software.

Second, and more importantly, the community of software preservation professionals is [working together more deliberately](http://www.softwarepreservationnetwork.org/fcop/) to leverage unevenly distributed resources and expertise, to share tools, best practices, data, and lessons learned. As members of the community speak more and more publicly about the work they do, and contemplate working together on more ambitious projects, it becomes increasingly important that they understand the legal rules that affect their practice. 

### Enter the Code

That's why I'm so excited about the Code we're publishing today. Based on a series of discussions with librarians, archivists, curators, and others working on software preservation, the Code describes five situations where fair use applies to important software preservation activities:

1. Accessioning, stabilizing, evaluating, and describing digital objects—including creating multiple disk images from original media, documenting original packaging and other materials associated with software, and running software in order to describe it.

2. Documenting software in operation, and making that documentation available, e.g., using screen captures and video.  

3. Providing controlled access to software for use in research, teaching, and learning.  

4. Providing broader networked access to software maintained and shared across multiple collections or institutions.  

5. Preserving files expressed in source code and other pre-compiled human-readable formats.

It also includes substantial context on the process that generated the code, its scope, an epilogue on the future of software preservation, and two appendices that address licensing and DRM, issues related to fair use but with their own important impacts on software preservation.

For more than a decade, [fair use best practices](http://cmsimpact.org/codes-of-best-practices/) have been helping practice communities stake out territory where they need their fair use rights in order to do work at the core of their mission. Peter Jaszi and Pat Aufderheide developed the first code of best practices in collaboration with the [documentary filmmaker](http://cmsimpact.org/code/documentary-filmmakers-statement-of-best-practices-in-fair-use/) community, who found they were systematically shying away from certain subjects and approaches out of copyright fear. Jaszi and Aufderheide then facilitated discussions among the filmmakers to develop a consensus around fair use that would give them solutions to recurring problems, and the courage and solidarity to move forward. The results are documented in their [excellent book](https://www.press.uchicago.edu/ucp/books/book/chicago/R/bo28242133.html), but suffice to say: the floodgates opened.

I don't know if today's release of the Best Practices in Fair Use for Software Preservation will have an effect that swift or dramatic. But I am excited to see what happens next.

