---
layout: post
published: true
comments: true
date: '2018-08-09 11:37 -0400'
title: What do “Predatory Publishers” signify?
---


In a [recent blog post](https://scholarlykitchen.sspnet.org/2018/08/07/denialism-rocks-just-got-lot-harder-pretend-predatory-publishing-doesnt-matter/), Rick Anderson touts a series of new studies on publishers who (mostly) lie about their value, including fictional editorial boards, false metrics, hasty or non-existent peer review processes, and more. People have a lot of opinions about these publishers, and there’s been a fair amount of scholarly writing about them, with much of the interest focused on various ways of figuring out if they are a “real problem” for the academy. Anderson says we now have more proof that “predatory publishers” (PP for short) are a real problem, and notes in a comment that, coincidentally, he’s organizing a “summit group of schol-comm stakeholders” to devise solutions.

As someone who works on a college campus and whose neighbors and friends are academics, I can tell you that solicitations from junk publishers are a nuisance in every researcher’s inbox. But how much deeper does this alleged problem go? Citing a new round of investigative journalism, Anderson says it’s no longer possible to be a “denialist” about whether “predatory publishers” are “significant.” Indeed, Anderson concludes, paraphrasing a Nobel laureate quoted in one of the studies, “the credibility of science is at stake.” My goodness. 

Provoked primarily by Anderson’s framing of the issue in terms of whether and how the “OA movement” can “deny” the significance of PPs, and thereby avoid being “tarnished” by them, I left several comments on the page, which you can go read in that context. But I wanted to also capture them here, because they express pretty clearly my own view of what these “predatory publishers” really signify. 

In a nutshell, I think they are actually symptoms of the deepest dysfunction in academic publishing: creating and outsourcing a prestige economy to third-party vendors by using placement in vendor-managed journals as a proxy for quality, even making them a credential required for tenure and promotion. That dysfunction has led to predation for decades—ask any librarian, or anyone who’s suffered through the many indignities of trying to get a prestigious placement. PPs are just the latest bad permutation of an already bad model.

I made this point in my first comment:

[T]he better view of “predatory” publishers is that they are an indictment of *traditional* publishing models more than of the “OA movement.” By placing profits *even more* highly above the interests of the academy, and distorting the academic record *even more* perversely in the process, predatory publishers are just taking the excesses of prestige publishing and dialing them up to 11. The only thing these journals share with the OA movement is a willingness to publish on the open web; their fundamental ethos of profiting from a publish-or-perish environment by providing artificially-constructed totems of success, and placing profits over the actual needs of academics and the public in the process, make them much more akin to Elsevier than to PLOS. This view of predatory publishers as parody of traditional ones is articulated at length (though in somewhat obscure terminology, at times) in this [article](https://www.triple-c.at/index.php/tripleC/article/view/870).

The appropriate response in the long term is not to retrench and double down on the dysfunctional model of outsourcing academic prestige to for-profit vendors that PPs are parodying. It’s to find a way out of that model entirely.

-------------

*Anderson responded that he didn’t believe these publishers were necessarily an indictment of open access, which prompted my second comment:*

We may have discovered a useful, unmapped category in your breakdown of the various "denialisms," and perhaps you, too, are a denialist! You're right, I pivoted too quickly from your claim that PPs "tarnish" OA to the question of whether PPs "indict" OA (or perhaps they indict something else). It's possible to be unfairly tarnished, in which case there is no indictment. If you're not ready to say that PPs are an "indictment" of OA, then maybe you agree with me (or we may someday agree) that whatever tarnish Beall et al. have been able to apply to OA using PPs is unwarranted. This belief motivates my overall attitude toward PPs, which is that to the extent they are a problem, they are a problem that points to much bigger issues than OA and the APC model.

I think we have to trace the root of the evil of PPs more deeply in order to figure out what to make of them. I don't love the APC model, and I affirmatively loathe it when it's wielded by a for-profit publisher, whether it's OMICS or Elsevier. I loathe it because it allows these for-profit entities to literally monetize the credibility and prestige granted (gratis!) by scholars and the academy, a function of the hard work of their authors and reviewers, not of the publisher itself. Contrary to everything OA was supposed to do, APCs simply replicate the dysfunction of traditional publishing but in a context where the buyer is more desperate and less sophisticated. [Or perhaps, as Cameron Neylon [explains](https://cameronneylon.net/blog/researcher-as-victim-researcher-as-predator/), more sophisticated at playing a broken game.] APCs were supposed to decouple pay from prestige, but PPs show how they've done the opposite: they make it possible to pay for prestige quite directly.

But the moral risk you identify—that a publisher who profits by publishing more volume has an incentive to lower quality—is not unique to the APC model. I'm sure you've read the wonderful [Guardian Longread](https://www.theguardian.com/science/2017/jun/27/profitable-business-scientific-publishing-bad-for-science) about the history of academic publishing in the UK, which heavily features the aggressive campaign by commercial publishers there to proliferate journal titles as a way of demanding ever-more money from subscribers. Like cable bundles, journal bundles are stuffed with kruft, and scholars collude in this because (just like those who publish in PPs) they need the credential.

The deeper problem that PPs indicate, and that fuels their business, is that the academy has outsourced credentialing to for-profit third-parties. People who publish with PPs aren't buying open access—they could get that by posting their work in a pre-print repository for free. They are buying (or they think they're buying, if they're not in on the con) credentials—an entry on a CV, an alleged impact factor, presence in an aggregator, etc. The combination of publish-or-perish pressures and turning over the publish half to for-profit vendors is what creates PPs. The APC model makes it easier for PPs to run their grift, but they would have nothing to sell to desperate authors if we didn't set up academic publishing in a way that systematically vests third parties with valuable prestige-granting power. That's why I think PPs are an indictment of traditional academic publishing writ-large, not just OA or APC-funding models.

So, I hope your [summit] will consider decoupling prestige from publication in for-profit venues as a major (THE major) response that PPs should prompt. The way to resolve the conflict between quality and profiting on volume is to do away with the profiting part.

-------------

*Anderson then replied that “to pretend that the two have nothing to do with each other is silly.” Fair enough, but I wasn’t doing that, or advocating it, nor is it necessary to prove my point. Anderson also picked up on my use of “for-profit” and asked whether I also object to non-profit third-parties, like scholarly societies, managing the prestige economy. I replied:*



Thanks, Rick. I was replying to your original framing: that supporters of OA have two responses available to them if they want to avoid being ‘tarnished’ by predatory publishing (PP), namely to deny PP is a problem or to somehow take responsibility for the problem and take steps to solve it. There is a third option: to acknowledge there may be a problem, but to avoid tarnishment by disassociating PPs from OA, and associating them instead with all models that monetize access to academic prestige. I don’t have to show that PP has “nothing to do with OA.” I just have to show that the demand for PPs (and hence their reason to exist) comes from the broken academic prestige economy, not from the OA movement. Now everyone can take their pitchforks and head to their local P&T committee, and leave me alone.

The evidence you cite from these new journalistic investigations does nothing new in terms of tying PP to OA. It only suggests (but does not yet prove, IMO, based on what I read here, but I confess I haven’t read the studies themselves) that PP is a problem, not that OA is the cause. Are German and Indian researchers using these venues because they support open access, or because they need to get tenure/promotion? Nothing in your summary indicates which it is, but I have a guess.

To my mind, if legit OA is morally exculpated (as we agree it should be), then the problem is no longer a problem for the OA movement. It’s a problem for the academy writ large, and I would argue that the nature of the problem, and its solution, is best understood by looking at how we outsource credentialing functions to entities with conflicting interests vis-a-vis the academy and the scholarly record.

But owning the problem, so to speak, may not be bad for OA supporters from a strategic point of view, because we have already seen knee-jerk editorials (in “prestigious” publications! by “elite” researchers!) saying that everything was fine before these dirty scammers came along, so we should double down on the old model—make publishing great again! If OA supporters are involved in developing responses to PP, then maybe there is a chance you will see its root causes and propose solutions that move us closer to a more just system.

To your specific question about the role of profit, I would put it this way: the profit motive is what creates the conflict. Can a scholarly society (that stands to profit in the ordinary sense by monetizing access to its prestigious journal(s), either through subscriptions or APCs, using that money to subsidize its other functions, perhaps) manage that conflict better than a private company? Probably. But it would be better if the custodians of the scholarly record didn’t have to manage a conflict at all. The deep problem, IMO, is the way a publication venue can be vested with prestige that is given *gratis* by researchers, then monetized by charging either authors or readers for access. It’s a perverse windfall and a needless tax on beneficent activities (reading and writing). A civilized, rational society shouldn’t tolerate it.

-------------

And here is my last comment on the post, which I just added, after Anderson had continued to press various nuances about for-profit versus non-profit publishers:

[This argument is starting to go in circles, so…] The last thing I'll say is that I associate myself 100% with [this piece by Cameron Neylon](https://cameronneylon.net/blog/researcher-as-victim-researcher-as-predator/), which you link to in your piece as proof that even "smart" academics are "duped" by PPs. 

What you don't say is *why* Neylon argues that smart academics would willingly participate in a dumb/corrupt scheme. I was gratified to see that Neylon argues convincingly for the same basic proposition I've been trying to advance, namely that PPs are a symptom of a deeper problem: the familiar dysfunction in the "publish or perish" culture of academe. If others haven't read it, I strongly recommend it. Also, I'm going to collect my comments here for a post on my own blog, The Taper. Thanks for the conversation.

-------------

So that’s it! Now go read [the Neylon piece](https://cameronneylon.net/blog/researcher-as-victim-researcher-as-predator/). Here’s (to me) the key graf:

> I’ve no intent to excuse the behaviour of these publishers, but they are simply serving a demand. A demand created by researchers under immense pressure to demonstrate their productivity. Researchers who know how to play the game.

The solution is to change the game. Go read the whole thing!