---
layout: post
published: true
comments: true
date: '2018-07-11 12:18 -0400'
title: You Were Always On My Mind (But I Failed to Give You Credit)
publish: true
---
Yesterday Judge Claria Horn Boom (what a great name—right up there with Washington Nationals baseball player Spencer Kieboom) of the Eastern District of Kentucky issued a [nice opinion](https://github.com/uvalib/thetaper/raw/master/images/Philpot-v-LMComms.pdf)(PDF), IMO, finding infringement against a radio station that used a CC-BY [photo of Willie Nelson](https://commons.wikimedia.org/wiki/File:Willie_Nelson_at_Farm_Aid_2009.jpg) (I’m now terrified of being sued for misattributing a CC-BY photo (more on that later), so you’ll have to click through to see it) without the attribution or license information required by the [CC-BY terms](https://creativecommons.org/licenses/by/2.0/deed.en). The photographer, [Larry Philpot](http://www.soundstagephotography.com/), had posted the photo to Wikipedia Commons, and sent a cease-and-desist letter to the radio station when he found the photo, sans attribution or license info, used on the station’s website to promote an upcoming Nelson concert.

After addressing a series of procedural issues (both sides seem to be trying to get away with sharp strategic litigation behavior, and then seeking sanctions against each other for said behavior, and Judge Boom(!) disposes of these evenhandedly), the court finds that the station’s use did not comply with the terms of the license and therefore constituted infringement. 

> Defendant used an exact copy of a cropped portion of that work — posted on Wikipedia and available for use by all comers for the mere price of compliance with the terms of the Creative Commons license offered by Philpot — on its website.There is no evidence that Defendant did so with Plaintiff’s express permission or having obtained a license by accepting and observing the terms of the Creative Commons license offered by Philpot. This is enough to establish infringement under § 501(a)

The opinion on fair use is extremely hasty (literally one sentence, plus a string-cite), and addresses essentially just the first factor - the nature and purpose of the allegedly infringing use: 

> Defendant  cannot demonstrate that “fair use” protects it from liability for use of  the copyrighted Nelson photograph because the copy was not used for “criticism, comment, news reporting, teaching,. . . scholarship, or research” and the reproduction of the  work — the  copy of the  Nelson photograph on Defendant’s website — was not “transfo rmative” since it did  nothing more than “repackage or republish the original copyrighted work.”   

If the radio station wanted to appeal, they could argue the court did not follow the statutory requirement that courts “shall” consider each of the four statutory factors, as none of the others get express treatement. That said, the first factor has become extremely important to the overall determination of fair use after *Campbell*, and the remaining factors can often be rolled up by implication in the first factor analysis of whether the use is transformative. If the use is not transformative, then the amount (factor 3) can’t be justified in light of a transformative purpose, and the effect on the market is substitutional, all disfavoring fair use. (And the second factor is, [sadly](http://www.kasunic.com/Articles/CJLA%20Kasunic%20Final%202008.pdf)(PDF), a make weight these days, but is arguably considered in the transformative calculus, which weighs the nature of the new use together with the original use of the work.) So the outcome, though hasty, seems correct to me. 

I see a few takeaways here for CC license users, users of CC-licensed works, and photographers anxious about all this stuff: 

- CC-BY licenses mean what they say, and users who don’t comply with their conditions are infringing. If you’re a photographer and what you want is attribution (and nothing more), you can sue for infringement when you don’t get it. And you will win. Indeed, the license arguably helped bolster the photographer’s case insofar as the court seems moved by the idea that very little was required in order to satisfy the license. The Defendant’s failure to do so makes them look bad. By the same token, if you're a user and you want to use a CC-BY work, you had better comply with those terms, or else you may well be just as on-the-hook for infringement as if you'd grabbed a photo from Getty Images.

- If your goal is to make your work truly free for any reuse subject to no conditions, you should be using [CC-0](https://creativecommons.org/share-your-work/public-domain/cc0/). I suspect many, many users use CC-BY works without actually complying with the “BY” aspect, assuming (perhaps correctly in some cases) that authors who choose “CC licenses” (and perhaps especially those who choose the baseline license, CC-BY) are generally signaling that their stuff is free to reuse in some vague general sense. Cases like this should help disabuse people of this notion: some CC-BY users are sophisticated commercial actors like Philpot who distribute their works in different formats and channels and use CC as part of an overall strategy for earning a living, which is what copyright is supposed to let him do. More power to him! Knowing this may chill uses where the author used CC-BY but actually has no intention of enforcing the "BY" condition. This case shows that ignoring the nuances of what the license requires raises real risk, and rational users should take heed. For people who really care about attribution, that’s good news (per my point 1 above), but for people who don’t, you should recognize that you will chill some uses you’d actually like to encourage if you don’t go all the way to CC-0. My advice to people choosing licenses often includes the admonition that if they couldn't imagine actually suing someone for failing to attribute, then maybe what they want is CC-0 plus a prominent note asking for attribution. That lets you shame people in the court of public opinion if they fail to give you credit, which is what most people imagine they would do anyway, but doesn't chill users who may have legitimate reasons not to attribute, or who might be so conservative that they avoid any license that has any conditions whatsoever, lest they accidentally trip up and incur the full force of copyright's statutory damages.

- That weird case that [Petapixel highlighted](https://petapixel.com/2018/07/02/court-rules-copying-photos-found-on-internet-is-fair-use/) a couple of weeks ago where the court found transformative use because a photo was used in a film festival's informational website was, well, wrong, and no cause for alarm. Photographs that are taken for purposes of illustrative use on websites, to add visual interest, etc., are not “transformed” when they are used in exactly that way. Similarly, as the court says here, there is no “innocent infringer” defense to infringement of copyright; ignorance of the law is no excuse in copyright world. It may reduce your damages, but as the court says, that’s “a question for another day.” The sky is not falling, and if you hang in there that weird opinion will surely be reversed on appeal.
