---
layout: post
published: true
comments: true
date: '2018-07-10 10:47 -0400'
title: 'Judge Kavanaugh and Information Policy: A Small Observation'
---

As I’m sure you’ve heard by now, last night the President announced his nomination of Judge Brett Kavanaugh of the D.C. Circuit to the Supreme Court. There is no shortage of information about Judge Kavanaugh in the media, and there will surely be much more in the coming weeks, but I wanted to call your attention to one of his opinions that has already taken center-stage among folks interested in information policy: a remarkable [dissent](https://www.cadc.uscourts.gov/internet/opinions.nsf/06F8BFD079A89E13852581130053C3F8/$file/15-1063-1673357.pdf) from the DC Circuit’s opinion upholding the FCC’s net neutrality rules. (Well, not to get too wonky, but it was actually a dissent from a decision not to re-hear the case en banc, i.e., with all of the judges in the D.C. Circuit, after a smaller panel had upheld the FCC’s rule.)

The most striking thing about the opinion, to me, is that Judge Kavanaugh would have struck down the FCC’s net neutrality rules in part because they impede the ISPs’ supposed First Amendment rights as “editors” to select and control the content that travels over their networks. This is a secondary rationale in his dissent, thrown in almost as an afterthought, but it’s remarkable for a couple of reasons. 

First, it’s tendentious: sure, lawyers for the ISPs threw in this argument because it never hurts to try, but no one whose salary doesn’t depend on it actually believes that ISPs play an “editorial” role in selecting the content that travels over their wires. No ISP represents itself to consumers as “curating” the internet, and consumers would rebel if they did. This is why net neutrality is a popular policy. Judge Kavanaugh’s willingness to accept this bizarre, make-weight argument suggests a sympathy for the ISPs that exceeds the bounds of reason, IMO. 

Despite the popular conservative judicial self-image as a neutral umpire calling balls and strikes, his acceptance of a silly argument suggests Kavanaugh is either willing to disingenuously repeat bad arguments for the side he favors, or, perhaps worse, he genuinely believes those bad arguments when they come from parties he is predisposed to favor. A third explanation occurs to me as I write this, and it may be the most troubling of all: Kavanaugh may not understand the internet well enough to recognize how different an ISP is from a television broadcaster (the “editors” in the cases he cited as precedent). 

The second remarkable thing about Kavanaugh’s acceptance of the ISPs’ bizarre First Amendment argument is that it’s evidence that he is on-board for “[weaponizing the First Amendment](https://www.nytimes.com/2018/06/30/us/politics/first-amendment-conservatives-supreme-court.html)” as a tool against regulation of business. Justice Kagan coined the phrase in her dissent from the Court’s recent *[Janus](https://en.wikipedia.org/wiki/Janus_v._AFSCME)* opinion, which invoked the First Amendment in holding that public employee unions could not require non-members to pay fees to cover the costs of collective bargaining that benefits all employees. The most famous instance of this weaponization is in Justice Anthony Kennedy’s majority opinion in [Citizens United](https://en.wikipedia.org/wiki/Citizens_United_v._FEC), which massively deregulated campaign finance using a First Amendment rationale. 

One interesting question is how this solicitude for corporate First Amendment rights might play out in a fair use case. SCOTUS hasn’t heard a case about the scope of fair use since *[Campbell](https://en.wikipedia.org/wiki/Campbell_v._Acuff-Rose_Music,_Inc.)* in 1994, which set the table for two decades of what I consider to be really salutary judicial development of the doctrine in lower courts. A lot of that progress is grounded in the pivot that the *Campbell* court made away from commerce and toward creativity and expressive freedom as the primary focus of fair use decision-making. That has allowed new artforms and new technologies to develop and grow under the umbrella of “transformative use,” which typically overcomes arguments about lost revenue by pointing to the new value created by the secondary user. Since _Campbell_, the Court has twice said that fair use is one of the "First Amendment safety valves" in copyright that ensure rightsholders cannot behave as private censors. (These remarks were the cold comfort the Court gave to the public in two cases that otherwise struck massive blows against public access and reuse rights, [Eldred v. Ashcroft](https://en.wikipedia.org/wiki/Eldred_v._Ashcroft) and [Golan v. Holder](https://en.wikipedia.org/wiki/Golan_v._Holder).) 

What will a conservative majority do in a case where both sides are corporations (*Fox v. TVEyes*, e.g.), where one side characterizes copyrights as a valuable property interest (property good!), while the other characterizes copyrights as a government-granted monopoly and invokes the First Amendment as a protection for its right to pursue a new business model (government monopoly bad!)? Given the youth of the conservative side of the bench, we will almost certainly find out, sooner or later.