---
layout: post
published: true
comments: true
date: '2018-03-12 10:52 -0400'
title: Distinguishing Library and Archival Uses of TV News from TVEyes
---
*This blog post reprints an addendum I wrote to a short legal consultant's report on the legal issues around archiving television news. The full report and the addendum will be available soon from Vanderbilt's scholarly repository under a CC-BY license.*

The Second Circuit recently issued an opinion finding TVEyes’ for-profit service providing access to up to 10 minutes of recorded television in response to search queries was not a fair use.[^Full text of the opinion is available at [http://bit.ly/2oPfl9M](http://bit.ly/2oPfl9M). Only the provision of access to 10 minute segments of programming was challenged in court. The search function and the creation of the underlying database was not at issue.] The court’s opinion is not well-reasoned,[^Among its many flaws, the court misapplies the “transformative use” concept, which is central to the first factor determination and extremely influential on the remaining factors. Retroactively construing *Sony v. Universal* as a transformative use, the court emphasizes the convenience of TVEyes’ service and completely overlooks the new purposes it serves. The court confuses the second factor inquiry about factual versus fictional material with the bar on copyrightability of facts under Section 102(b), resulting in a cursory and erroneous treatment of that factor. It weighs the third factor without regard to the user’s (arguably transformative) purpose, leading to the hasty conclusion that essentially any amount of content beyond a “snippet” cannot be fair in this context. This is inconsistent with a raft of 2nd Circuit opinions, from *Bill Graham Archives* to *Swatch* to *HathiTrust*. Finally, the court’s treatment of the fourth factor, market effect, is almost a parody of the circularity problem that plagues this factor. If the court is right that any use that “is clearly of value” to the user must therefore be licensed, then all fair uses are doomed. For these reasons, the court’s opinion should be treated as an outlier. Nevertheless, if the holding stands, it will be important for libraries and archives to have a response to its analysis.] and TVEyes and its *amici* plan to seek review by the full Second Circuit, which may reverse or rewrite the opinion. Assuming, however, that the Court’s opinion stands, its impact on the non-profit activities of research institutions should be limited. Several things distinguish the activities of universities and research institutions from TVEyes.

First, libraries and archives are recognized in the law as having a special status with respect to archiving and sharing television news. Like the print-disabled in the *HathiTrust* case, whose favored status was evinced in Section 121 of the Copyright Act and in the Americans with Disabilities Act, libraries and archives can point to Section 108(f)(3) and (i) of the Copyright Act and the American Television and Radio Archives provisions at 2 USC 170 as evidence of congressional favor for their activities. This should lead a court to weigh the first fair use factor (the nature and purpose of the use) strongly in favor of non-profit libraries and archives. In *TVEyes*, by contrast, the company’s commercial purpose was weighed strongly against the “slightly transformative” character of the use, leaving TVEyes with only a “slight” victory on the first factor.

Second and relatedly, the court in *TVEyes* was heavily influenced by TVEyes’ commercial nature. The $500/month charge to its subscribers is referenced twice, and subscribers to TVEyes are described as “deep-pocketed” and “willing to pay well” for access to the service. These facts weigh heavily against TVEyes in the court’s analysis of market harm under the fourth factor, as the court infers a “plausibly exploitable market” from TVEyes’ lucrative business serving well-heeled clients. Libraries and archives, by contrast, serve researchers who do not pay at all for access to collections. That said, maintenance of collections and development of new services using those collections is not cost-free; as libraries and archives consider ways to cover or recover these costs, they should keep in mind the fourth factor “optics” of charging end-users and the inferences drawn by the court in *TVEyes*.

Third, TVEyes’ customer base is primarily interested in recent programming—indeed, the service purges its search system of content that is more than 32 days old. This arguably places TVEyes into more direct conflict with the market prerogatives of news programmers, who derive most of the value of their content in the days and weeks immediately following broadcast. While TVEyes’ users can certainly make a powerful argument that their uses are transformative and not substitutes for the market  served by news programmers,[^Indeed, their argument would be exactly the same one endorsed by the Second Circuit in the *Swatch* case—Fox’s message is “Here is the news,” while TVEyes’ message is, “Here’s what Fox News said was the news.” TVEyes’ users typically appreciate the difference.] their customers’ focus on monitoring the news of the day does shade more closely to the market typically served by content owners. Libraries and archives, by stark contrast, serve researchers interested in the history of the medium, typically further removed from present-day news.

Fourth, and relatedly, libraries’ and archives’ users are typically better able to describe and defend a transformative purpose than TVEyes and its users. The court characterized the use as merely “watching” Fox News content that is responsive to search queries. The court rejected TVEyes’ argument that enabling “research” is a transformative purpose, but it gave the argument very short shrift, citing *Texaco* for the proposition that all research cannot be treated as *per se* transformative. Of course, this does not preclude *some* research from being transformative, in the right context. Not all parody, or criticism, or news reporting is *per se* fair use, either. The key is to show how supporting research in a particular context differs from the original market purpose of the content, and is not a market substitute for it. For TVEyes as the court characterized it (primarily a way to find and watch recently-aired TV programs), the threat of substitution seemed high. For a deep archive of news content, the likely research uses will typically be more easily distinguished from “viewing recently-broadcast programming.”

Finally, creation of a deep, comprehensive archive is not a “traditional, likely to be developed” market for news programs. While many programmers make recent programs available online or through on-demand services, I am not aware of any who offer to the public a service that includes access to a comprehensive archive that goes back more than a few months. Indeed, the legal provisions mentioned above (Section 108 and 2 USC 170) are evidence that congress saw a need to empower libraries and archives to collect, preserve, and make available to researchers just such a comprehensive archive. This fact supports both a transformative use argument and a market failure argument. Non-substitution is one aspect of transformative use, and it’s a part of the doctrine that goes all the way back to *Folsom v. Marsh*, which warned against “merely superseding” uses. And courts have found fair use where technologies and services serve the constitutional purpose of copyright where markets systematically fail. The facts in *TVEyes* suggest that the market will systematically fail to support deep research and critique, in particular the fact that Fox News includes a contractual requirement that users of its licensed clip service not disparage the network. 

In sum, the Second Circuit’s *TVEyes* opinion is susceptible to a wide range of criticisms, but even if the opinion is taken at face value, libraries and archives can effectively distinguish their activities from the activities at issue in that case.