---
layout: post
published: true
comments: true
date: '2018-03-01 08:08 -0500'
title: >-
  How Is an App Like a Player Piano? And Does That Help the Fair Use Case for
  Software Preservation?
---
Happy Fair Use Week! Today I want to write a little about software. I’ve been working a lot with [software preservation folks](http://www.softwarepreservationnetwork.org/), lately, and trying to think about the kinds of [challenges they face due to copyright](http://www.arl.org/publications-resources/4468-the-copyright-permissions-culture-in-software-preservation-and-its-implications-for-the-cultural-record#.Wn3MT0UrK1t). I’m hopeful the community can find fair use solutions to at least some of those challenges, but in the meantime I’ve been struck by one unique aspect of software from a copyright perspective: in many ways it’s more like a player piano than a piano roll. Courts have taken this functional aspect of software into account in many contexts, and I’m hopeful that this will make it a good candidate for fair use arguments in the preservation context.
 
Why am I talking about player pianos? Well, there’s a great case, typically taught fairly early in most copyright courses, called [White-Smith v. Apollo](https://scholar.google.com/scholar_case?case=12949386652546347561&hl=en&as_sdt=6&as_vis=1&oi=scholarr), a 1908 case that deals with the copyright consequences of the then-new player piano technology. (New tech is often a  challenge to copyright, which is in many important ways a regime of technology regulation, focused on copying technologies. Every time the law seems to have tamed a given technological paradigm, a shift comes along and unsettles things!) The question for the court was whether the piano rolls that allowed a player piano to play songs were “copies” of protected musical works for purposes of copyright law. If they were, the music publishing companies’ permission would be needed before manufacturing new rolls that encoded songs they control. As the Supreme Court noted in its opinion, “the question involved in the use of such rolls is one of very considerable importance, involving large property interests, and closely touching the rights of composers and music publishers.” The publishers brought suit.

But the court rejected the publishers’ argument that “Music…is intended for the ear as writing is for the eye, and that it is the intention of the copyright act to prevent the multiplication of every means of reproducing the music of the composer to the ear.” Instead, the court sided with the piano roll companies—a “copy” of a musical work must be “a written or printed record of it in intelligible notation.” The copyright in a musical work is, the court says, just the right to reproduce musical notation in print. Since a piano roll looks like gibberish to the human eye, isn’t really “printed” at all, and only yields music when plugged into a compatible piano, it’s not a copy. The publishers were out of luck.

The court ends its opinion with a common judicial admonishment: if you don’t like our ruling, take it up with congress. 

> “It may be true that the use of these perforated rolls, in the absence of statutory protection, enables the manufacturers thereof to enjoy the use of musical compositions for which they pay no value. But such considerations properly address themselves to the legislative and not to the judicial branch of the Government.” 

The music publishers took this advice to heart, and the results of their legislative advocacy are found in Section 101 of the Copyright Act of 1976, which defines “copies” as 

> “material objects…in which a work is fixed *by any method now known or later developed*, and from which the work can be perceived, reproduced, or otherwise communicated, *either directly or with the aid of a machine or device.*” 

This seems intuitive to us, now—almost every “copy” we care about in the digital era requires “the aid of a machine” to be rendered perceptible. You can’t stare at a DVD as a way to watch the movie stored on it, nor can you hear the music stored on a hard drive by holding the drive up to your ear. In the analog era, a copy spoke directly to us, as long as we understood the language in which it was written (including musical notation); nowadays, the vast majority of copies are written in a language meant only for computers. 

So far, so good. A piano roll is now a “copy” of a musical work, and the music publisher/songwriter should have a say in making, distributing, etc. of such copies. A copy that depends on a machine to be perceptible is still a copy. But what about the machine-the piano or the DVD player? Should copyright also apply to it?

In copyright parlance, the machine that makes a work perceptible should typically be considered a “useful object,” excluded from copyright protection.[^17 USC § 102] If you would like a legal monopoly on something useful, we have another kind of intellectual property for you—patent law. Design a new piano, get a [patent](https://patents.google.com/patent/US3472110), license others to make and sell it, go on Shark Tank and sell shares to Mark Cuban, etc. Patents can be [expensive to get](http://www.ipwatchdog.com/2015/04/04/the-cost-of-obtaining-a-patent-in-the-us/id=56485/) (especially software-related ones), and their [term](https://en.wikipedia.org/wiki/Term_of_patent) is much shorter than copyright (more than 130 years shorter, in fact), reflecting the public policy favoring wide public access to useful discoveries.

But it’s clear from our interviews with software preservation professionals that from their perspective, lots of software is in the same relationship to digital files as the player piano is to piano rolls. They call this “software dependency”—files created in a certain software environment depend on that software to be perceived. CAD files, word processing documents, spreadsheets, all look like gibberish, or do not reveal their full contents, unless [rendered](http://archives.govt.nz/sites/default/files/Rendering_Matters.pdf)(PDF) with the appropriate software (and hardware, or emulator, etc. etc.). 

For archives and special collections containing born-digital documents (which of course more and more of our documents will be over the next several decades), access to our collections will increasingly require access to legacy software. Trying to read a manuscript, an email, a digital sketch, or financial data from the files alone makes about as much sense as holding a piano roll up to your ear. It turns out, software is very useful, even necessary, for preservation and long-term access to digital materials. This is one reason for the sense of urgency in the software preservation community around collective action and shared resources—no archive can hope to assemble and maintain every piece of software they might need to read the diverse file formats in their collections.

I’m hardly the first person to observe that software is useful, and that this makes copyright an awkward fit as a legal regime for regulating its use.[^See, e.g., Stephen Breyer, The Uneasy Case for Copyright: A Study of Copyright in Books, Photocopies, and Computer Programs, 84 HARV. L. REV. 281, 344–46 (1970)] Congress recognized this fact in Section 102(b) of the Copyright Act of 1976, which declares that copyright protection does not extend to any “idea, procedure, process, system, method of operation, concept, principle, or discovery” embodied in a protected work. Courts have been sensitive to this fact, as well. They have only granted copyright protection for aspects of software not dictated by function or interoperability,[^Comput. Assocs. Int’l, Inc. v. Altai, Inc., 982 F.2d 693, 703–
05 (2d Cir. 1992)] and they’ve applied fair use in cases where copying and reverse engineering of protected software was necessary for interoperability.[^Sony Computer Entm’t, Inc. v. Connectix Corp., 203 F.3d 596, 602–03 (9th Cir. 2000); Sega v. Accolade, 977 F.2d 1510, 1524–27 (9th Cir. 1992).] The policy arguments favoring narrow protection and broader availability of software under fair use in light of its useful character should apply with equal strength to uses of software for archival access and preservation. 