---
layout: post
published: true
comments: true
date: '2018-02-26 23:20 -0500'
title: >-
  Guest Blog: Student Remixer Tyler Garling on the Cultural Shift (Back) Toward
  Sharing
categories:
  - fair use week
  - fair use
  - remix
  - guest blog
---

*The following guest blog post was written by Tyler Garling, a student who recently took Steph Ceraso’s [Remix class](https://digitalwritingremix.wordpress.com/). Tyler will be talking about his audio remix project at our [Fair Use Week event](https://www.facebook.com/events/170977473523442/), The State of the Remix @ UVA, today, Feb. 27, from 9am-Noon at Harrison-Small Auditorium. Below Tyler talks about the ethos of remix—a vision of creativity that is open and collaborative. Fair use exists to enable exactly that kind of ethos, so this is a great way to continue our celebration of [Fair Use Week](https://fairuseweek.org) 2018.*

Since around 1995, technology has grown faster than we’ve been able to comprehend. You’re more likely to find a house with appliances connected to the Internet today than a landline phone. Technology has become an integral part of our everyday lives, a far cry from the days of skeptical critics proclaiming that the World Wide Web would never catch on. As tech has grown and evolved, so has our understanding and usage of it. This is especially true within the world of music as new technological developments have created a new culture of creation and collaboration. 

The poet Thomas Gray [mused](https://www.poetryfoundation.org/poems/44299/elegy-written-in-a-country-churchyard) that one of the bodies buried in a country churchyard could have been a renowned artist, but instead died “[a] youth to Fortune and to Fame unknown.” For him, joining a global community of artists was a dream inaccessible from his “country” home. For us, the generation that has come of age with access to the Internet and to the tools to create and share our work easily with the world, escaping isolation and obscurity (if not achieving “Fame and Fortune”) has become much easier. The tools and culture of remix are creating a society that thrives on openness, cooperation, and sharing that can allow anyone to make and engage with great works of art. 


Remix culture can be defined as a society that encourages the open collaboration and editing of existing works to create a new work of art. Our current culture is one based around the art of the remix, where both the artist and their audience can create together. Some of my favorite examples of remix at work are memes. Here are a few variations on a recent viral meme, the "distracted boyfriend":

![a7e.png]({{site.baseurl}}/images/a7e.png)

![3d7.jpg_large.jpg]({{site.baseurl}}/images/3d7.jpg_large.jpg)

![ff4.jpg]({{site.baseurl}}/images/ff4.jpg)

![distracted boyfriend meta meme]({{site.baseurl}}/images/478566-distracted-boyfriend.jpg)


Every month, we see a new meme gain traction on social media as thousands of people make their own iterations of it. Technology has given us the tools not only to easily access these memes, but also to create our own within minutes. We are constantly using each other for inspiration, “remixing” our ideas and creations to create something new and personal. 


Outside of our favorite online memes, we’re familiar with sampling techniques being used in hip-hop as a common example of remix, and I view artists appearing on each other’s songs as just another way we can take part in remixing. This is open collaboration at its finest; artists working together to make a new work that will be absorbed by a worldwide audience and, from there, who knows? Maybe a kid will sample the beat while producing music in their bedroom or maybe someone else will mash it up with a song from the 1970s. By embracing an ideology where art can be made by anyone for anyone and edited by anyone, society could enter its greatest cultural age. This shouldn’t be a niche, exclusive way of thinking, but rather a national attitude towards how we make and receive art.


This culture of collaboration and remix takes place against the backdrop of intellectual property law, and there can be friction between the two. In his documentary [RiP!: A Remix Manifesto](https://vimeo.com/8040182), filmmaker Brett Gaylor talks about how Brazil defied United States intellectual property laws to save lives, violating patents on medication for the HIV virus by producing much cheaper generic versions of the drug. The Brazilians, as Gaylor puts it, saw this as a “way of life.” So, one way to manage tensions between law and truly fundamental social or moral norms is to ignore the law. He goes on to delve into [Creative Commons](https://creativecommons.org/) licenses, which are basically a way for an artist to waive some of their rights under the law and say “you can sample this and make whatever you want!” A third option, at least in the US, is to take advantage of our fair use right, a flexible protection for the public which lets us use others’ content in new and creative ways without permission. 


We should work on adapting this kind of thinking to our own lives; in fact, I think we already have. Developments in the music world show that the old models of corporate control are eroding. Musicians today have several different ways to cut out the middleman and publish their works themselves. Bandcamp, for example, allows a musician to upload songs and set their own prices for them or even leave that option to the listener through a pay-what-you-want system. Most of the music on the site is available for free. No big corporate record label or streaming service is raking in the money; the artist is getting the credit they deserve. 


Open access is making similar changes possible for scholars. Imagine a world where researchers can publish their work just like the local band putting their music on Bandcamp. Anyone can read it and use it for their own research. No information locked behind paywalls; just a free and open internet where anyone in the world can obtain the information they are seeking. Tools like [Libra](http://libra.virginia.edu/) and the [Open Science Framework](http://osf.io/) make that possible. We were taught to share our toys when we were kids, so why did we give that up?


Perhaps it is just pure capitalist greed that prevents us from fully reaching this kind of open society. The big boys of media won’t hesitate to make a quick buck off an artist; your favorite musicians probably aren’t making anything in Spotify royalties. Obviously, artists deserve to make money from their work and platforms similar to Bandcamp allow that to happen. I hope for a future where sharing becomes the norm in American culture, where we offer classes to middle and high school students about remixing, production, and collaboration on anything from music to movies to writing. There’s a saying that everything is based on something else; even [Shakespeare](https://www.nytimes.com/2018/02/07/books/plagiarism-software-unveils-a-new-source-for-11-of-shakespeares-plays.html) rarely wrote something entirely original. People throw a lot shade towards this, but I think it shows the potential of letting art be open to anyone. With help from fair use and Creative Commons, artists have taken the first steps toward open, collaborative remix culture online, and I believe there are many more to come.
