---
layout: post
published: true
comments: true
date: '2018-02-26 09:23 -0500'
title: >-
  Fair Use Week 2018 Kickoff: Getting Ready for *The State of the Remix @ UVA*
  by Revisiting the Renaissance
categories:
  - fair use
  - fair use week
  - remix
---


[Fair Use Week](http://fairuseweek.org) is here! It’s the special week each year when we take a little time to celebrate the most important part of the Copyright Act (IMHO)—Section 107, the flexible, judge-made doctrine that permits free, unlicensed use of copyright-protected works for valuable cultural purposes. 

This year we’re celebrating Fair Use Week at UVA with an [event](https://www.facebook.com/events/170977473523442/) this Tuesday morning about remix, a cultural practice that couldn’t exist (or would certainly look quite different) without fair use. Our presenters are Professors [Steph Ceraso](http://stephceraso.com/intro/), [Siva Vaidhyanathan](https://mediastudies.virginia.edu/people/sv2r), [A.D. Carson](http://music.virginia.edu/people/profile/3581), and [Jack Hamilton](https://mediastudies.virginia.edu/people/jch6dx), along with students Tyler Garling and Sam Padgett, who will share the remixes they made in Prof. Ceraso’s class. Tomorrow we’ll have a guest blog post from Tyler Garling, a student in Steph Ceraso’s [Remix class](https://digitalwritingremix.wordpress.com/) and one of the presenters at our Remix event, describing his hope that a cultural shift is under way toward more open, collaborative cultural practices. 

Today, though, I want to share a fun bit of history that helped me appreciate how deeply ingrained is the need to borrow and reuse in order to create anything new.

## The Renaissance Reader
A few years back, I stumbled on this fascinating little blog post, “[How to Read Like a Renaissance Reader](http://www.adamghooks.net/2012/08/how-to-read-like-renaissance-reader.html).” The blogger, Adam G. Hooks, is an English professor at the University of Iowa who studies the history of the book, and teaches classes on Shakespeare, among other things. Of course, the bard is a well-known magpie, but until I read this piece I didn’t realize how deep or systematic the practice of reading-to-reuse had been in his time. I was struck by the similarities between the Renaissance reading methods Hooks describes and the contemporary phenomenon of remix and mashup culture. The piece could as easily have been called “How to read like a [crate-digger](https://www.urbandictionary.com/define.php?term=crate%20digging).”

Here’s the opening salvo of Hooks’ post:

> In the Renaissance, reading always demanded writing. Readers were trained to encounter a text with a pen in hand in order to mark up -- and hence actively engage with -- the text. Simple reading alone was not sufficient; the proper scholarly reader needed to actively use the text, taking the time and expending the effort to fully comprehend its meanings and implications. Reading was also aimed at some practical or intellectual goal: a used text was inevitably incorporated into one's own writing.

Later we learn about the scholarly practice of keeping “commonplace books” that they filled with the best quotes and factoids from what they’d read, all with an eye to using this material later to spice up their own work. (The UVA Library has [quite a few commonplace books](http://search.lib.virginia.edu/catalog?catalog_select=all&q=%22commonplace+book%22) in its special collections, by the way, if you’d like to actually flip through one in person.)

## The Digital Rhetor
Of course, reading critically with an eye to reuse is still at the heart of writing and rhetoric. That’s why Steph Ceraso saw a perfect opportunity to use remix as a lens for teaching digital writing and rhetoric. Here’s how she describes the genesis of her course:

> I created this course during UVA's Course Design Institute last January. As a faculty member in the Academic and Professional Writing Program, I was interested in designing a class that focused on the relationship between textual writing and digital composing practices. Remixing is literally a kind of re-vision—a way of re-seeing and re-making the world around us. Since revision is also a critical part of the writing process, drawing parallels between remixing and writing seemed natural to me. But revision is just one way that remixing and writing/rhetoric relate to one another. Bringing remixing practices into classes can also complicate notions of authorship, originality, and creativity, raise questions about the ethical and legal implications of creating things out of other people’s creations, and present students with powerful forms of argument and expression. To me, remixing is an exciting way to introduce students to many different aspects of digital writing and rhetoric that are also relevant to more traditional forms of textual writing. 

## Keeping the Creative Machine Moving
When we see the deep connection between the seemingly novel, digital practice of remix and the fundamental character of human creativity, we also see why fair use is such a crucial aspect of copyright law, especially as the exclusive rights in the law have metastasized to cover more and more behavior for a longer and longer period of time. Without the safety valve of fair use, creativity itself would be in grave danger. 

A [new infographic](http://www.arl.org/storage/images/fair-use-infographic-2018-accessible.pdf) from the Association of Research Libraries does a great job of showing the many ways that fair use promotes the creation of new knowledge. From search engines to screen-printed Campbell’s soup cans, fair use is the legal lubricant that keeps the creative gears from getting gummed up with too much copyright. 