---
layout: post
published: true
comments: true
date: '2018-02-09 11:18 -0500'
title: What's eating software?
categories:
  - fair use
  - software
  - best practices
  - preservation
---
Software may be [eating the world](https://www.wsj.com/articles/SB10001424053111903480904576512250915629460), but something even bigger is eating software: copyright. Specifically, the fear of copyright among the professionals tasked with keeping legacy software alive and useful for future generations. That’s what I and my co-authors conclude in a [report](http://www.arl.org/publications-resources/4468-the-copyright-permissions-culture-in-software-preservation-and-its-implications-for-the-cultural-record#.WnzCu5PwbNA) released today by the Association of Research Libraries, part of a [project](http://www.arl.org/focus-areas/copyright-ip/fair-use/code-of-best-practices-in-fair-use-for-software-preservation) funded by the Alfred P. Sloan Foundation.

In long-form interviews with more than 40 librarians, archivists, technologists, and scholars working with software, we learned that, like many professionals working with cultural material, they have had little access to specialized legal advice on copyright. Accordingly, they’ve made broadly conservative assumptions about their rights. Most importantly, they’ve assumed that permission is necessary before embarking on any but the most basic preservation activities. Fair use, the broad and flexible legal right to use copyrighted works without permission, has been virtually unexplored in this community. Instead, either new forms of licensing or a new specific legal exception have been seen as the best hope for relief from the uncertainty and frustration caused by perceived copyright risk. The difficulty of these two options has been a source of deep frustration.

The consequences for cultural memory institutions and the communities they serve are serious. Software languishes in dark archives; software-dependent files are at risk of becoming unreadable, or accessible only on-site at the few elite institutions with the wherewithal to maintain antique hardware or concoct new emulation environments in dedicated terminals. At a moment when software preservation professionals are [organizing themselves](http://www.softwarepreservationnetwork.org/) and coordinating their activities in unprecedented ways, and when [new technologies](http://eaas.uni-freiburg.de/) make broad access to obsolete systems and software titles much cheaper and easier than ever before, poor access to legal information and a lack of consensus about their own rights are perhaps the biggest obstacles to progress in software preservation.

I am very excited to document this state of the field, even though it speaks to some of the ways that its mission has suffered in the past, because the way forward is now quite clear. In the coming months, we will be bringing members of the community together to deliberate, for the first time, about the scope of their fair use rights. [Codes of best practices](http://cmsimpact.org/codes-of-best-practices/) in fair use have been transformative documents (pun intended, copyright nerds!) in other fields, and I’m optimistic about the possibilities we will discover together. Stay tuned as we continue this conversation!