---
layout: post
published: true
comments: true
date: '2017-11-17 16:09 -0500'
title: 'Publishers’ Dispute with ResearchGate: What Researchers Need to Know'
---
Academic publishers have long had an [uneasy relationship](https://svpow.com/2013/12/06/elsevier-is-taking-down-papers-from-academia-edu/) with academic social networks (ASNs) like Academia.edu and ResearchGate, which facilitate sharing of journal articles. STM, the association of STEM publishers, developed its own [narrow definition](http://www.stm-assoc.org/stm-consultations/scn-consultation-2015/) of permissible academic sharing as a way to constrain these sites. Then a group of STEM publishers (ACS, Elsevier, Wiley, Brill) [signaled its displeasure](http://www.responsiblesharing.org/coalition-statement/) with ResearchGate by demanding it sign on to the STM principles and develop technical measures to enforce them on its site. When ResearchGate refused, publishers in the group sent takedown notices for articles taken from journals they publish. Most recently, two publishers (ACS and Elsevier) [filed a lawsuit](http://www.sciencemag.org/news/2017/10/publishers-take-researchgate-court-alleging-massive-copyright-infringement) against the site in Germany, where ResearchGate is based, alleging widespread copyright infringement. 

Researchers have found themselves, or at least their papers, caught in the crossfire. Why is research disappearing from these websites, should researchers be worried, and what can they do to take control of their research? These are big questions, and I’d like to take this opportunity to explain several important aspects of the current publishing ecosystem while we’re at it. But first, in case you’re in a hurry: 

## TL;DR: You probably can’t share your research as widely as you thought, and this is a problem endemic to academic publishing.
The rest of this post will go a bit deeper into the context and policy issues surrounding the ResearchGate controversy, but if you want the TL;DR version, here are the bullet points:

- Papers are disappearing from ResearchGate because STEM journal publishers are objecting to their presence on the platform and demanding their removal.
- They can do this because, in a typical journal publishing agreement, **the author transfers her copyright to the publisher**. That gives the publisher legal control over how an article is copied, distributed, and otherwise shared. 
- A lot depends on the details of the author agreement, but researchers are often **forbidden from sharing even their own research** online outside of narrowly-defined circumstances. The publishers believe that a lot of the literature circulating on ResearchGate is inconsistent with these agreements, and they’re probably right.
- STEM publishing is a **billion dollar business** whose incumbents depend on limiting access to research to generate profit margins bigger than Apple’s. ResearchGate and Academia.edu are venture-backed, for-profit businesses that are also seeking to profit from the research enterprise. Research itself is caught in the crossfire.
- For obvious political reasons, publishers don’t want to bring legal action directly against individual researchers, even though technically many authors appear to be infringing publishers’ copyrights by sharing their own work. The **main harm to researchers in this clash is that their own papers and the papers of their colleagues will be less accessible**, locked behind publisher paywalls.
- There are two things individual researchers can do in the near term to share your work without getting caught in this kind of crossfire: 


1. **read your authors agreements** and relevant publisher policies carefully so you can post the *right version*, in the *right place*, at the *right time*; and 
2. **publish in research-friendly journals**, i.e., ones that embrace open access to research.

Collectively, scholars should consider **passing Harvard-style open access policies** to reserve to themselves the sharing rights that they believe they should have, regardless of publisher agreements.

But let’s start at the beginning: why are these companies fighting over your research?

## Your Research (Collectively) Is Making Private Companies Billions of Dollars (Mostly from University Budgets)

It may surprise the average researcher to learn this, since we typically donate our labor to journals for free, but academic publishing is one of the [most profitable obsolete technologies](https://sasconfidential.com/2015/11/06/obsolete/) in the global economy, and it is [dominated by a handful](https://qz.com/441305/five-for-profit-companies-control-more-than-50-of-academic-publishing/) of European [oligopolies](http://journals.plos.org/plosone/article?id=10.1371/journal.pone.0127502). The [profit margins](https://svpow.com/2012/01/13/the-obscene-profits-of-commercial-scholarly-publishers/) of the biggest publishers exceed those of Apple, and their [CEOs take home millions](https://www.theguardian.com/business/2013/mar/12/reed-elsevier-chief-engstrom-pay) in compensation. *The Guardian* recentely ran a [blockbuster longread](https://www.theguardian.com/science/2017/jun/27/profitable-business-scientific-publishing-bad-for-science) about the history of the academic publishing industry that suggests its origins are as bound up in blockbuster profit-seeking as its wildly successful present.

![Chart entitled "Drugs, Cars, iPads, and… Journals" shows relative profit margins of leaders in various industries: Pharmaceuticals (Pfizer): 42% RELX (Elsevier): 39% Apple: 37% Taylor & Francis: 36% Springer: 35% Banking (Industrial & Commercial Bank of China): 29% Wiley: 28% Automotive (Hyundai): 10%]({{site.baseurl}}/images/Screen Shot 2017-11-17 at 3.43.21 PM.png)


Those profits are built on copyrights, specifically the copyrights of researchers, acquired for free, aggregated together into journal packages, and sold back to the institutions where researchers work. The cost of these packages has [exploded](https://en.wikipedia.org/wiki/Serials_crisis) over the past several decades, far outpacing inflation. This despite the internet and digital publishing tools dramatically reducing the cost of publishing. 

The local picture in Virginia is typical. Journal subscriptions eat 83% of our collections budget at UVA, and the top 5 publishers alone take 43% of our budget. Virginia research libraries will spend $45 million collectively over the next 5 years just for access to Elsevier’s ScienceDirect journal package. By the end of that period, the cost of the package will have ballooned 20%, a rate that we achieved only by negotiating aggressively against an initial proposal that would have grown even faster. 

![Image titled "Big Deals at UVA" shows a pie chart with 4 Big Deals (Elsevier, Wiley, Springer, and Sage) taking 43% of the budget, "Other Journals" taking 40%, and "Books, etc." taking 17%. Text explains that Big Deals have grown from 21% of collections budget in 2009 to 40% in 2017.]({{site.baseurl}}/images/Screen Shot 2017-11-17 at 3.42.27 PM.png)


Under UVA’s [“RCM” financial model](http://www.virginia.edu/resourcingthemission/documents/NIFM_RCM_Basics_2011.pdf), that cost is bourne initially by the Library, but is ultimately charged back to each school or department in rough proportion to its usage. The UVA Medical Center, for example, will pay a little over $3 million for Web of Science over the term of our current 5-year deal with Elsevier.

I tell you this in part because it’s an unsustainable, dysfunctional situation that more researchers need to understand. But, in the context of this particular controversy, it gives you a sense of the stakes for big publishers in maintaining control over access to the research they aggregate and sell. For some researchers, ResearchGate has become an important part of their information diet. If accessing papers through ResearchGate reduces researcher dependence on the journal packages sold by the big publishers, institutions might be less inclined to pay astronomical, skyrocketing prices for journal bundles. If the journal publishers are like the music industry in its [price-fixing](https://usatoday30.usatoday.com/life/music/news/2002-09-30-cd-settlement_x.htm), [consumer-abusing](http://www.slate.com/articles/podcasts/hit_parade/2017/09/the_story_of_how_the_recording_industry_made_you_pay_a_premium_for_90s_hit.html) heyday, then ResearchGate and Academia.edu may be their Napster.

And like Napster, ResearchGate itself is hardly an ideal character. Backed by [millions in venture capital](https://www.forbes.com/sites/tomiogeron/2013/06/04/bill-gates-vcs-invest-35m-in-researchgate-to-open-source-science/#7a69d943c524), ResearchGate will have to [find ways to monetize](http://www.chronicle.com/article/As-Academiaedu-Grows-Some/234414/?key=oxcAb8_9Zk_OXF4jFiruCpH-_gN5xMpKEgGgI8PwdIs0NzlPeHFNMXB2czVHTFBGY2dFSGM3Z3ZyMnJfTEUzZG9ZR2pBZXFSRUNF) your time, attention, and research. That mission may or may not be consistent with academic values, but it will necessarily trump those values when the two come into conflict. As with Facebook and Twitter, you and your research are not the customer of these social networks; you are the product.

(In a piece of breaking news, a group of professors has launched a non-profit ASN, an alternative to ResearchGate and Academia.edu, called Scholarly Hub. I don't know enough about it to have an opinion, but you can learn more [here](https://www.timeshighereducation.com/news/scholars-form-non-profit-rival-to-researchgate).)

So, you may not have realized it, but sharing your research with colleagues endangers the profits of a very wealthy industry. (And sharing them on a for-profit network raises new risks from a new kind of industry.) That’s why it’s worthwhile for publishers to risk upsetting researchers who are, ultimately, the geese laying golden eggs *gratis* into their journals. Extracting massive profits from universities requires controlling access to research, which means sharing research is dangerous, even when it’s the researcher herself who’s sharing.

## Should researchers be worried? 
In a typical publishing agreement, researchers transfer their copyrights to publishers and retain only a few, narrow rights to reuse their work. These agreements often bar sharing the final, published version of an article under any but the most constrained circumstances. The publishers bringing suit believe that sharing articles on ResearchGate, in particular, is inconsistent with their publishing agreements. If that’s true, researchers themselves are infringing copyright by posting their own articles to sites like ResearchGate. Are researchers going to be the [Jammie Thomases](https://www.wired.com/2013/03/scotus-jammie-thomas-rasset/) to STM’s RIAA? Should researchers worry?

In a word (or two): Not yet. The publishers engaging with ResearchGate have taken pains to signal to authors that they are not the targets of this campaign. ACS, for example, sent [emails to authors](http://images.acspubs.org/Web/AmericanChemicalSociety/%7B034cbb38-1d78-48f4-b891-1b39ade37b89%7D_ACS_Publications_Letter_to_Authors.pdf) and  separately to librarians describing its efforts in terms of copyright enforcement against ResearchGate, not authors. In the Library email, an ACS representative writes:

> I would like to stress that such take down notices are directed at ResearchGate—not at authors and researchers themselves—and such notices are not intended to penalize researchers or impede the scholarly sharing of published research when undertaken in accordance with copyright.

Publishers like ACS say they are not hostile to sharing, but they urge authors to stay within the confines of the journals’ copyright agreements. They say “[i]n accordance with copyright,” but that’s deeply misleading. It suggests limitations on sharing are a result of the law when in reality, these limits are in the publishers’ own agreements and policies. They could change these immediately if they chose. 

This disingenuousness about sharing is [arguably to blame](https://scholarlykitchen.sspnet.org/2017/10/31/guest-post-academics-copyright-ownership-ignorant-confused-misled/?utm_source=feedburner&utm_medium=email&utm_campaign=Feed%3A+ScholarlyKitchen+%28The+Scholarly+Kitchen%29) for the widespread belief among researchers that there is nothing wrong with posting final versions of articles on sites like ResearchGate.

What their actions against ResearchGate make clear is that these publishers are very much opposed to the kinds of sharing that comes most naturally to researchers, and is most valuable to them and their colleagues. Luckily, unlike the victims of the RIAA litigation, researchers are themselves the ultimate source of value in publishers’ products, so the publishers are not, yet, willing to enforce contract terms against researchers directly. But as [John Fogerty](http://mentalfloss.com/article/27501/time-john-fogerty-was-sued-ripping-john-fogerty) can tell you, corporations who monetize copyrights do sometimes decide they value the work more than its author.

## What can researchers do now to share their work sustainably?
The legal risk associated with sharing our work is something that most researchers at UVA have not had to think about much until recently. Colleagues at well-funded institutions likely have access to expensive journal packages, and informal, personal sharing through email or social network hacks like #icanhazpdf has been permitted, or at least tolerated, by publishers for years. But disruptive, mass-scale efforts like ResearchGate expose the limitations of publisher tolerance. 

Social networks are just one kind of sharing or aggregation that scholars favor but some publishers fear. Other sharing contexts that might raise publisher hackles include [researchers’ own websites](https://library.harvard.edu/03142014-1552/elsevier-takedown-notices-qa-peter-suber) and subject matter repositories like [SSRN](http://blogs.wayne.edu/scholarscoop/2016/07/19/ssrn-begins-removing-papers-over-copyright-concerns/). Indeed, according to the STM’s “voluntary principles,” scholarly sharing of articles published in traditional journals should be limited to colleagues working together on a specific research project.  

If you want to share your research widely on web platforms like ResearchGate, in a way that is *sustainable*, i.e., that won’t be vulnerable to legal or financial attacks from third parties, you need to *understand your rights* and *publish in sustainable, scholar-friendly outlets.* If you want to take collective action to protect your rights, consider *organizing your colleagues around an open access policy.*

### Understand your rights as an author.
As the author of a work of scholarship, you own copyright in that work, at least at first. Journal publishers need your permission to publish your work, and they obtain that permission using a contract. Historically, publishers have required authors to transfer all of their copyrights as part of a publishing agreement, leaving the author with little more right to copy and share her work than any member of the general public. So, authors start out with total legal control of their work, but they routinely transfer that control to publishers. New publishing models have emerged that change that dynamic (more on those models below), but if you publish with traditional publishers like ACS or Elsevier, your contract will strongly favor the publisher, leaving you a narrow set of re-use rights.

Note that this total transfer of rights can take place even if the journal trumpets that you “retain copyright.” This is because copyright law allows authors to grant an “exclusive license” to a third party while retaining the copyright. That exclusive license can be enforced against the author as well as any other person, leaving the author with a copyright in name only. 

If you choose to publish in a journal that uses this model, but you still want to share your work, you will have to look to the journal’s publishing agreement and related policies. (Many publishers are using separate policies rather than contractual provisions to set out authors’ rights. These are useful if you’ve lost your contract, but they also make it possible for the publisher to change policies at any time, without warning to authors.) The language in these contractual provisions and policies will tell you what’s permissible (though you might need help deciphering them).

A great resource for learning more about these provisions is [SHERPA-RoMEO](http://www.sherpa.ac.uk/romeo/index.php), a database that tracks these rights for thousands of journals and publishers. The site provides an overview of the policy or provision and, crucially, includes a link to the agreement or policy so you can read the language yourself. What you’ll learn there is that each publisher, and even each individual journal, has its own policy about *which versions* can be shared in *which contexts,* with *what citation,* and *when.* Pay attention to each of these variables in order to comply with the agreement/policy. (If you think all this complexity is meant to frustrate your sharing, [you might be right](http://crln.acrl.org/index.php/crlnews/article/view/16699).)

#### Which version(s)
Publishers typically distinguish between three versions of a paper. Different names are given to these versions in different fields or contexts, but the basic definitions are the same:

- The version prepared by the author and submitted for peer review, often called a “pre-print”
- The version that has been modified in response to comments from reviewers, but has not yet been copyedited or typeset in its final format by the publisher, often called a “post-print”
- The final published version, with publisher’s typesetting and pagination, often called the “publisher’s version/PDF.” 

If you look at SHERPA-RoMEO, or at your agreement or policy, you should be able to puzzle out which version(s) you are allowed to share. Very very few traditional, closed access journals permit sharing the final version under more than the most limited circumstances (a single copy to a colleague in the same institution, or a limited number of copies using a special sharing link provided by the publisher, e.g.). Researchers mistakenly posting final versions to ResearchGate ([one study](https://www.researchgate.net/publication/313606361_Copyright_compliance_and_infringement_in_ResearchGate_full-text_journal_articles) found 52% of papers in a random sample were infringing because they were the wrong version) was likely the trigger for publishers’ actions against the platform. Note that this taxonomy has nothing to do with copyright law; it is a creature of publisher contracts and custom, and can be modified or dispensed with by changing the language of the contract. 

#### Which contexts
Publishing agreements and policies typically distinguish between different sharing venues. A school or departmental homepage, or an institutional repository like [Libra](http://libra.virginia.edu), will be treated differently (and typically more favorably) than a competing for-profit platform like ResearchGate. In some fields, pre-print servers like ArXiv are so well-established that no publisher bothers excluding them, and some may expressly permit them. Posting a pre-print, or even a post-print, to an institutional repository is increasingly permitted by publishers. In other fields, however, prior publication of any version of an article may preclude acceptance for publication in some journals. It is also worth noting that some funders (including major government agencies like the NIH, and major non-profits like the Gates Foundation) require that publications resulting from funded research be deposited in an open repository (sometimes a specific repository operated by the funder, like PubMed Central). Journals who won’t allow this are simply off-limits for researchers funded by such entities.

#### What citation
Publishers typically specify a citation or notice that they require authors to include in any pre- or post-print they share, acknowledging the journal where the final article was published and directing readers to that version. For example, *Science* requires authors to include this notice on published post-prints: “This is the author’s version of the work. It is posted here by permission of the AAAS for personal use, not for redistribution. The definitive version was published in [Science Journal Title] on [Volume number and date], DOI: [insert DOI number].” 

#### When
Even where publishers permit worldwide open access to final versions of research articles, many require an embargo of 6-12 months (or more). This strategy is designed to protect the billion dollar bundle business model; researchers demand access to the *latest* research, so libraries have to buy costly bundles, even if the literature will be freely available one year later.

So, if you understand which versions you can post, in which contexts, with what citation, and when, you can exercise what limited rights you may have under existing publishing agreements. But if you really want to have broad, sustainable sharing rights, you need to make informed choices about these issues at the very beginning of the publishing life cycle.

### Publish in sustainable, scholar-friendly journals
As the foregoing has hopefully helped to show, the standard terms of some academic publishers are just not designed with the values and interests of scholars front-and-center. Rather, the provisions that permit sharing and reuse of scholarship are limited concessions, narrowly drawn to avoid disrupting the billion dollar business models of a few massive publishing houses. Happily, advances in technology (especially the internet) and innovations in business models have made it possible to publish research in a rigorous, compelling way while still putting the interests of scholars and scholarship first. When you publish in scholar-friendly outlets who use open licenses by default, you can share your research far and wide, and others can reuse it, without fear of legal repercussions or sudden copyright-related disappearances like the ones cascading across ResearchGate right now.

The most important thing to look for as you seek out scholar-friendly publishers is the use of broad, open copyright licenses by default. Such licenses, like those in the [Creative Commons](http://creativecommons.org) suite, use the powers of copyright for good, granting a license to the public to ensure that people can share and reuse research with confidence. Once a work is published under an open license, anyone may use the work so long as they satisfy the broad terms of the license. Unlike the terms of publishing agreements, open licenses are broadly written and have only one or two simple conditions. Most licenses do require attribution, consistent with scholarly values. If you want your work to be [fully open access](http://journals.plos.org/plosbiology/article?id=10.1371/journal.pbio.1001210), look for journals that use the simplest licenses, like CC-BY.

Many researchers at UVA are already publishing in open access journals, and taking advantage of our open repository, [Libra Open](http://www.library.virginia.edu/libra/landing/), to share their work. Talk to one of the many friendly subject specialist librarians at UVA to learn more about the landscape of open publishing in your subject area. A quick survey of publications in the UVA School of Medicine in 2016 revealed faculty there had at least 140 publications in open access journals.

## Take collective action: adopt an open access policy!
Perhaps the most powerful action you can take to protect your right to share your work is to act collectively with other researchers in your school or department to pass a [Harvard-style open access policy](https://osc.hul.harvard.edu/policies/). These policies grant a “[prior license](http://scholarlycommons.law.northwestern.edu/njtip/vol10/iss7/1/)” to the University to host, preserve, and publish your work on the web, ensuring that it will be available to the public (including you!) to share far and wide, regardless of publisher policies. Open access policies are not magical—publishers may demand a waiver, for example, which would defeat the policy. But they can change the bargaining situation by setting the default to open. Tens of thousands of research papers have been made freely available online as a result of such policies. They are not a panacea, but they have been [shown to dramatically increase](http://openaccess.eprints.org/index.php?/archives/821-Richard-Poynder-Interview-How-Fast-Is-Open-Access-Growing.html) the number of articles that are freely available compared to schools without policies.

## Got questions?
I am planning to visit with at least one department to talk through this issue and its implications for our faculty. If you'd like to speak with me directly, or invite me to speak to a group on campus, don't hesitate to reach out! My contact info is [here](https://static.lib.virginia.edu/directory/staff/bcb4y.html).
