---
layout: post
published: true
comments: true
date: '2017-08-11 10:25 -0400'
title: We Launched a New Institutional Repository. Here's why.
---
*A guest post by [Ellen Catz Ramsey](http://static.lib.virginia.edu/directory/staff/ecr2c.html), UVA's Director of Scholarly Repository Services.*

We just launched a shiny new [open content repository](https://www.library.virginia.edu/libra/open/) here at UVA. It is the final part of a three-phase project to replace our original institutional repository which was a bit ahead of, and then extremely behind, its time.

So what? [Institutional repositories are dead](http://scitechsociety.blogspot.sg/2016/07/let-ir-rip.html), long live the [pre-print server](https://osf.io/preprints/), right?

Well, yes. In disciplines with a successful international-level repository where collaborators look for and share innovations, scholars need to have rights and access to share work with peers who are as likely to be across the globe as across the hall. Discipline-based repositories are succeeding here. 

And, no. As an option for authors whose disciplines are not congregating around an international discipline-based archive, or whose work doesn’t (yet) fit existing scholarly archives, every good research institution will always need the safe haven of a local repository.  [ My peers who think a lot about the future of repositories](https://www.cni.org/wp-content/uploads/2017/05/CNI-rethinking-irs-exec-rndtbl.report.S17.v1.pdf) concluded “IR systems can even serve as an early warning systems for identifying new classes and genres of digital scholarly outputs that will need stewardship.”

Brandon Butler’s posts have previously laid to rest [misperceptions about open access fees](http://thetaper.library.virginia.edu/2017/08/09/predatory-publishing-from-fake-academia-to-real-extortion-in-scholarly-publishing.html) being the only option for authors who want eliminate subscription paywalls and restrictive rights between their work and their audiences. He and David Hansen made the case, too, that “[academic authors write with the expectation that their works would be subject to broad fair use for educational purposes](http://thetaper.library.virginia.edu/2017/05/19/does-fair-use-affect-academic-authors-incentive-to-write-some-lessons-from-authors-of-works-from-the-gsu-course-reserves-case.html),” yet authors give away re-use rights they don’t know they already have. At UVA we subscribe to the definition of open that includes the ability to re-use. We also care about preserving the work of our scholars for the long term. Even the ones you [haven’t](https://doi.org/10.18130/V3PN1F) heard of. 

We keep our repository up to date in part to answer the “how do I get my stuff into the library” question for both access and preservation. Put it in the IR, poof, it’s in the library’s catalog, Google Scholar, and has a persistent link you can cite. Authors getting credit when claiming their work by [ORCID](https://www.library.virginia.edu/libra/orcid-at-uva/) is pretty cool, too. 

As a clearinghouse for the scholarly products of an institution, [Van de Velde](http://scitechsociety.blogspot.sg/2016/07/let-ir-rip.html) is right, IRs are not even close to the answer, especially at a place like UVA where an institutional mandate has a high hurdle in a decentralized structure. And though UVA and others are partnering in SHARE’s efforts on [The One Repository Feed to Rule Them All](http://www.share-research.org/about/about-share/), we still aren’t consistent in how we identify institutions (though [TritonShare](https://cos-labs.github.io/share-analytics/#/ucsd) is a hopeful open alternative to Symplectic and other closed aggregation systems). But [Lynch and colleagues](https://www.cni.org/wp-content/uploads/2017/05/CNI-rethinking-irs-exec-rndtbl.report.S17.v1.pdf) are also right that evolving IRs from a single platform to a “bundle of related services” (UVA currently has three separate “Libra-branded” services) is an extensible evolution of repository architecture for the near- and medium-term future.  Modern institutional repositories can and do efficiently and reliably add traditional and cutting edge scholarly work to the public lexicon, library collections, and preservation archives. 

Plus, modern IRs, including ours, come stock with a bunch of features broadly useful for stuff that doesn’t fit neatly into commercial or discipline-based options:

- -Open educational resources e.g. [https://doi.org/10.18130/V32T87](https://doi.org/10.18130/V32T87)
- -White papers and technical reports e.g. [https://doi.org/10.18130/V3675G](https://doi.org/10.18130/V3675G)
- -Grant compliance e.g. [https://doi.org/10.18130/V3DJ42](https://doi.org/10.18130/V3DJ42)
- -Institutional copies of important open works e.g. [https://doi.org/10.18130/V3BX7C](https://doi.org/10.18130/V3BX7C) 

We also got rid of the siloed search of items in a separate repository interface, since authors want their stuff “in the library.” What you give up in ability to customize a search of a single collection, you gain in seeing scholarship of all types in context in our catalog as well as mainstream search engines. No one searches for “open access” first, they just search for what is available on their topic. 

We added ORCID, better SEO, related links, and DOIs so that depositing an item into the IR can be a first step toward dissemination, instead of a last.

The bottom line is it is in (almost) everyone’s interest to make scholarship more open, accessible, and re-usable. Scholars and authors should do it with the tool that works best for their situation, priorities, and professional development. Institutional repositories like Libra are part of the solution, and will continue to be for the foreseeable future, as havens both for work that has made the transition to open, and for born open scholarship pushing existing boundaries.
