---
layout: post
published: true
comments: true
date: '2017-06-30 15:37 -0400'
title: Recent Supreme Court IP Cases Through a Library Lens
categories: ''
excerpt: ''
excerpt_separator: <!--more-->
---
The US Supreme Court wrapped up its most recent term last week, and it was a big one for intellectual property and access to information. Three opinions in particular strike me as having interesting, if indirect, implications for libraries and their users. The patent case *[Impressions Products v. Lexmark](https://www.supremecourt.gov/opinions/16pdf/15-1189_ebfj.pdf)* and the First Amendment case *[Packingham v. North Carolina](http://www.scotusblog.com/case-files/cases/packingham-v-north-carolina/)* bode well for core library interests, signaling broad solicitude for owners’ rights (in contrast to IP-holders’ rights) and the right to access the Internet, respectively. The trademark case *[Matal v. Tam](http://www.scotusblog.com/case-files/cases/lee-v-tam/)* is less encouraging, but only indirectly so; the court misunderstood a fundamental fact about intellectual property and so missed an opportunity to recognize the government’s discretion to shape IP policy in service of the public interest.

<!--more-->

## *Impressions Products* and Owners’ Rights

This is a case about printers and ink cartridges, which many manufacturers, like Lexmark, sell as the modern day equivalent of [razors and blades](https://en.wikipedia.org/wiki/Razor_and_blades_model). This is not the first time Lexmark has used intellectual property to lock out competitors and lock in users. Years ago Lexmark tried to [invoke copyright](https://en.wikipedia.org/wiki/Lexmark_International,_Inc._v._Static_Control_Components,_Inc.) (well, the Digital Millennium Copyright Act, a kind of quasi-copyright law) to block manufacture of third party cartridges that would work in Lexmark printers. When they lost in court, resellers were freed to hack and resell Lexmark ink cartridges. Or so they thought. 

![Image of recyclable ink cartridges, by Flickr user innovate360, CC-BY 2.0]({{site.baseurl}}/images/5656151295_da399c7ccf_o.jpg)
*"[HP ink cartridge recycling - Drucker Tintenpatronen Recycling](https://www.flickr.com/photos/innovate360/5656151295/in/photolist-9BPfHV-7P11bh-9BPbbH-8avY7t-7P125y-9BPkze-9BSfvh-9BPiHt-7NW1VM-9BPiWg-9BPmGB-9BPk9F-9BSghb-pFQUMH-9BSipY-7NW1Ex-9BSfcb-8cYUns-9BPkjn-64qmd3-9fLoqt-9BPjCg-9BPm2n-9BPjit-9BSim1-9BSaxW-9BPeG4-77hLqD-9i7dfB-Cmah-9hpiEW-9BSbku-6ZWh2t-9BPgWH-9BPc8n-paRSKr-9BS7n1-f7zmsY-9BPg1x-6xayAm-9BPfRB-9BPdut-3MePC3-9BPbAV-9BPhm2-9BSg87-m4DBC-9BPms6-98AUEu-6WxmjC)" by Flickr user innovate360, CC-BY 2.0*


Denied a copyright remedy to enforce its cartridge market strategy, the company turned to patent law. A patent grants patent-holders  the exclusive right to make, use, sell or offer for sale patented inventions and discoveries. Lexmark sued Impressions Products, Inc., a company that bought, reconditioned, refilled, and resold used Lexmark cartridges, claiming that Impression’s activities infringed Lexmark’s right to sell patented cartridges in two circumstances:

1. When cartridges are sold (at a discount) subject to a contractual agreement not to resell or reuse them, and
2. when cartridges are sold outside the US.

Chief Justice Roberts, writing for a unanimous court, sided decisively against Lexmark on both classes of cartridges (except for a partial dissent from Justice Ginsburg on the issue of international sales). Neither contracts nor territoriality were sufficient to undermine the doctrine of “exhaustion.”

Exhaustion is both an accurate description of how I feel every time I have to digest a patent case *and* an important limitation on the rights of intellectual property holders. A patent-holder’s rights are “exhausted” with respect to a particular item once that item is lawfully sold. As Justice Roberts explains, the “exhaustion rule marks the point where patent rights yield to the common law principle against restraints on alienation.” A lay-person might reasonably ask, “The *what* principle against *what now*?” 

The common law is the deep tradition of judge-made law dating back centuries, which the US inherited from England. Exhaustion has deep roots in the common law; Justice Roberts cites the 17th Century treatise of Lord Coke, as well as U.S. and British cases and commentaries dating to the 1800s. One thing the common law really hated was “restraints on alienation,” i.e., limitations on the lawful transfer of property. Once something becomes my property, I should not have to consult a lawyer before deciding whether to sell it, lend it, or leave it to my children in my will. That’s just what “property” means. This gives people legal certainty about an important part of their lives, encourages the transfer of goods, and discourages waste. 

Intellectual property threatens to throw a wrench into this deep legal tradition by granting legal rights of control that encumber goods that have already entered into the stream of commerce. *Intellectual* property and good old-fashioned *property* property seem to be in tension. That’s where exhaustion comes in: once a particular item of property is lawfully sold or transferred, the IP rights that prevent further sale or transfer of that item are “exhausted” and the item can flow freely in the stream of commerce. The alternative, lingering control by patent-holders over sold items, would be “obnoxious” and “hateful,” strong language from the 1917 case *[Straus v. Victor Talking Machine](https://www.courtlistener.com/opinion/98916/straus-v-victor-talking-machine-co/),* quoted with approval by the Chief Justice.

If all of this is sounding familiar, it may be because the court invoked the same principles in a copyright case decided just a few years ago, *[Kirtsaeng v. Wiley](https://en.wikipedia.org/wiki/Kirtsaeng_v._John_Wiley_&_Sons,_Inc.),* which involved the resale of foreign-made textbooks. That case also cited Lord Coke and invoked the deep common law tradition of hostility to restraints on alienation. The statutory basis for that opinion was the “first sale doctrine,” part of the Copyright Act, which says that a copyright-holder’s exclusive right to distribute a particular copy ends once that copy is lawfully sold. *Kirtsaeng* was widely seen as a victory for libraries and the public interest, and I think *Lexmark v. Impressions* should be seen in the same way. The court likes ownership and owners, and is loathe to undermine the rights of owners in favor of IP-holders. For libraries, who collectively own millions of objects that may be covered by IP laws, the notion that their rights of ownership should overshadow at least some of the rights of IP-holders is welcome news.

### Implications for digital goods?

Close watchers of the copyright scene probably raised their eyebrows when they read the Chief Justice’s prime example of why restraints on alienation are harmful to commerce: “a shop that restores and resells used cars.” This was a striking choice because automotive repair has been among the activities legally burdened by the Digital Millenium Copyright Act’s [anti-circumvention](https://en.wikipedia.org/wiki/Anti-circumvention) provisions. Because of this law, advocates for the “right to repair” have been forced to [seek permission from the Copyright Office](https://www.techdirt.com/articles/20161102/00051835941/hey-you-can-hack-your-car-without-violating-copyright-law-little-while.shtml) to allow them to fix cars without seeking permission from the manufacturer. That is, *there is a law in place right now that does [exactly the odious, hateful thing](https://www.wired.com/2015/04/dmca-ownership-john-deere/) that the Chief Justice says would “clog the channels of commerce” in unacceptable ways.* 

Do *Kirtsaeng* and *Impressions* signal anything profound for the future of ownership in the digital age? I’m not sure. The court’s paeans to alienability are heartening, but they may not have as profound an effect as we’d like. Most importantly, they only apply to *sales* of goods; a “licensed” product can still be subjected to any number of restraints on circulation and re-use. All the journals and e-books libraries acquire, for instance, will be unaffected. For all their lofty rhetoric about owners’ rights and the odiousness of limitations on trade, I would not expect the court to invalidate digital licensing regimes, or even the digital locks provisions in the Digital Millennium Copyright Act, any time soon. 

The court gave compelling policy reasons for the doctrine of exhaustion, but it did so in service of the argument that patent law as written already respects this common law principle. Likewise in *Kirtsaeng,* the paeans to exhaustion were in the context of interpreting a law that on it’s face seemed to embody that doctrine. Where Congress chooses to pass a law that is flatly at odds with exhaustion, as the DMCA digital locks provisions surely are, I don’t expect this court to second guess Congress’s judgment on that basis. Exhaustion is a fine old tradition, but it is not in the Bill of Rights. (Perhaps recognizing this, the EFF has filed a [very smart lawsuit](https://www.eff.org/press/releases/eff-lawsuit-takes-dmca-section-1201-research-and-technology-restrictions-violate) alleging that the DMCA violates the First Amendment, which very much *is* in the Bill of Rights, and I’m hopeful for their chances.) We probably have not seen the end of [The End of Ownership](https://mitpress.mit.edu/end).

## *Packingham* and the Right to Access the Internet

*[Packingham v. North Carolina](http://www.scotusblog.com/case-files/cases/packingham-v-north-carolina/)* is another case that seems to raise questions, this time much more serious ones, about the Digital Millenium Copyright Act. The Supreme Court, with a majority opinion by Justice Kennedy and a concurrence by Justice Alito, invalidates a North Carolina law that bars convicted sex offenders from using social media websites. In doing so, Justice Kennedy in particular makes a series of sweeping statements about the importance of access to the internet that cast a very dark shadow over laws requiring termination of internet access for alleged copyright infringers.

To decide whether the North Carolina law violates the First Amendment, the court applies the test for content-neutral “time, place, and manner” restrictions on speech—“intermediate scrutiny”—which requires the law to be “narrowly tailored to serve a significant governmental interest.” While the governmental interest in preventing sexual abuse of children is undoubtedly very significant, the court finds that the law is much too broad relative to that interest. Justice Kennedy’s opinion argues that even if the law only applies to social media sites “as commonly understood” (i.e., Facebook, Twitter, LinkedIn), it is still too broad. Justice Alito’s opinion seems to depend more on the fact that the law arguably sweeps in other sites, like WebMD, Amazon, and even WashingtonPost.com, which he argues goes clearly beyond any reasonable scope of a bar to protect children. Both opinions don’t foreclose a narrower bar on online activity, more closely connected to protecting children.

The import of these opinions for copyright law could be substantial, as they both seem to cast serious doubt on any law that denies access to the entire internet. Protecting children has been recognized repeatedly as a core governmental interest, and yet the Court in *Packingham* finds this interest insufficient to justify a ban on convicted sex offenders accessing even a subset of internet sites. This seems to be a death knell for anything like a [“three-strikes” law](https://en.wikipedia.org/wiki/Graduated_response)—a mode of copyright enforcement involving ISP account termination for alleged repeat infringers. Content industries pursued such laws for years, and eventually were able to enact them in several countries, but never in the US. [SOPA](https://en.wikipedia.org/wiki/Stop_Online_Piracy_Act)-type laws, which permit blocking of entire domains based on alleged infringement, may also be in tension with the reasoning in *Packingham*.

There is already a law on the books in the US that may be affected by *Packingham.* As [Annemarie Bridy](https://cyberlaw.stanford.edu/blog/2017/06/what-packingham-v-north-carolina-should-mean-dmca) and [Harold Feld](http://www.wetmachine.com/tales-of-the-sausage-factory/packingham-and-the-public-forum-doctrine-part-i-implications-for-copyright/) have observed, the DMCA’s “repeat infringer” provision ([17 USC 512](https://www.law.cornell.edu/uscode/text/17/512)(i)) seems to be in tension with the values in the opinion. Some copyright holders are demanding that courts interpret 512(i) to require termination of a user’s account based on mere accusations of infringement, a *much broader* bar on First Amendment activity (blocking the entire Internet, not just “social media” sites) based on a *much flimsier* governmental interest (protecting media companies from an alleged copyright infringer, versus protecting children from a convicted sex offender). The issue has already been raised in the [Cox v. BMG case](https://www.washingtonpost.com/news/the-switch/wp/2016/08/12/the-copyright-case-that-should-worry-all-internet-providers/?utm_term=.f8bfca69ce4f), which is on appeal in the Fourth Circuit.

Feld also [argues](http://www.wetmachine.com/tales-of-the-sausage-factory/packingham-and-the-public-forum-doctrine-part-i-implications-for-copyright/), fairly persuasively IMO, that *Packingham* casts doubt on the notice-and-takedown regime of the DMCA, which gives copyright holders the power to silence speakers online without legal process. In at least some circumstances, that regime seems to suppress protected online speech with little pay-off in terms of governmental interest.

Stay tuned. *Packingham* could be the start of expansive new First Amendment protection for speech activities online.

## *Tam* and the Speech Effects of IP Protections

The final case in the trio of SCOTUS IP cases has perhaps the most tenuous connection to library concerns, but I still think it’s interesting because of the way the court flubs a basic fact about intellectual property. *[Matal v. Tam](http://www.scotusblog.com/case-files/cases/lee-v-tam/)* struck down the ban on federal registration of disparaging marks. The law, which bars registration of marks that would “disparage…or bring…into contemp[t] or disrepute” any “persons, living or dead,” has bedeviled the [Washington football team](https://www.washingtonpost.com/local/public-safety/2017/06/29/a26f52f0-5cf6-11e7-9fc6-c7ef4bc58d13_story.html) for decades thanks to litigation from native American groups who claim the team’s name is disparaging to them. (Full disclosure: original plaintiff Suzan Shown Harjo is a long-time client of the [Glushko-Samuelson IP Law Clinic](http://ipclinic.org), where I worked from 2013-2016.) In this case, however, it barred the registration of “The Slants” by a punk band whose Asian-American members intend to reclaim the slur as a mark of pride. 

While the case may look at first like a victory for free speech (the ACLU weighed in on the side of Tam and the Washington team, after all), I find it troubling from an IP perspective. If you read [amicus briefs](http://www.pijip.org/wp-content/uploads/2016/09/15-1293-amicus-petitioner-Law-Professors.pdf) and [essays](http://www.slate.com/articles/news_and_politics/jurisprudence/2015/04/washington_football_team_s_name_is_a_racial_slur_doj_and_patent_and_trademark.html) from trademark experts like Christine Farley and Rebecca Tushnet, you’ll see that the Court got a central issue exactly wrong in the case: a trademark is not an entitlement to speak; it is the power to silence others’ speech. If they had lost, Simon Tam and his band would still be free to use “The Slants” as a band name, to write it, speak it, scream it, print it on t-shirts, invoke it in op-eds, and whatever else they might like to do. Now that they’ve won, Tam and co. have all those rights *and* the power conveyed by a federally registered mark to *silence others* who use the word in commerce. That right to silence is limited (much more limited than most folks realize, in fact), but the net result of the Court’s opinion in *Tam*, is that *fewer people* are free to use the word, at least in certain commercial contexts. How is that a victory for speech? 

More generally, then, what’s troubling about *Tam* (other than the way it will empower Dan Snyder and his team to inflict [documented psychological harm](https://www.americanprogress.org/issues/race/reports/2014/07/22/94214/missing-the-point/) on native people, especially children) is the way it showcases the Court’s misunderstanding of IP, treating it as if it were some kind of pre-condition for speech, when in fact it is literally a mode of government-sponsored speech suppression. Judge Alito in the very first page of the opinion writes, “[the ban on disparaging marks] offends a bedrock First Amendment principle: Speech may not be *banned* on the ground that it expresses ideas that offend.” [Emphasis mine.] This is some pretty “undisciplined dicta” (to borrow Justice Alito’s characterization of Justice Kennedy’s praise for the internet), because of course the disparagement clause does not ban any speech. It merely denies a government benefit to disparaging speech, and in the process leaves more speakers free to speak using exactly the barred term. Awarding the registration to Tam may well suppress more speech than it enables.

Of course, the underlying assumption of all IP regimes is that a temporary, limited monopoly will encourage certain behavior (creativity, invention, use of distinctive identifying marks in the marketplace) in ways that are more beneficial than the losses to people whose uses are excluded by the monopoly. But as a threshold matter, it is important to acknowledge that IP is *on its face* a government-sponsored private suppression of speech activity, tolerated only because of its allegedly greater positive effects. In the trademark context, the goal is not even expressive; it’s commercial. Trademarks suppress speech in order to foster a better-functioning marketplace. It is disheartening that the Court did not perceive this subtle but foundational fact about intellectual property and speech.

Relatedly, I’ll say that, especially after working with Suzan Harjo, Vicki Phillips, Christine Farley, Peter Jaszi, and the IP Clinic, I think the court vastly underestimated the governmental interest on the other side. The social harm of mascoting and other degrading commercial activity is real and documented. The current political climate has a lot of us fretting about incivility and wondering whether a wide-open debate dominated by trolls and Russian bots is really what Madison and co. had in mind. In *Tam*, I think the court vastly inflated the value of the trademark interest, and gave short shrift to the public interest in a civilized marketplace.