---
layout: post
published: true
comments: true
date: '2017-05-25 12:59 -0400'
title: The Department of Education Open Licensing Rule Went Into Effect This Week
excerpt_separator: <!--more-->
---

As of this Monday, May 22, 2017, the Department of Education's [Open Licensing Rule](https://www.federalregister.gov/documents/2017/01/19/2017-00910/open-licensing-requirement-for-competitive-grant-programs) is in effect. The Rule helps ensure broad public access to the products of federal grant-funded education research. Federal investments in this area can yield great benefits to the public, and requiring a plan for public access that includes broad licenses to encourage reuse will help multiply those benefits. SPARC has an [excellent overview](https://sparcopen.org/our-work/department-of-education-open-licensing-policy/) of the rule, including the full text and links to relevant laws and regulations. <!--more-->

The rule was the source of some [discord](https://www.forbes.com/sites/lindseytepe/2016/01/12/the-divide-over-open/#311742e356a7) between libraries and some of our friends on main campus, as libraries generally favored broad licensing and availability, while some campus groups [feared](https://er.educause.edu/blogs/2017/2/us-dept-of-ed-releases-final-open-licensing-rule) licensing could threaten their IP rights and arrangements with third parties. EDUCAUSE's write-up suggests the final rule struck a balance between these interests. There was some concern that the Trump administration might not follow-through with the initiative, which began with President Obama, but thankfully the Department has decided to move forward.

Here are a few takeaways for grantees and others interested in the Rule:

- The new rule permits licenses conditioned on "non-commercial" use (like [CC-BY-NC](https://creativecommons.org/licenses/by-nc/4.0/legalcode)). While public access under a CC-BY-NC-type license guarantees individuals will be able to make private, personal uses of grant-funded research outputs, a "non-commercial" condition preserves some ability to monetize the materials by charging for commercial uses, as in [multiple licensing](https://en.wikipedia.org/wiki/Multi-licensing) business models common in software.

- The rule requires that licenses permit the preparation of derivative works (like translations, compilations, abridgments, and other adaptations), so CC licenses with the "ND" element will not satisfy the rule.

- The easiest way to comply with the new rule's licensing requirements will be to choose from the suite of [Creative Commons](https://creativecommons.org/) licenses, which include terms consistent with the rule, are widely-used, and have unique URIs and symbols associated with each license. CC0, CC-BY, and CC-BY-NC should work. It's unclear to me whether a "share-alike" (SA) restriction would comply with the rule, however.

- Grantees will be looking for ways to meet the requirement that they have a plan to provide public access to research outputs. Institutional repositories like [Libra](http://libra.virginia.edu) may be an attractive option. 

UVA faculty who have questions about the new rule or would like help choosing a license should feel free to reach out to the Library. And, if you're interested, discuss in the comments: Are you planning to apply for an ED grant in the next cycle? How will this rule affect your proposal? Are you happy with the final rule, do you have reservations? What do you think about Share-alike licenses and the new rule?