---
layout: post
published: true
comments: true
date: '2017-05-18 10:02 -0400'
title: Green Shoots in Spring at the Library of Congress and the Copyright Office
excerpt_separator: <!--more-->
---

Imagine if you could download a .ZIP file with every single Copyright Office record, from the beginning of time thru, say, 2014, in a standardized and searchable format, free online. Who owns what, when it was published, whether it was renewed, even (dare to dream) when copyrights were sold or licensed exclusively to others, all in your choice of standard formats. What could people build around that free dataset? What could scholars learn? What deals could get done to revive forgotten works for new audiences?

I ask because the Library of Congress [just did the equivalent](https://www.loc.gov/item/prn-17-068?loclr=ealn) with its MARC records, the electronic version of cards in a card catalog. The Library released 25 million records, its largest public data release ever, for free bulk [download](http://www.loc.gov/cds/products/marcDist.php) online. For years the Library has diligently created, compiled, updated, and distributed these records to libraries through a subscription service, which it will still offer. (The free bulk download doesn’t include the last 2 years’ worth of data, to preserve some incentive for institutional users to maintain the subscription service, presumably a cost-recovery mechanism that supports creation and maintenance of the data). 

This is noteworthy because it is deeply inconsistent with the argument from supporters of HR 1695 that the Copyright Office needs to cut ties from the Library in order to “modernize” its information services. <!--more--> HR 1695 supporters seem to believe that a fusty old library could not properly serve the information needs of the bazillion dollar industries who depend on the Copyright Office for registration, recordation, and related services. The Library’s MARC service shows that, to the contrary, information professionals may be *exactly the right people* to help create, maintain, and ultimately make available to the public important information about our cultural heritage. 

The idea that the Office is struggling under the yoke of the Library is also belied by a series of promising signs from the Copyright Office itself. This morning the Office published a [Notice](https://www.federalregister.gov/documents/2017/05/18/2017-09810/modernizing-copyright-recordation) in the Federal Register announcing its intent to move to fully electronic submission of documents recording a sale, license, or other interest in a copyright, as well as author terminations of transfers. These efforts are based on inquiries that started in 2014, and a comprehensive [report](https://www.copyright.gov/technology-reports/reports/recordation-report.pdf) by legal scholar Robert Brauneis (better known, perhaps, as the guy whose law review [article](http://papers.ssrn.com/sol3/papers.cfm?abstract_id=1111624) led to the release of “Happy Birthday” into the public domain). The Office is now writing the rules that will lay the groundwork for a fully-electronic recordation system.

If all that sounds dry to you, consider this excerpt from the Notice:

> Public Availability of Recorded Documents. Currently, while indexed information about recorded documents is available to the public through the Office’s online catalog, the documents themselves are not. *They are only available for in-person inspection at the Office’s reading room in Washington, D.C. or by making a search and retrieval request.* [emphasis added] The Office plans, as recommended by the Brauneis Report, to update this practice going forward by **making all documents recorded after the launch of the new system available on the internet**, regardless of whether the document was submitted through the new system or via the paper process described above. **The Office sees no reason why someone should be required to travel to Washington, D.C. or to make an expensive search and retrieval request to view these records.** Privacy, confidentiality, and other related concerns with making these documents available online should be allayed by the proposed redaction rules discussed above.
 
> In the future, the Office intends to explore also making documents recorded prior to the system’s introduction available online, and will issue an NPRM on the subject at a later date to address issues such as redaction.

Anyone who’s done research on copyright ownership can tell you that the actual documents can be an important part of the search. Obviously this is just an announcement of intention, and execution is pretty darn important. But the Office is looking in the the right direction, and taking important steps to prepare the way.

A couple of other recent actions add to this sense of progress at the Office. A [Notice of Proposed Rulemaking](https://www.federalregister.gov/documents/2017/05/09/2017-09317/pilot-program-for-bulk-submission-of-claims-to-copyright) issued a few weeks ago would create a pilot program for bulk submission of copyright claims, the first step in development of more efficient ways for copyright holders to interact with the registration system. Another [notice](https://www.federalregister.gov/documents/2017/05/19/2017-10219/authentication-of-electronic-signatures-on-electronically-filed-statements-of-account), slated to publish officially tomorrow, paves the way for wider uses of electronic signatures in certain Office filings, another necessary prerequisite for moving away from a paper-based filing system. 

This all matches what I’m hearing through back channels, that Dr. Hayden’s commitment to modernizing the Library and shoring up its fundamental processes is leading to more and better collaboration between the Library and the Office than has been seen in years. Rules and processes that were stuck appear to be coming un-stuck, and we may be seeing the results in the pages of the Federal Register. If progress continues at this pace, the Copyright Office may one day be able to make a release as audacious as the Library did this Tuesday.