---
layout: post
published: true
comments: true
date: '2017-05-19 09:00 -0400'
title: >-
  Does Fair Use Affect Academic Authors’ Incentive to Write? Some Lessons from
  Authors of Works from the GSU Course Reserves Case
---
*This post was co-authored by David Hansen and Brandon Butler and cross posted on [The Taper ](http://thetaper.library.virginia.edu/)and on [Duke University Libraries’ Scholarly Communications Blog.](https://blogs.library.duke.edu/scholcomm/)*


Copyright law in the U.S. is premised on the idea that exclusive rights given to authors act as an incentive for them to create and disseminate new works, which ultimately benefit the public. Does it actually have that effect, particularly for academic authors? And if so, how does the scope of limitations on copyright, such as fair use, affect the strength of that incentive? 

It’s an interesting question, and one that seemed to concern the 11th Circuit Court of Appeals when it first weighed in on the [Cambridge University Press v. Patton](https://casetext.com/case/cambridge-univ-press-oxford-univ-press-inc-v-patton) GSU e-reserves fair use case (read more things we’ve written about that case [here](https://blogs.library.duke.edu/scholcomm/2016/11/21/13586/) and [here](http://brandonbutler.info/post/100609027690/transformative-teaching-after-gsu)). The court explained: 

 If copyright's utilitarian goal is to be met, we must be careful not to place overbroad restrictions on the use of copyrighted works, because to do so would prevent would-be authors from effectively building on the ideas of others. Some unpaid use of copyrighted materials must be allowed in order to prevent copyright from functioning as a straightjacket that stifles the very creative activity it seeks to foster. If we allow too much unpaid copying, however, we risk extinguishing the economic incentive to create that copyright is intended to provide.

  


Since fair use is to be assessed “[in light of the purposes of copyright,”](https://casetext.com/case/campbell-v-acuff-rose-music-inc) that analytical framework seems spot on. But how can we tell if particular types of fair use--e.g., use of excerpts from books for classroom uses--hurt or help incentives to create and disseminate new works? One way to make this assessment is to look at the use “from the point of view of the reasonable copyright owner,” which is the approach the Supreme Court identified in H[arper & Row Publishers, Inc. v. Nation Enterprises, 471 U.S. 539, 550 (1985)](https://casetext.com/case/harper-row-publishers-inc-v-nation-enterprises). What is the perspective of the “reasonable copyright owner?” 

### A Survey of GSU Authors

We thought one way to find that perspective would be to ask authors who are routinely on both sides of the copyright equation, creating and reusing copyrighted works. Specifically, we thought we would ask the authors of the works that form the basis of the GSU lawsuit. That case involves a large number of academic works; at trial the plaintiff-publishers claimed 74 instances of infringement  for use of excerpts of works uploaded to GSU course websites over three semesters. Those works were associated with 112 living authors and editors, and for most (79) we were able to identify current contact information. (Big thanks to Brandon’s research fellow [Sedef Ayalp](https://www.linkedin.com/in/sedefa/)!)

  


We developed a survey with ten questions to see whether these authors knew about the case, whether they approved of GSU’s uses being treated as fair use, and whether they themselves make fair use of others’ academic works in their teaching. The questions were designed to shed some light on our hypothesis: that most academics expect their works to be used freely for teaching, partly because they make such uses themselves. If we are right, fair use should favor these uses to the extent they would have no negative effect on the authors’ incentives to create. (The incentives of publishers are a separate issue.) 

  


In total, we received 18 responses. That was enough to pique our interest, though we don’t want to overstate the results or extrapolate from them; this was a survey of a small group of people for which respondents self-selected participation. Nevertheless, we did see responses that were consistent with our hypothesis, at least as applied to this group of respondents. We’re sharing the results here in hopes that it will interest you as well and spur more research on how authors think about fair use. 

### Results

First, we asked about familiarity with the suit. Eleven respondents said they were not even aware of the suit prior to the survey, and seven indicated familiarity. When asked “Were you consulted by the publishers before this lawsuit was filed?” all respondents answered “no.”

  


As for the substance of the lawsuit, for a baseline we asked about which side the author tended to support. Most indicated strong support for GSU, or took a neutral position. One author indicated strong support for the publishers. 

  


**Table 1 - Responses to “Based on what you know about the suit, do you as an author or editor of the works used by GSU faculty support either side of the” dispute?**

| Answer | Responses |
|:---|--:|
| Strongly Support GSU | 11 |
| Support GSU | 1 |
| I am neutral | 5 |
| Support Publishers | 0 |
| Strongly Support Publishers | 1 |


When asked about incentive effects, most said that these types of uses had no effect on their motivation to produce new works, while one person said that it had a negative effect. Five respondents indicated that these types of uses actually had a strong positive effect on writing new works

  


**Table 2 -  “How does the use of your work in ways similar to how GSU faculty used it--unpaid excerpts available to enrolled students through a secure online course page--affect your motivation to produce new works?”**

| Answer | Responses |
|:---|--:|
| Strong negative effect on writing new works | 0
| Negative effect on writing new works| 1
| No effect| 11
| Positive effect on writing new works | 1 |
| Strong positive effect on writing new works| 5 |

  


Getting down into how royalties in particular factor into these authors’ incentive to write, most respondents indicated that it wasn’t a factor at all. 

  


**Table 3 - How important is the expectation of royalties in your motivation to write works like the one at issue in this case?**

| Answer | Responses |
|:---|--:|
| Extremely important (e.g., I don't write unless I expect royalties) | 0 |
| Very important | 0 |
| Moderately important | 3 |
| Slightly important | 4 |
| Not at all important (e.g., I happily write without any expectation of royalties) | 10 |

  


  


We also asked a few other questions about royalties and about how these authors may have made their own uses of excerpts in courses they have taught. You can see the full set of questions and responses (minus a free-text response field since those responses may reveal personally identifying information) [here](https://docs.google.com/spreadsheets/d/1kt7HiHdcz-2Ho5AVLKQ5xiZKqM2-LRvttmQSQxzR5FA/edit?usp=sharing).

  


### Conclusions and Reflections

As we say above, this is certainly not enough data to prove or disprove our hypothesis about what academic authors actually believe or do. It is nevertheless encouraging that our limited data is consistent with what we would expect to see if academic authors write with the expectation that their works would be subject to broad fair use for educational purposes. 

This is a theory of fair use with deep roots. Alan Latman’s [study](https://www.copyright.gov/history/studies/study14.pdf) of fair use, published in 1958 as part of the Copyright Office’s review of the law, explains, “One theory behind such permissible copying is the implied consent of the copyright owner. In many cases, duplication of portions of his works should be desired by the author for its beneficial effects.” This is consistent with the overall incentives-based approach to copyright; uses an author would welcome are, presumably, uses that would not diminish the author’s incentive to write and publish her work. These should get strong fair use protection. (Like Latman, we believe the scope of fair use goes beyond what implied consent would cover; those uses to which an author would consent if provided the opportunity have a particularly strong claim to fair use, but author consent is not the end-all-be-all of fair use.)

  


Another notable aspect of the survey responses is the total disconnect between the authors of these works and the lawsuit brought by their publishers. Most were unaware of the suit, and none were consulted by the publishers before the lawsuit was filed or as it was being litigated. The law does not require author consent to lawsuits like this, where the publisher (presumably) holds the copyright or an exclusive license to the underlying work. (Although, one interesting aspect of the GSU case is how many of their claims the publishers had to abandon because they could not prove copyright ownership.) Once the transfer or license is made, the publisher is empowered to enforce the rights it has acquired. Authors, courts, policymakers, and universities should consider this potential disconnect between authors and publishers as they make key decisions about copyright law and policy.

  


Authors faced with a publishing contract  that includes a copyright transfer or license should consider whether they trust the publisher to enforce those rights in ways consistent with academic values and expectations. While in theory these uses should be (and so far have been) protected by fair use, authors who want to be sure that their expectations about educational use will be followed may want to explore publishing in open access venues or self-archiving in repositories using open licenses, like the suite offered by Creative Commons. The disconnect between authors and publishers further validates the efforts of organizations like the Authors Alliance and SPARC, who work to empower authors to use their rights to enable broad access and reuse, and to educate publishers about modes of distribution that better fit author needs. 

  


Courts and policymakers should keep the author-publisher distinction in mind as they weigh [amicus briefs](http://www.infodocket.com/2013/03/05/aap-mpaa-and-others-file-amicus-briefs-in-authors-guild-v-hathitrust-appeal/) and [white papers](https://cpip.gmu.edu/wp-content/uploads/sites/31/2014/04/Viswanathan-Mossoff-Open-Access-Mandates-and-the-Seductively-False-Promise-of-Free.pdf) from publishers and their trade associations. These advocacy pieces often blur the line between authors and publishers, placing publishers in the shoes of authors and warning that decisions favoring fair use or open access may undermine scholarship. Publishers’ incentives and their copyright policy preferences may diverge substantially from those of authors. 

  


Universities and libraries should consider this disconnect as they make decisions about which kinds of publication models to support. Like courts and policymakers, universities and libraries are often told that established publishers are indispensable stewards of the scholarly record. These arguments ring hollow if publisher choices about how to exploit and enforce copyrights come apart from academic interests and values.

  


We hope to do more research to learn more about the incentives and expectations of academic authors. Until then, we hope this preliminary sketch has been helpful and will point others in useful directions for their own research.
