---
layout: post
published: true
comments: true
date: '2017-02-20 23:01 -0500'
title: 'Fair Use and Open Access: Two Great Tastes That Taste Great Together'
---
*cross-posted at Harvard's [Library Copyright Blog](http://blogs.harvard.edu/copyrightosc/2017/02/21/fair-use-week-2017-day-two-with-guest-expert-brandon-butler/)*

![fair-use-week-logo-sm.jpg]({{site.baseurl}}/images/fair-use-week-logo-sm.jpg)

Fair use and open access are two crucial tools that serve the same core purpose: making information maximally available and useful without running afoul of copyright law. A comprehensive strategy for increasing access to knowledge has to bring both tools to bear (at least in [countries where fair use or something like it is available](http://infojustice.org/wp-content/uploads/2013/03/band-and-gerafi-2013.pdf)). 
<!--more-->
And yet, it is a tempting rhetorical strategy to deprecate fair use as part of the argument for open access, or for copyright reform generally. Fair use, we are sometimes told, is too weak, too uncertain, too risky, so we must turn to open access/open licensing as the one true path to unlocking knowledge. Lawrence Lessig may be the most common source for the view, [articulated](https://en.wikipedia.org/wiki/Free_Culture_(book)#cite_ref-85) in his book *Free Culture*, that “fair use in America simply means the right to hire a lawyer.”

[Fair Use Week](http://fairuseweek.org) itself is evidence that Lessig’s clever put-down has not worn well over time; fair use is more-and-more understood as a reliable First Amendment right that powers the [HathiTrust](https://www.insidehighered.com/news/2014/06/11/hathitrust-continues-string-victories-under-fair-use-doctrine-appeals-court), [South Park](http://www.hollywoodreporter.com/thr-esq/thr-turns-5-south-park-842169), and [This Charming Charlie](http://thischarmingcharlie.tumblr.com) with equal aplomb. Fair use will not generally allow levels of access and use that are as wide open and unambiguous as open access, but fair use is still a crucial—and *reliable*—part of the legal protections for libraries and our users.

![tumblr_mrl7l98KIU1seji43o1_r3_1280.png]({{site.baseurl}}/images/tumblr_mrl7l98KIU1seji43o1_r3_1280.png)

*from the genius mashup of the Smiths and Peanuts, [This Charming Charlie](http://thischarmingcharlie.tumblr.com/post/58417454263).*

Once that political misconception is cleared away, however, we still have to address the tricky legal questions that arise when fair use and open access are mixed together in practice. One of the trickiest is whether the author of an article published under an open license like CC-BY may incorporate portions of others’ works into her new CC-licensed work under fair use, as she would if she published in a traditional way? Kevin Smith actually [addressed this issue](https://blogs.library.duke.edu/scholcomm/2014/09/25/fair-use-open-access-incompatible/) a few years ago, observing that the CC-BY license itself holds the key: 

> Licensors should clearly mark any material not subject to the license. This includes other CC-licensed material, or material used under an exception or limitation to copyright.

Yes, in other words, of course you can, and the license tells you how. Because a CC license creates certain expectations in users (namely, that they can reuse any or all of the work under the terms of the license), you should be sure to manage those expectations and help users make smart choices.
 
Users, by the same token, will need to be familiar with fair use generally in order to determine whether and how the doctrine will continue to shield downstream uses of these “mixed” openly-licensed works.  

So, for the foreseeable future, fair use and open access will be two great tastes that taste great together. Fair use will be a vital right for as long as we want to comment on, critique, and otherwise engage with the vast majority of culture. Open access will be the best way to ensure that the next generation of discoveries and ideas have maximum impact. And when new ideas, aesthetics, and insights build (as they so often do) on the works of the past, and are published with an open license, well, that’s the best of both worlds.
