---
layout: post
published: true
comments: true
date: '2016-12-14 11:27 -0500'
title: 'Libraries and Copyright: 42 Experts Weigh In'
excerpt_separator: <!--more-->
---
Today I  sent a [letter](/images/42-Experts-Letter-re-CO-signed.pdf) on behalf of 42 copyright lawyers, scholars, and expert librarians to leaders in Congress. In it, we explain the rich relationship between libraries and copyright, and urge Congress to keep the Office where it has lived for more than a century: inside the Library of Congress. We hope this letter will be a useful input as the House Judiciary Committee considers the first part of its copyright reform agenda, announced earlier this week in a [one-pager](https://judiciary.house.gov/wp-content/uploads/2016/12/Copyright-Reform.pdf) and short [YouTube clip](https://www.youtube.com/watch?v=pW208w84nHM) focused on the Copyright Office. The Duke University Libraries sent [a fantastic letter](http://blogs.library.duke.edu/scholcomm/2016/12/14/where-should-the-copyright-office-live/) yesterday, the Library Copyright Alliance (LCA) issued a [clear preliminary statement](http://www.districtdispatch.org/2016/12/17746/), and I expect there will be more input from the library community as this discussion continues.

Our letter was originally prompted by another [letter](https://artistrightswatch.com/2016/11/30/must-read-two-former-u-s-copyright-heads-defend-maria-pallante-from-sacking-by-rogue-librarian-of-congress/),<!--more--> sent by two former Registers of Copyright (Ralph Oman, who led the U.S. Copyright Office from 1985 to 1993, and Marybeth Peters, who held the position until 2010). In their letter, the former registers sounded the alarm about a looming threat to copyright policy: libraries. And especially the Library of Congress, the most library-est of libraries!

Ugh.

I like Washington, D.C., a lot. I lived and worked there for almost a decade, and I met so many smart, dedicated people there who were working hard to make life better for people all over the country, and all over the world. But sometimes the discussions there could become so oversimplified that they lost touch with reality. That certainly happened with copyright and libraries. 

No matter how many times I and my very capable colleagues from ALA, ARL, and beyond would explain the richness and complexity of library-world, the default view of what libraries do is that we just want to make everything free for all. Or, as Oman and Peters put it in their letter, “offering to the public the greatest possible volume of material, often at little or no direct cost to their patrons.”

No doubt fostering wide, free access to information is certainly a core part of the library mission, but it’s only the tip of the iceberg, especially in the digital age. And it’s only the end result of a complex process that includes, among other things, libraries investing enormous sums in the acquisition, description, and organization of copyrighted works. We have always recognized that our mission is embedded in a complex ecosystem that we both feed and are fed by. 

No one understands this complexity as well as the folks whose job it is to educate and inform libraries and our users about copyright. So, 42 of us sent a letter to DC to share what we know. As our letter explains:

> We routinely consult with teachers and students who are creating films and showing films, creating music and performing music, creating art and displaying artworks, writing plays and performing plays. We educate these creators on various aspects of copyright, supporting them in maximizing the impact of their work and making lawful use of others’. Since creators are also users of copyrighted content, balance is essential for a robust creative culture and economy. We understand that copyright is a complex ecosystem of people who occupy different roles at different times (and often at the same time), not a zero-sum struggle between opposing sides. That ecosystem thrives in our libraries. 

Hopefully our letter, together with the Duke Libraries' letter and future interventions from LCA and others, will help clarify the many ways that libraries like ours foster a healthy copyright ecosystem. There is no more fitting place for the Copyright Office to live than in the largest national library in the world. 

 