---
layout: post
published: true
comments: true
date: '2016-11-21 11:52 -0500'
title: The Fallacy at the Heart of the Publishers' Latest GSU Brief
excerpt_separator: <!--more-->
---

> Fellow man! Your whole life, like a sandglass, will always be reversed and will ever run out again, - a long minute of time will elapse until all those conditions out of which you were evolved return in the wheel of the cosmic process. And then you will find every pain and every pleasure, every friend and every enemy, every hope and every error, every blade of grass and every ray of sunshine once more, and the whole fabric of things which make up your life. 

> Friedrich Nietzsche, *Notes on the Eternal Recurrence*

In times of great change and tumult, we in library- and copyright-land can take a measure of comfort in at least one [eternal recurrence](https://en.wikipedia.org/wiki/Eternal_return#cite_ref-8): the Georgia State course reserves case grinding on and on. <!--more-->

Last Friday the publishers filed their [opening brief](https://blogs.library.duke.edu/scholcomm/files/2016/11/GSU-Appellants-Brief.pdf) in the case’s second round of review at the 11th Circuit Court of Appeals in Atlanta. By now we know their argument, but in reading it again for the fourth time, I am struck anew by the extraordinary slipperiness of the slope they use to slide GSU into infringement territory. 

It’s no suprise that the publishers manage to shrink fair use until it could fit neatly inside a thimble ([thanks](https://twitter.com/bc_butler/status/799955123682377728), [*Harper & Row*](https://en.wikipedia.org/wiki/Harper_&_Row_v._Nation_Enterprises)). What continues to trouble me is how they attack GSU using a fallacious misreading of the landmark *Campbell* case, and its embrace of “transformative use.” 

## The backstory
The shortest possible version of the GSU story might go something like this: the [AAP](http://publishers.org) and [CCC](http://copyright.com) recruited and funded three big academic publishers to sue Georgia State University (GSU) over using electronic platforms to provide students access to excerpts from books. GSU [won](http://www.publishersweekly.com/pw/by-topic/digital/copyright/article/51930-judge-delivers-mixed-verdict-in-gsu-e-reserves-case.html) in the first district court opinion, but the publishers [got a do-over](http://www.publishersweekly.com/pw/by-topic/digital/copyright/article/64454-appeals-court-reverses-gsu-copyright-ruling.html) when the appeals court disagreed with some of the district court’s reasoning. The district court gave GSU an even [bigger win](http://www.publishersweekly.com/pw/by-topic/digital/copyright/article/69830-gsu-prevails-again-in-key-copyright-case.html) in its second opinion, so the publishers appealed again. Now here we are: the publishers have filed their first brief with the appellate court, and GSU will file their reply early in the new year.

If you want a (much) longer version of the story, I’ve written about the first half of this saga - the litigation and the first district court and appellate court opinions - [here](https://osf.io/8tzg7/). In that article, I recount the long history of conflict between libraries and publishers over using book excerpts for teaching, starting with the negotiations over the 1976 Copyright Act. I tried to show how that history has so far placed education in a parallel universe far removed from what is now the mainstream of fair use jurisprudence.  

## Deterred from Their Mission by a Rounding Error?
In their latest salvo, the publishers continue to exploit that distance. They argue, *inter alia*, that Judge Evans of the district court misapplied the relevant law regarding market harm, the fourth statutory factor in [Section 107](https://www.law.cornell.edu/uscode/text/17/107). In particular, they really don’t like that Judge Evans actually looked at the publishers’ balance sheets and discovered, for example, that license payments to CCC for electronic excerpts account for **at most 0.9% (nine-tenths of one percent), and perhaps as little as 0.046% (five one-hundredths of one percent),** of average revenue for each publisher. *See* [Cambridge University Press v. Becker](https://scholar.google.com/scholar_case?q=Cambridge+University+Press+v.+Becker&hl=en&as_sdt=6,47&case=18306741473986959577&scilh=0) at 1216.

It is hard to blame the publishers for trying to keep courts' noses out of their books. Once you get those numbers in your head, you can hardly forget them. Judge Evans also noted that net revenue for these three publishers collectively in FY2009 was around $500,000,000, i.e., **half a billion dollars.** Again, anyone who sees these numbers will find it impossible to imagine how GSU’s unlicensed activities could harm the publishers’ incentives to distribute scholarly works in the slightest. If this is the “weight” of the market harm under factor four, no wonder GSU won so resoundingly.

## Fallacy to the Rescue
So the publishers respond by arguing that, as a matter of law, courts cannot look at those numbers. If I have my hand out, but you won’t pay me, that’s market harm. And, what’s more, all market harm is equally fatal to fair use. Before you know it, by this logic, the whole game is over and they’ve won.

Of course, there is no reason courts should ignore the degree or extent of market harm as they weigh factor four. Indeed, it seems fairly reasonable to consider not only the existence of a market effect, but also the *extent* of that effect. This helps tell the court how much weight to give the fourth factor as it weighs all four factors (and any other relevant info—the factors are non-exclusive) together “in light of the purposes of copyright.” [*Campbell*](https://scholar.google.com/scholar_case?q=campbell+v.+acuff-rose&hl=en&as_sdt=6,47&case=16686162998040575773&scilh=0) at 578.

The publishers’ fundamental error is to draw an inappropriate negative inference from the doctrine we have on transformative use. The Supreme Court tells us in *Campbell* that “when…the second use is transformative, market substitution is at least less certain, and market harm may not be so readily inferred.” Indeed, transformative uses like parody and criticism are usually immune to claims of market harm insofar as the harm is a result of their critical character; copyright is not an entitlement to silence critics and prevent harm of the kind that might result from a bad review or a devastating parody.

In short, *Campbell* and subsequent case law tell us that if a use is transformative, then certain kinds of market harm (harm from criticism, e.g.) will not weigh against fair use at all. 

The publishers have asked the 11th Circuit to commit a supercharged version of the fallacy of [denying the antecedent](https://en.wikipedia.org/wiki/Denying_the_antecedent): if a use is *not* transformative, then it necessarily creates market harm so dire as to overwhelm all the other factors and render the use unfair. 

This is absurd. All that the courts have told us is that market harm from substitution is “cognizable.” Even where there may be such harm, *Campbell* tells us this: 

> “Market harm is a matter of degree, and the importance of this factor will vary, not only with the amount of harm, but also with the relative strength of the showing on the other factors.” 
[*Campbell*](https://scholar.google.com/scholar_case?q=campbell+v.+acuff-rose&hl=en&as_sdt=6,47&case=16686162998040575773&scilh=0) at 590, n.21.

Courts evaluating fair use claims must weigh the extent of these harms against the other factors, including the non-profit, educational character of Georgia State’s use. That’s exactly what the district court did. 

Hopefully the Eleventh Circuit will see through the publishers’ attempt to turn transformative use, which has been a boon to the public interest in copyright and fair use, into a bludgeon to crush educational uses.
