---
layout: post
published: true
comments: true
date: '2016-11-14 14:18 -0500'
title: Working the Ref on Copyright Office Reform
excerpt_separator: <!--more-->
---

Change is in the air in Washington, D.C., and everyone is talking about it. Of course I'm referring to the Copyright Office. The [Washington Post](https://www.washingtonpost.com/entertainment/music/with-change-at-the-top-of-copyright-office-a-battle-brews-over-free-content/2016/11/07/a8c0b140-a4ea-11e6-8042-f4d111c862d1_story.html?curator=MusicREDEF) and the [Wall Street Journal](http://www.wsj.com/articles/a-copyright-coup-in-washington-1478127088) have both run pieces full of wild speculation about sinister forces conspiring with the new Librarian of Congress, Dr. Carla Hayden, to change the guard at the Copyright Office in order to, like, undermine copyright as we know it, man. Libraries let people read books for free, Don Henley told the *Post*, so firing former Register of Copyrights Maria Pallante must be part of a library-tech conspiracy to suppress the royalty rates YouTube pays to songwriters. 

Wait, what?

The strangest thing about all this conspiracy theorizing (other than the WSJ calling Pallante a “patent defender”—wrong IP, dudes) is that it starts with the idea that the Librarian’s move is a mystery that can't be  explained by available facts. I don't have access to any insider info, but I don't think I need it: former Register Maria Pallante [didn't think she should be working for the Library](http://wsmblaw.com/a-declaration-of-independence-for-the-copyright-office/). The Librarian apparently agreed. The end. 

So what’s really going on?
<!--more-->

## A Little Context: The Register Declares Independence

Dr. Hayden recently reassigned Maria Pallante from her former position as Register of Copyrights to a new "senior advisor" position inside the Library. The move was widely seen as a roundabout way of firing Pallante, who promptly turned down the new position and resigned. 

The US Copyright Office sits in the Library of Congress, physically and administratively. The Copyright Act [provides](https://www.law.cornell.edu/uscode/text/17/701) that the "Register of Copyrights . . . shall act under the Librarian’s general direction and supervision." Nevertheless, some are scandalized by Pallante's ouster. They say it is shocking, unprecedented, and "troubling" for the Librarian to direct or supervise the Register.  

But Hayden’s decision comes after another unprecedented move: Pallante's public and repeated [calls for independence](http://www.bna.com/copyright-office-wants-n17179925131/) from the Library. This move, too, breaks with over a century of peaceful integration. 

Before Dr. Hayden took office, there was some cause for the Register to seek independence. The previous Librarian of Congress was, shall we say, [not super-engaged](https://www.washingtonpost.com/entertainment/museums/americas-national-library-is-behind-the-digital-curve-a-new-report-finds/2015/03/31/fad54c3a-d3fd-11e4-a62f-ee745911a4ff_story.html?tid=a_inl) in technology issues (or much of anything, it sounds like). One way to move more quickly to update the Office's crummy technology infrastructure would be to wrest control over it from a Librarian who was clearly dropping the ball. 

Dr. Hayden, by contrast, has made [technology a top priority](https://www.washingtonpost.com/news/arts-and-entertainment/wp/2016/04/20/librarian-of-congress-nominee-says-library-must-operate-seamlessly-in-digital-world/?tid=a_inl). It is certainly not clear that the dysfunction widely attributed to her predecessor will continue under her leadership. But control over budgets was just one aspect of Pallante’s case for independence. Alleged constitutional problems, a [paradigm shift](http://www.broadcastlawblog.com/2015/04/articles/copyright-office-calls-for-greater-independence-what-would-that-mean/) in copyright policymaking (from Congress- to agency-led), and a concomitant injection of power into the Office, were also in the mix. It seems likely, therefore, that her campaign would continue regardless of the change in leadership. This would be a dramatic challenge to a Librarian who wants to lead a “seamless” agency.

A friend made this analogy: Imagine if the head of the DEA had spent years agitating  to be independent from the Department of Justice, blaming the DOJ for its technology failures, claiming that its prerogatives were too important to be subject to DOJ oversight, and on and on. What would a new Attorney General likely do, and better sooner than later? What does a football team do when a player makes it clear he’d rather play for a rival? What does a country band do when the bassist wants to play ska? Hint: it's the President-elect's old catch-phrase.

## Reading Between the Lines

So what's the uproar really about? It's a signal from the content industries and their friends in Congress to Dr. Hayden: the Copyright Office works for us, not you. The Register of Copyrights must be a "champion” for just one part of the copyright system, not for the public, and certainly not for libraries. If Dr. Hayden appoints someone that these groups see as an outsider, the expressions of concern we’ve seen so far will look like mash notes. 

The hew and cry over Pallante's ouster is a remarkable admission that the content industry saw Pallante as *on their side* rather than as a neutral arbiter in the copyright ecosystem. Public Knowledge recently [documented](https://www.publicknowledge.org/press-release/public-knowledge-launches-report-on-systemic-bias-at-the-u.s.-copyright-office) the extent of the Office’s partisanship in recent copyright policy debates. Amazingly, the folks decrying Pallante’s exit have the chutzpah not only to agree that the Office has been on their side, but to insist that the next Register be their advocate, too. 

We Jeffersonians know better. [Copyright is not a natural right](http://thetaper.library.virginia.edu/2016/11/02/welcome-to-the-taper.html), entitled to protection at the expense of the public good. A government official who defends exclusive rights against the public interest has lost track of why we have copyright in the first place. Again, I doubt that's why Pallante was fired, but now that she's gone, Dr. Hayden has a rare opportunity to return balance to the system.

The Librarian of Congress is a tough lady; as her city erupted after the death of Freddie Gray, Hayden supported her staff’s impulse to [open the doors](https://americanlibrariesmagazine.org/blogs/the-scoop/qa-carla-hayden-baltimore/) of the Enoch Pratt Free Library to create a safe space for folks to gather, talk, and heal. She doesn't seem like someone you can bully, and suggesting she’s a puppet for Google or George Soros or whomever is maybe not the way to her heart. 

She has an opportunity to choose a Register that serves all of us, and I hope she will. I'll say more about what such a Register might need to know and understand in a future post.
