---
layout: post
published: true
comments: true
date: '2016-11-02 12:14 -0400'
title: Welcome to the Taper
---
Welcome to The Taper, a blog about copyright and related library policy issues as seen from my office at the [University of Virginia Library](http://library.virginia.edu), the spiritual (and, originally, the [physical](http://rotunda.virginia.edu/history)) heart of Thomas Jefferson’s “academical village.” I’m Brandon Butler, the new(-ish) Director of Information Policy for the Library, and I’ll be the blog’s primary author. It will also be my privilege to host guest posts from my colleagues at the Library and beyond, who will appear on these pages in the coming days and weeks to share their thoughts on the policy scene and let you know about all the cool stuff they are doing to foster a better-functioning ecosystem for teaching, learning, and scholarship, on Grounds and beyond. Read on for some thoughts on the blog's name and our Founder's founding insight. 

We are moving fast and breaking stuff, as they say, when it comes to the design of this blog. Fonts, headers, layout, and more are likely to change in coming days as we play with the [platform](https://jekyllrb.com "Jekyll homepage") we're using to host our posts. Bear with us, and pardon our progress.

I hope you’ll bookmark us, or subscribe to our feed, to get updates on our work and to hear what we think about the news of the day in the neighboring kingdoms of Library- and Copyrightland. <!--more-->

## The Taper: A Foundational Insight

In this inaugural post I want to say a word (or a few hundred…hang in there!) about the blog’s name. If you’ve had more than a glancing encounter with ideas of intellectual property and information policy, you have probably seen Thomas Jefferson’s [famous meditation](http://press-pubs.uchicago.edu/founders/print_documents/v1ch16s25.html) (from his [letter](http://founders.archives.gov/documents/Jefferson/03-06-02-0322) to Isaac McPherson, 1813) on the power of ideas to spread from one person to another, enriching all and depriving none. The heart of it, and the part that is most likely to end up on a t-shirt or bumper sticker, is this lovely simile:

> He who receives an idea from me, receives instruction himself without lessening mine; as he who lights his taper at mine, receives light without darkening me.

![“Candle” photo by The Bees]({{site.baseurl}}/images/2141536533_f8050c53c3_z.jpg)

*[”Candle”](https://www.flickr.com/photos/thebees/2141536533/in/photolist-4geWcF-4SvY1w-ccf3oL-4om4EZ-63UReh-9myrB9-bxLG9B-bsbkSo-9pghK9-7ZDWL9-i8b1Xg-beUneD-6xN1q1-9eDAB9-vgcr8-JkjYy-7iLLnZ-48f6Rh-e45w4S-953BZ8-9rDBPh-JkjZG-9efSth-4zDPhL-4SrJia-7PPGpo-4HSGWG-aJg3KB-rYVDD-8Nw6Tk-aDQ3X-fnnshd-7cAi5Q-5GRPAq-4sWiNh-4VGbe3-7uuQiZ-9KswAE-c6e5kG-7y2xyt-4k6wwv-cms5r-4fvhuN-byb9XN-4WJAY4-4CbG2b-7uJFRq-6BZnyc-2Dfycc-a1JGGd) by The Bees, [CC-BY-NC 2.0](https://creativecommons.org/licenses/by-nc/2.0/)*

Economists call this kind of stuff (ideas, knowledge, creative works, inventions), “[non-rival](https://en.wikipedia.org/wiki/Rivalry_(economics)),” because one person's enjoyment of them is not impeded by others' use. That’s why, as Nina Paley’s jaunty cartoon explains, [copying is not theft](https://www.youtube.com/watch?v=IeTybKL1pM4). But in some cases copying *is* an infringement of copyright. Why is that?

Well, don’t get me (or any copyright nerd) started. There are lots of possible explanations, and even lots of versions of the question. We could ask [what the Framers meant](https://cyber.harvard.edu/ip/oliar_ipclause.pdf) when they wrote [Article 1, Section 8, Clause 8](http://press-pubs.uchicago.edu/founders/tocs/a1_8_8.html) of the Constitution, the so-called IP Clause, which gives Congress the power to create copyright and patent laws. We could ask what the Congress (or the relevant committees, or the Copyright Office staff, or the private parties who negotiated various compromises in the statute, etc.) [intended to achieve](http://repository.law.umich.edu/articles/224/) by passing the Copyright Act of 1976, the last major re-write of the copyright system. Or we could ask [what normative justification](https://cyber.harvard.edu/people/tfisher/iptheory.pdf) there could be for any such law.  

While the taper argument in Jefferson’s letter to Isaac McPherson is sometimes cited in discussions about the historical question (and specifically about the [Patent Act of 1790](https://en.wikipedia.org/wiki/Patent_Act_of_1790), which he helped administer as one of the country’s first patent examiners), on its face it’s really an answer to the normative question: what can justify limits on the free circulation of knowledge? 

If you look at the rest of the passage, it may seem, at first, that Jefferson is arguing against any “property” at all in intangibles. He observes that plenty of countries do without patents but still see plenty of innovation (an insight that contemporary scholars like Chris Sprigman (who taught at UVA Law for a time) have [reinvigorated](https://www.law.virginia.edu/pdf/faculty/sprigman_piracy.pdf) with studies of so-called “negative spaces in IP” like fashion design). But Jefferson’s ultimate point is a bit subtler. 

We already had a system of economic monopolies on ideas by the time of this letter - Jefferson had helped design and administer it! The real question Jefferson is answering is whether there can be a “natural” property right in ideas:

> It has been pretended by some, (and in England especially,) that inventors have a natural and exclusive right to their inventions, and not merely for their own lives, but inheritable to their heirs. But while it is a moot question whether the origin of any kind of property is derived from nature at all, it would be singular to admit a natural and even an hereditary right to inventors.

After noting that property generally is “the gift of social law” and not nature, Jefferson argues that ideas in particular are a poor fit for the "natural rights" view. He makes the point by describing the way ideas spread: 

> If nature has made any one thing less susceptible than all others of exclusive property, it is the action of the thinking power called an idea, which an individual may exclusively possess as long as he keeps it to himself; but the moment it is divulged, it forces itself into the possession of every one, and the receiver cannot dispossess himself of it. Its peculiar character, too, is that no one possesses the less, because every other possesses the whole of it. He who receives an idea from me, receives instruction himself without lessening mine; as he who lights his taper at mine, receives light without darkening me. That ideas should freely spread from one to another over the globe, for the moral and mutual instruction of man, and improvement of his condition, seems to have been peculiarly and benevolently designed by nature, when she made them, like fire, expansible over all space, without lessening their density in any point, and like the air in which we breathe, move, and have our physical being, incapable of confinement or exclusive appropriation. Inventions then cannot, in nature, be a subject of property.

If ideas spread without limit in nature, Jefferson argues, then “natural law” cannot give control over ideas to their originators. Does that mean Jefferson believed that any regulation or limitation of the spread of ideas is unjustified? 

No. Instead, he describes a view that I share, and that I think has profound consequences for information policy: 

> Society may give an exclusive right to the profits arising from them, as an encouragement to men to pursue ideas which may produce utility, but this may or may not be done, according to the will and convenience of the society, without claim or complaint from anybody.

In other words, intellectual property laws should be grounded in the public interest, not in individual natural right. If awarding writers and inventors a bounty of limited control leads to more overall creative activity to the benefit of all, without overburdening public access to knowledge and information, then it will be justified. But there is no *natural right* to control the flow of ideas, which in nature would spread without limit. 

The internet has famously amplified this “natural” state of affairs, making the copying and proliferation of information instant and virtually costless at a staggering scale. The upside of the free flow of information has never been higher. The downside in terms of lost incentives to creative folks may be real, but it needs to be proven and balanced against the upside for the rest of us. 

We can argue about whether Jefferson was right, whether this was the theory of the Founders, whether it was the theory of the Congress in 1976, whether we should even [care](http://ssrn.com/abstract=892062) what Jefferson thought (well, others can argue it, but from [where I sit](http://www.virginia.edu) there’s no question!), and on and on. But Jefferson’s view—that the spread of knowledge is natural and good, and any limitation on that natural spread can only be justified by appeal to the public interest—has been extremely influential, and it is essentially the consensus view in the courts ([see, e.g.](https://scholar.google.com/scholar_case?case=9105652591497305710&q=%22Thomas+Jefferson%22+taper&hl=en&as_sdt=6,47#r[3])) and among copyright scholars.

Hence, the name of this blog, *The Taper*. Jefferson’s foundational insight will inform everything you see on these pages. Like many who work in this realm, Jefferson’s words certainly lit a flame in me. I hope my colleagues and I can pass it on. 

### Postscript(s)

This post is already too long, but if you’re curious, I had a few other things to say about Jefferson’s insight, and about the name of the blog:

First, in copyright doctrine there is something called the “idea-expression dichotomy” — copyright protects only the particular expression of an idea, not the abstract idea itself. You could argue that Jefferson’s insight is good as far as it goes, but copyright doesn’t protect ideas, anyway, so who cares? And isn’t Jefferson only really talking about patents? I don’t think either response lands, for a couple of reasons. First, the underlying economic insight about rivalry applies to both idea and expression. Second, in the scholarly context, ideas and knowledge are always wrapped up in an expressive container. Often the best, most efficient, or most reliable way to share complex information is in its original form. Any scholar can tell you the importance of encountering information and ideas in their original context; the separability of idea from expression is little comfort to the scholar or student who really wants to understand complex subject matter. 

Second, another possible meaning of a “taper” is someone who records something, like the [ignominious “home taper”](http://williampatry.blogspot.com/2008/01/what-riaa-has-said-about-home-taping.html) of the 1970s and ‘80s (and into the 90s, with the never-to-be-sufficiently-studied DAT technology), whose mix tapes and bootlegs were going to [destroy the recording industry](http://www.metalinjection.net/wp-content/uploads/2012/03/Dead-Kennedys-Home-Taping-Is-Killing-Record-Industry-Profits.jpeg "The DKs are here to help."). 

There’s something to be said for keeping that person in mind, too, as we think about the information ecosystem. Jefferson himself [argued](https://www.lockss.org/about/) that proliferating copies far and wide was an important form of historic preservation: 

 > “[L]et us save what remains: not by vaults and locks which fence them from the public eye and use in consigning them to the waste of time, but by such a multiplication of copies, as shall place them beyond the reach of accident.”
 
 More than a few historic works have been saved thanks to the pack-rats and home tapers out there. Libraries are tapers in this sense, too: we make copies to preserve and serve the cultural record. 
 
 More to come!
