---
layout: post
published: true
comments: true
date: '2016-11-04 10:00 -0400'
title: Compromised? Responding to Department of Energy’s “Grand Compromise”
categories:
  - open access
  - federal funding
  - NIH
  - OSTP
excerpt_separator: <!--more-->
---
*In this guest post, UVA Open Publishing Librarian Dave Ghamandi provides commentary on the state of the federal government's open access policies, and in particular a response to the Department of Energy's recent blog post on the "compromises" involved in working with publishers to provide open access to federally-funded scholarship. It's important to applaud our friends in government when they move in the right direction—and they have certainly done that, as Jerry Sheehan's recent Open Access Week [round-up](https://www.whitehouse.gov/blog/2016/10/28/federally-funded-research-results-are-becoming-more-open-and-accessible) makes clear. But Dave's message here is equally important: we must also question dubious compromises and half-measures along the way, before they harden into accepted practice.* <!--more-->

Despite my general disappointment with the Obama administration, there have been some commendable actions: ending some of the worse abuses of credit card companies and the health insurance industry; halting the deportation of the young DREAMers; and more relevantly, issuing the 2013 memorandum on “[Increasing Access to the Results of Federally Funded Scientific Research](https://www.whitehouse.gov/sites/default/files/microsites/ostp/ostp_public_access_memo_2013.pdf).” 

The Administration should be applauded for requiring public access to peer-reviewed publications and data that result from federally funded scientific research.  The technology to grant the public (who are more than just taxpayers) access to this research has been around for a long time, and the NIH has been providing worldwide access to their research since 2008.  

However, while taking a critical look at the OSTP’s justification for the memo, public access was mentioned less as a public good—one that strengthens a democratic public sphere—and more as a commercial gain: “research…catalyzes innovating breakthroughs that drive our economy,” “wider availability of peer-reviewed publications…will create innovative economic markets, “[the policy] will … promote entrepreneurship, and enhance economic growth and job creation.”

  


Last month, in [a post on OSTI’s blog](https://www.osti.gov/us-public-access-programs-going-green), Jeffrey Salmon, Deputy Director for Resource Management in the Department of Energy Office of Science, echoed many of the comments that Jerry Sheehan, Assistant Director at OSTP, made at [COASP8](http://oaspa.org/conference/coasp-2016-program/).  The post (cheerfully titled, “The Grand Compromise of U.S. Public Access Programs: Going Green”), like Sheehan’s talk, ostensibly provides readers with a general update, but its omissions and unspoken assumptions necessitate this critical response:

  


  * Public access isn’t synonymous with open access.  That needs to be repeated often.  Public access isn’t synonymous with open access because the latter removes price barriers and most restrictions on use.  However, federal agencies are only required to provide access to the manuscripts and data without charge.  Many of the articles will still have copyright protections that don’t permit liberal use of the article.

  


  * Salmon refers to the 12-month embargo as a “grand compromise” and “a proven formula,” but does not provide a convincing justification.  Why not embargo for only nine months?  Or six months?  His attempt to rebrand an embargo as an “administrative interval” indicates an awareness that the public disapproves of this lengthy delay in access.  Disappointingly, Salmon points to the NIH Public Access Policy’s 12-month embargo (itself not justified) as precedent.  A year-long embargo on health information (ex. the latest Zika research) discovered with public funding is morally unjustifiable.

  


  * The OSTP memo explicitly encourages “public-private collaboration.”  This immediately and unfairly advantages the commercial publishers and their consortium, CHORUS.  Both Salmon and Sheehan neglect to mention SHARE, the community-driven initiative that federal agencies should be partnering with.  Instead, DOE PAGES will redirect users to publishers’ websites to read the articles.  Agencies that take this approach are outsourcing their responsibilities to many of the players who created the problem that makes the OSTP memo necessary.  DOE should’ve modeled PAGES on NIH’s PubMed Central, where readers can directly access, read, download, and share manuscripts in one publically owned and controlled location.

  


  * Salmon, like many publishers, conflates gold OA with “author pays.”  This misinformation is damaging to the OA movement because most OA journals do not have author fees.  

  


  * While Salmon “appreciates the essential value and role of publishing and peer review” he fails to mention that publishers merely coordinate the review and that virtually all peer reviewers work for free.

  


  * Finally, there are several details omitted when Salmon says “publishers have options for enabling researchers to view individual articles [during the 12-month embargo], and libraries…understand and serve their communities’ needs.”  Yes, options are technically available, but it’s often a $49 paywall to read a single article.  And libraries, if they can even afford digital access to these articles, are restricted by publishers on who they can allow to read and use the literature.

  


Open access is a public good and, because it represents non-market values, requires a cultural change.  The OSTP policy is only a partial victory because it commercializes the conversation about public access, fails to implicate publishers in the journal affordability problem, and, most importantly, does not provide truly open access to the results of publically-funded research.
